/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.albireo.core.SwingControl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GlobalFocusHandler {
    private static final String SAVED_FOCUS_OWNER_KEY = "org.eclipse.albireo.savedFocusOwner";
    private final Display display;
    private final SwtEventFilter swtEventFilter;
    private final List listeners = new ArrayList();
    private static final boolean verboseFocusEvents = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.internal.GlobalFocusHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GlobalFocusHandler(Display display) {
        this.display = display;
        this.swtEventFilter = new SwtEventFilter();
        display.addFilter(26, (Listener)this.swtEventFilter);
        display.addFilter(27, (Listener)this.swtEventFilter);
        display.addFilter(31, (Listener)this.swtEventFilter);
    }

    public int getCurrentSwtTraversal() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.currentSwtTraversal;
    }

    public Widget getActiveWidget() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.activeWidget;
    }

    public Shell getActiveShell() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.activeShell;
    }

    public SwingControl getActiveEmbedded() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.activeEmbedded;
    }

    public Widget getLastActiveWidget() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.lastActiveWidget;
    }

    public SwingControl getLastActiveEmbedded() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.lastActiveEmbedded;
    }

    public boolean getLastActiveFocusCleared() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        return this.swtEventFilter.lastActiveFocusCleared;
    }

    public void setLastActiveFocusCleared(boolean bl) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        this.swtEventFilter.lastActiveFocusCleared = bl;
    }

    public void addEventFilter(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeEventFilter(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void fireEvent(Event event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            listener.handleEvent(event);
        }
    }

    public void dispose() {
        this.display.removeFilter(26, (Listener)this.swtEventFilter);
        this.display.removeFilter(27, (Listener)this.swtEventFilter);
        this.display.removeFilter(31, (Listener)this.swtEventFilter);
    }

    protected boolean isBorderlessSwingControl(Widget widget) {
        return widget instanceof SwingControl && (widget.getStyle() & 0x1000000) != 0;
    }

    protected void clearFocusOwner(SwingControl swingControl) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (!swingControl.isAWTPermanentFocusLossForced()) {
            return;
        }
        final Component component = ((Frame)swingControl.getAWTHierarchyRoot()).getFocusOwner();
        if (component != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    if (component == keyboardFocusManager.getFocusOwner()) {
                        keyboardFocusManager.clearGlobalFocusOwner();
                    } else {
                        component.setEnabled(false);
                        component.setEnabled(true);
                    }
                }
            });
            swingControl.setData(SAVED_FOCUS_OWNER_KEY, component);
        }
    }

    protected void restoreFocusOwner(SwingControl swingControl) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        final Component component = (Component)swingControl.getData(SAVED_FOCUS_OWNER_KEY);
        if (component != null) {
            swingControl.setData(SAVED_FOCUS_OWNER_KEY, null);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    component.requestFocus();
                }
            });
        }
    }

    private void trace(String string) {
        System.err.println(String.valueOf(this.header()) + ' ' + string);
    }

    private String header() {
        return "@" + System.currentTimeMillis() + " " + System.identityHashCode(this);
    }

    protected class SwtEventFilter
    implements Listener {
        int currentSwtTraversal = 0;
        Widget activeWidget;
        Shell activeShell;
        SwingControl activeEmbedded;
        Widget lastActiveWidget = null;
        SwingControl lastActiveEmbedded = null;
        boolean lastActiveFocusCleared = false;

        public SwtEventFilter() {
            this.activeWidget = GlobalFocusHandler.this.display.getFocusControl();
            this.activeShell = GlobalFocusHandler.this.display.getActiveShell();
            if (GlobalFocusHandler.this.isBorderlessSwingControl(this.activeWidget)) {
                this.activeEmbedded = (SwingControl)this.activeWidget;
            }
        }

        public void handleEvent(Event event) {
            Widget widget = event.widget;
            switch (event.type) {
                case 26: {
                    this.activeWidget = widget;
                    if (widget instanceof Shell) {
                        this.activeShell = (Shell)widget;
                    }
                    if (this.lastActiveEmbedded != null && !this.lastActiveEmbedded.isDisposed() && this.lastActiveEmbedded != widget && !this.lastActiveFocusCleared && widget instanceof Control && this.lastActiveEmbedded.getShell() == ((Control)widget).getShell()) {
                        GlobalFocusHandler.this.clearFocusOwner(this.lastActiveEmbedded);
                        this.lastActiveFocusCleared = true;
                    }
                    if (!GlobalFocusHandler.this.isBorderlessSwingControl(widget)) break;
                    this.activeEmbedded = (SwingControl)widget;
                    GlobalFocusHandler.this.restoreFocusOwner(this.activeEmbedded);
                    break;
                }
                case 27: {
                    if (this.activeWidget != null) {
                        this.lastActiveWidget = this.activeWidget;
                        this.activeWidget = null;
                    }
                    if (event.widget instanceof Shell) {
                        this.activeShell = null;
                    }
                    if (!GlobalFocusHandler.this.isBorderlessSwingControl(widget) || this.activeEmbedded == null) break;
                    this.lastActiveEmbedded = this.activeEmbedded;
                    this.lastActiveFocusCleared = false;
                    this.activeEmbedded = null;
                    break;
                }
                case 31: {
                    this.currentSwtTraversal = event.detail;
                }
            }
            GlobalFocusHandler.this.fireEvent(event);
            if (event.type == 26) {
                this.currentSwtTraversal = 0;
            }
        }
    }
}

