/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.eclipse.albireo.core.SwingControl;
import org.eclipse.albireo.core.ThreadingHandler;
import org.eclipse.albireo.internal.GlobalFocusHandler;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FocusHandler {
    public static final boolean verboseFocusEvents = false;
    public static final boolean verboseKFHEvents = false;
    public static final boolean verboseTraverseOut = false;
    private static boolean synthesizeMethodInitialized;
    private static Method synthesizeMethod;
    private final Frame frame;
    private final Composite borderless;
    private final SwingControl swingControl;
    private final Display display;
    private final GlobalFocusHandler globalHandler;
    private boolean pendingTraverseOut = false;
    private int pendingTraverseOutSeqNum = 0;
    private int currentTraverseOutSeqNum = 0;
    private int extraTabCount = 0;
    private boolean isFocusedSwt;
    private boolean pendingDeactivate = false;
    private KeyEventDispatcher keyEventDispatcher = new AwtKeyDispatcher();
    private WindowFocusListener awtWindowFocusListener = new AwtWindowFocusListener();
    private FocusListener swtFocusListener = new SwtFocusListener();
    private Listener swtEventFilter = new SwtEventFilter();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.internal.FocusHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        synthesizeMethodInitialized = false;
        synthesizeMethod = null;
    }

    public FocusHandler(SwingControl swingControl, GlobalFocusHandler globalFocusHandler, Composite composite, Frame frame) {
        this.globalHandler = globalFocusHandler;
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        this.swingControl = swingControl;
        this.borderless = composite;
        this.frame = frame;
        this.display = swingControl.getDisplay();
        this.getSynthesizeMethod(frame.getClass());
        globalFocusHandler.addEventFilter(this.swtEventFilter);
        frame.addWindowFocusListener(this.awtWindowFocusListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keyEventDispatcher);
        composite.addFocusListener(this.swtFocusListener);
    }

    public void dispose() {
        this.globalHandler.removeEventFilter(this.swtEventFilter);
        this.frame.removeWindowFocusListener(this.awtWindowFocusListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keyEventDispatcher);
        this.borderless.removeFocusListener(this.swtFocusListener);
    }

    protected void hideTextSelection() {
        Caret caret;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Component component = this.frame.getMostRecentFocusOwner();
        if (component instanceof JTextComponent && (caret = ((JTextComponent)component).getCaret()) != null) {
            caret.setSelectionVisible(false);
        }
    }

    protected boolean checkForTraverseOut(KeyEvent keyEvent) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.frame.isFocused()) {
            Set<AWTKeyStroke> set = this.frame.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = this.frame.getFocusTraversalKeys(1);
            AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
            if (!this.pendingTraverseOut) {
                Component component = this.frame.getFocusTraversalPolicy().getLastComponent(this.frame);
                if (set.contains(aWTKeyStroke) && (component == keyEvent.getComponent() || component == null)) {
                    this.pendingTraverseOut = true;
                    ++this.pendingTraverseOutSeqNum;
                    this.swtTraverse(16, 1, false);
                    keyEvent.consume();
                    return true;
                }
                component = this.frame.getFocusTraversalPolicy().getFirstComponent(this.frame);
                if (set2.contains(aWTKeyStroke) && (component == keyEvent.getComponent() || component == null)) {
                    this.pendingTraverseOut = true;
                    ++this.pendingTraverseOutSeqNum;
                    this.swtTraverse(8, 1, false);
                    keyEvent.consume();
                    return true;
                }
            } else {
                if (set.contains(aWTKeyStroke)) {
                    ++this.extraTabCount;
                    keyEvent.consume();
                    return true;
                }
                if (set2.contains(aWTKeyStroke)) {
                    --this.extraTabCount;
                    keyEvent.consume();
                    return true;
                }
            }
        }
        return false;
    }

    protected void processTypeAheadKeys(int n) {
        if (this.pendingTraverseOut && this.extraTabCount != 0) {
            if (n != this.currentTraverseOutSeqNum + 1) {
                return;
            }
            int n2 = this.extraTabCount > 0 ? 16 : 8;
            this.swtTraverse(n2, Math.abs(this.extraTabCount), true);
        }
        this.pendingTraverseOut = false;
        ++this.currentTraverseOutSeqNum;
        this.extraTabCount = 0;
    }

    protected void swtTraverse(final int n, final int n2, final boolean bl) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        ThreadingHandler.getInstance().asyncExec(this.display, new Runnable(){

            public void run() {
                int n3 = 0;
                while (n3 < n2) {
                    FocusHandler.this.doTraverse(n, bl, FocusHandler.this.pendingTraverseOutSeqNum);
                    ++n3;
                }
            }
        });
    }

    protected void doTraverse(int n, boolean bl, final int n2) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        Object object = this.display.getFocusControl();
        SwingControl swingControl = this.globalHandler.getActiveEmbedded();
        if (object == null && swingControl != null) {
            object = swingControl;
        }
        if (object != null) {
            boolean bl2 = object.traverse(n);
            Control control = this.display.getFocusControl();
            if (bl2 && control == object && control == swingControl) {
                if (!bl) {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            FocusHandler.this.processTypeAheadKeys(n2);
                        }
                    });
                }
                this.adjustFocusForSwtTraversal(n);
            }
        }
    }

    public boolean handleForceFocus(boolean bl) {
        if (Platform.isWin32() && !bl && this.globalHandler.getActiveWidget() == this.borderless && this.isFocusedSwt) {
            bl = true;
        }
        return bl;
    }

    protected void synthesizeWindowActivation(final boolean bl) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !Platform.isWin32()) {
            throw new AssertionError();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (synthesizeMethod != null) {
                    try {
                        if (synthesizeMethod != null) {
                            synthesizeMethod.invoke((Object)FocusHandler.this.frame, new Boolean(bl));
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        FocusHandler.this.handleSynthesizeException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        FocusHandler.this.handleSynthesizeException(invocationTargetException);
                    }
                } else if (bl) {
                    FocusHandler.this.frame.dispatchEvent(new WindowEvent(FocusHandler.this.frame, 205));
                    FocusHandler.this.frame.dispatchEvent(new WindowEvent(FocusHandler.this.frame, 207));
                } else {
                    FocusHandler.this.frame.dispatchEvent(new WindowEvent(FocusHandler.this.frame, 208));
                    FocusHandler.this.frame.dispatchEvent(new WindowEvent(FocusHandler.this.frame, 206));
                }
            }
        });
    }

    private void getSynthesizeMethod(Class clazz) {
        if (Platform.isWin32() && !synthesizeMethodInitialized) {
            synthesizeMethodInitialized = true;
            try {
                synthesizeMethod = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.handleSynthesizeException(noSuchMethodException);
            }
        }
    }

    private void handleSynthesizeException(Exception exception) {
    }

    protected void adjustFocusForSwtTraversal(int n) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (!this.swingControl.isSwtTabOrderExtended()) {
            return;
        }
        switch (n) {
            case 16: 
            case 64: 
            case 512: {
                this.setInitialTraversalFocus(true);
                break;
            }
            case 8: 
            case 32: 
            case 256: {
                this.setInitialTraversalFocus(false);
            }
        }
    }

    protected void setInitialTraversalFocus(final boolean bl) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Component component = bl ? FocusHandler.this.frame.getFocusTraversalPolicy().getFirstComponent(FocusHandler.this.frame) : FocusHandler.this.frame.getFocusTraversalPolicy().getLastComponent(FocusHandler.this.frame);
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    public void activateEmbeddedFrame() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        Shell shell = this.globalHandler.getActiveShell();
        SwingControl swingControl = this.globalHandler.getActiveEmbedded();
        if (!(this.borderless.isDisposed() || shell != this.borderless.getShell() || this.borderless != this.display.getFocusControl() || swingControl != null && swingControl != this.borderless)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Component component = FocusHandler.this.frame.getMostRecentFocusOwner();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            });
        }
    }

    protected void doActivation(int n) {
        if (this.swingControl.isDisposed()) {
            return;
        }
        if (!this.swingControl.isFocusControl()) {
            return;
        }
        if (Platform.isWin32() && this.pendingDeactivate) {
            this.synthesizeWindowActivation(false);
            this.pendingDeactivate = false;
        }
        if (Platform.isWin32() && synthesizeMethod != null) {
            this.synthesizeWindowActivation(true);
        }
        this.adjustFocusForSwtTraversal(n);
    }

    private void trace(String string) {
        System.err.println(String.valueOf(this.header()) + ' ' + string);
    }

    private String header() {
        return "@" + System.currentTimeMillis() + " " + System.identityHashCode(this);
    }

    protected class AwtKeyDispatcher
    implements KeyEventDispatcher {
        protected AwtKeyDispatcher() {
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            if (Platform.isWin32()) {
                bl = FocusHandler.this.checkForTraverseOut(keyEvent);
            }
            return bl;
        }
    }

    protected class AwtWindowFocusListener
    implements WindowFocusListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.albireo.internal.FocusHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        protected AwtWindowFocusListener() {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (!$assertionsDisabled && FocusHandler.this.pendingTraverseOut) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && FocusHandler.this.extraTabCount != 0) {
                throw new AssertionError();
            }
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            if (Platform.isWin32()) {
                FocusHandler.this.hideTextSelection();
                FocusHandler.this.processTypeAheadKeys(FocusHandler.this.pendingTraverseOutSeqNum);
            }
        }
    }

    protected class SwtEventFilter
    implements Listener {
        protected SwtEventFilter() {
        }

        public void handleEvent(Event event) {
            if (event.widget == FocusHandler.this.borderless) {
                switch (event.type) {
                    case 26: {
                        int n = FocusHandler.this.globalHandler.getCurrentSwtTraversal();
                        FocusHandler.this.display.asyncExec(new Runnable(this, n){
                            final /* synthetic */ SwtEventFilter this$1;
                            private final /* synthetic */ int val$swtTraversal;
                            {
                                this.this$1 = swtEventFilter;
                                this.val$swtTraversal = n;
                            }

                            public void run() {
                                SwtEventFilter.access$0(this.this$1).doActivation(this.val$swtTraversal);
                            }
                        });
                        if (!Platform.isWin32() || synthesizeMethod == null) break;
                        event.type = 0;
                        break;
                    }
                    case 27: {
                        if (!Platform.isWin32() || synthesizeMethod == null) break;
                        FocusHandler.this.pendingDeactivate = true;
                        event.type = 0;
                    }
                }
            }
        }

        static /* synthetic */ FocusHandler access$0(SwtEventFilter swtEventFilter) {
            return swtEventFilter.FocusHandler.this;
        }
    }

    protected class SwtFocusListener
    implements FocusListener {
        protected SwtFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            FocusHandler.this.isFocusedSwt = true;
        }

        public void focusLost(FocusEvent focusEvent) {
            FocusHandler.this.isFocusedSwt = false;
        }
    }
}

