/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FocusDebugging {
    private static SWTFocusListener _SWTFocusListener = new SWTFocusListener();
    private static SWTActivationListener _SWTActivationListener = new SWTActivationListener();
    private static AWTWindowFocusListener _AWTWindowFocusListener = new AWTWindowFocusListener();
    private static AWTFocusListener _AWTFocusListener = new AWTFocusListener();
    private static AWTContainerListener _AWTContainerListener = new AWTContainerListener();

    public static void addFocusDebugListeners(Composite composite, Container container) {
        composite.addFocusListener((org.eclipse.swt.events.FocusListener)_SWTFocusListener);
        composite.addListener(26, (Listener)_SWTActivationListener);
        composite.addListener(27, (Listener)_SWTActivationListener);
        if (container instanceof Window) {
            ((Window)container).addWindowFocusListener(_AWTWindowFocusListener);
        }
        FocusDebugging.addFocusListenerToTree(container);
    }

    static void addFocusListenerToTree(Component component) {
        component.addFocusListener(_AWTFocusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(_AWTContainerListener);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                FocusDebugging.addFocusListenerToTree(container.getComponent(n2));
                ++n2;
            }
        }
    }

    static void removeFocusListenerFromTree(Component component) {
        component.removeFocusListener(_AWTFocusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(_AWTContainerListener);
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                FocusDebugging.removeFocusListenerFromTree(container.getComponent(n2));
                ++n2;
            }
        }
    }

    public static void enableKeyboardFocusManagerLogging() {
        FocusDebugging.enableFinest("java.awt.focus.KeyboardFocusManager");
        FocusDebugging.enableFinest("java.awt.focus.DefaultKeyboardFocusManager");
    }

    private static void enableFinest(String string) {
        Logger logger = Logger.getLogger(string);
        logger.setLevel(Level.FINEST);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.FINEST);
        logger.addHandler(consoleHandler);
    }

    private static class AWTContainerListener
    implements ContainerListener {
        private AWTContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            FocusDebugging.addFocusListenerToTree(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            FocusDebugging.removeFocusListenerFromTree(containerEvent.getChild());
        }
    }

    private static class AWTFocusListener
    implements FocusListener {
        private AWTFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            System.err.println("@" + System.currentTimeMillis() + " AWT focus gained " + focusEvent.getComponent());
        }

        public void focusLost(FocusEvent focusEvent) {
            System.err.println("@" + System.currentTimeMillis() + " AWT focus lost " + focusEvent.getComponent());
        }
    }

    private static class AWTWindowFocusListener
    implements WindowFocusListener {
        private AWTWindowFocusListener() {
        }

        private void showKFMStatus(Window window) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            System.err.println("               permanentFocusOwner: " + keyboardFocusManager.getPermanentFocusOwner());
            System.err.println("               focusOwner:          " + keyboardFocusManager.getFocusOwner());
            System.err.println("               window's focusOwner: " + window.getFocusOwner());
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            System.err.println("@" + System.currentTimeMillis() + " AWT focus gained by window " + windowEvent.getWindow());
            this.showKFMStatus(windowEvent.getWindow());
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            System.err.println("@" + System.currentTimeMillis() + " AWT focus lost by window " + windowEvent.getWindow());
            this.showKFMStatus(windowEvent.getWindow());
        }
    }

    private static class SWTActivationListener
    implements Listener {
        private SWTActivationListener() {
        }

        public void handleEvent(Event event) {
            String string = null;
            switch (event.type) {
                case 27: {
                    string = "Deactivate";
                    break;
                }
                case 26: {
                    string = "Activate";
                }
            }
            System.err.println("@" + System.currentTimeMillis() + " SWT Event: " + string + " " + System.identityHashCode(event.widget));
        }
    }

    private static class SWTFocusListener
    implements org.eclipse.swt.events.FocusListener {
        private SWTFocusListener() {
        }

        public void focusGained(org.eclipse.swt.events.FocusEvent focusEvent) {
            System.err.println("@" + System.currentTimeMillis() + " SWT focus gained " + focusEvent.getSource().hashCode());
        }

        public void focusLost(org.eclipse.swt.events.FocusEvent focusEvent) {
            System.err.println("@" + System.currentTimeMillis() + " SWT focus lost " + focusEvent.getSource().hashCode());
        }
    }
}

