/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.internal;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.albireo.core.ThreadingHandler;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.albireo.internal.SwtInputBlocker;
import org.eclipse.swt.widgets.Display;

public class AwtDialogListener
implements AWTEventListener,
ComponentListener,
WindowFocusListener {
    private static boolean verboseModalityHandling;
    protected static boolean USING_ALWAYS_ON_TOP;
    private static boolean alwaysOnTopMethodsInitialized;
    private static Method setAlwaysOnTopMethod;
    private static Method isAlwaysOnTopMethod;
    private final List modalDialogs = new ArrayList();
    private final Display display;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.internal.AwtDialogListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        verboseModalityHandling = false;
        USING_ALWAYS_ON_TOP = Platform.isGtk() && Platform.JAVA_VERSION >= Platform.javaVersion(1, 5, 0);
        alwaysOnTopMethodsInitialized = false;
        setAlwaysOnTopMethod = null;
        isAlwaysOnTopMethod = null;
    }

    public AwtDialogListener(Display display) {
        if (!$assertionsDisabled && display == null) {
            throw new AssertionError();
        }
        if (USING_ALWAYS_ON_TOP) {
            this.getAlwaysOnTopMethods();
        }
        this.display = display;
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    protected void getAlwaysOnTopMethods() {
        if (!alwaysOnTopMethodsInitialized) {
            alwaysOnTopMethodsInitialized = true;
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                setAlwaysOnTopMethod = clazz.getMethod("setAlwaysOnTop", Boolean.TYPE);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                isAlwaysOnTopMethod = clazz2.getMethod("isAlwaysOnTop", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.handleAlwaysOnTopException(noSuchMethodException);
            }
        }
    }

    protected void setAlwaysOnTop(Window window, boolean bl) {
        if (!$assertionsDisabled && setAlwaysOnTopMethod == null) {
            throw new AssertionError();
        }
        try {
            if (verboseModalityHandling) {
                System.err.println("Calling setAlwaysOnTop(" + bl + ") for " + window);
            }
            setAlwaysOnTopMethod.invoke((Object)window, new Boolean(bl));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.handleAlwaysOnTopException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleAlwaysOnTopException(invocationTargetException);
        }
    }

    protected boolean isAlwaysOnTop(Window window) {
        if (!$assertionsDisabled && isAlwaysOnTopMethod == null) {
            throw new AssertionError();
        }
        try {
            if (verboseModalityHandling) {
                System.err.println("Calling isAlwaysOnTop() for " + window);
            }
            Object object = isAlwaysOnTopMethod.invoke((Object)window, new Object[0]);
            return (Boolean)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.handleAlwaysOnTopException(illegalAccessException);
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleAlwaysOnTopException(invocationTargetException);
            return false;
        }
    }

    protected void handleAlwaysOnTopException(Exception exception) {
        if (verboseModalityHandling) {
            exception.printStackTrace();
        }
    }

    private void handleRemovedDialog(Dialog dialog, boolean bl) {
        if (!$assertionsDisabled && dialog == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.modalDialogs == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.display == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (verboseModalityHandling) {
            System.err.println("Remove dialog: " + dialog);
        }
        if (bl) {
            dialog.removeComponentListener(this);
            if (USING_ALWAYS_ON_TOP) {
                dialog.removeWindowFocusListener(this);
            }
        }
        if (this.modalDialogs.remove(dialog)) {
            ThreadingHandler.getInstance().asyncExec(this.display, new Runnable(){

                public void run() {
                    SwtInputBlocker.unblock();
                }
            });
        }
    }

    private void handleAddedDialog(Dialog dialog) {
        if (!$assertionsDisabled && dialog == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.modalDialogs == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (verboseModalityHandling) {
            System.err.println("Add dialog: " + dialog);
        }
        if (this.modalDialogs.contains(dialog) || !dialog.isModal() || !dialog.isVisible()) {
            return;
        }
        this.modalDialogs.add(dialog);
        dialog.addComponentListener(this);
        if (USING_ALWAYS_ON_TOP && !this.isAlwaysOnTop(dialog)) {
            dialog.addWindowFocusListener(this);
        }
        ThreadingHandler.getInstance().asyncExec(this.display, new Runnable(){

            public void run() {
                SwtInputBlocker.block(AwtDialogListener.this);
            }
        });
    }

    void requestFocus() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!$assertionsDisabled && AwtDialogListener.this.modalDialogs == null) {
                    throw new AssertionError();
                }
                int n = AwtDialogListener.this.modalDialogs.size();
                if (n > 0) {
                    Dialog dialog = (Dialog)AwtDialogListener.this.modalDialogs.get(n - 1);
                    Component component = dialog.getMostRecentFocusOwner();
                    if (verboseModalityHandling) {
                        System.err.println("Bringing to front, focusOwner=" + component);
                    }
                    if (component == null) {
                        component = dialog;
                    }
                    try {
                        component.requestFocus();
                        dialog.toFront();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        });
    }

    private void handleOpenedWindow(WindowEvent windowEvent) {
        if (!$assertionsDisabled && windowEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Window window = windowEvent.getWindow();
        if (window instanceof Dialog) {
            this.handleAddedDialog((Dialog)window);
        }
    }

    private void handleClosedWindow(WindowEvent windowEvent) {
        if (!$assertionsDisabled && windowEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Window window = windowEvent.getWindow();
        if (window instanceof Dialog) {
            this.handleRemovedDialog((Dialog)window, true);
        }
    }

    private void handleClosingWindow(WindowEvent windowEvent) {
        if (!$assertionsDisabled && windowEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Window window = windowEvent.getWindow();
        if (window instanceof Dialog) {
            final Dialog dialog = (Dialog)window;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AwtDialogListener.this.handleRemovedDialog(dialog, true);
                }
            });
        }
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!$assertionsDisabled && aWTEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        switch (aWTEvent.getID()) {
            case 200: {
                this.handleOpenedWindow((WindowEvent)aWTEvent);
                break;
            }
            case 202: {
                this.handleClosedWindow((WindowEvent)aWTEvent);
                break;
            }
            case 201: {
                this.handleClosingWindow((WindowEvent)aWTEvent);
                break;
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
        Object object;
        if (!$assertionsDisabled && componentEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (verboseModalityHandling) {
            System.err.println("Component hidden");
        }
        if ((object = componentEvent.getSource()) instanceof Dialog) {
            this.handleRemovedDialog((Dialog)object, false);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        Object object;
        if (!$assertionsDisabled && componentEvent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (verboseModalityHandling) {
            System.err.println("Component shown");
        }
        if ((object = componentEvent.getSource()) instanceof Dialog) {
            this.handleAddedDialog((Dialog)object);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        if (!$assertionsDisabled && !USING_ALWAYS_ON_TOP) {
            throw new AssertionError();
        }
        this.setAlwaysOnTop(windowEvent.getWindow(), true);
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        if (!$assertionsDisabled && !USING_ALWAYS_ON_TOP) {
            throw new AssertionError();
        }
        this.setAlwaysOnTop(windowEvent.getWindow(), false);
    }
}

