/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.core;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class ThreadingHandler {
    private boolean reportingAsyncExecExceptions = true;
    private static ThreadingHandler theHandler = new ThreadingHandler();

    public boolean isReportingAsyncExecExceptions() {
        return this.reportingAsyncExecExceptions;
    }

    public void setReportingAsyncExecExceptions(boolean bl) {
        this.reportingAsyncExecExceptions = bl;
    }

    public void asyncExec(Display display, final Runnable runnable) {
        Runnable runnable2 = this.isReportingAsyncExecExceptions() ? new Runnable(){

            public void run() {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    throw runtimeException;
                }
                catch (Error error) {
                    error.printStackTrace();
                    throw error;
                }
            }
        } : runnable;
        try {
            display.asyncExec(runnable2);
        }
        catch (NullPointerException nullPointerException) {
            StackTraceElement[] stackTraceElementArray = nullPointerException.getStackTrace();
            if (stackTraceElementArray.length > 0 && "org.eclipse.swt.widgets.Display".equals(stackTraceElementArray[0].getClassName()) && "asyncExec".equals(stackTraceElementArray[0].getMethodName())) {
                SWTException sWTException = new SWTException(45);
                sWTException.throwable = nullPointerException;
                throw sWTException;
            }
            throw nullPointerException;
        }
    }

    public static ThreadingHandler getInstance() {
        return theHandler;
    }

    public static void setInstance(ThreadingHandler threadingHandler) {
        theHandler = threadingHandler;
    }
}

