/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.core;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;

public class SwtKeystroke {
    private final int eventType;
    private final int keyCode;
    private final int stateMask;

    public SwtKeystroke(int n, int n2, int n3) {
        if (n != 1 && n != 2) {
            SWT.error((int)5);
        }
        this.eventType = n;
        this.keyCode = n2;
        this.stateMask = n3;
    }

    public SwtKeystroke(int n, KeyEvent keyEvent) {
        this.eventType = n;
        this.keyCode = keyEvent.keyCode;
        this.stateMask = keyEvent.stateMask;
    }

    public SwtKeystroke(Event event) {
        this.eventType = event.type;
        this.keyCode = event.keyCode;
        this.stateMask = event.stateMask;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.eventType;
        n = 31 * n + this.keyCode;
        n = 31 * n + this.stateMask;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SwtKeystroke swtKeystroke = (SwtKeystroke)object;
        if (this.eventType != swtKeystroke.eventType) {
            return false;
        }
        if (this.keyCode != swtKeystroke.keyCode) {
            return false;
        }
        return this.stateMask == swtKeystroke.stateMask;
    }

    public String toString() {
        return "key: type=" + this.eventType + ", code=" + this.keyCode + ", stateMask=" + this.stateMask;
    }
}

