/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.eclipse.albireo.core.AwtEnvironment;
import org.eclipse.albireo.core.LookAndFeelHandler;
import org.eclipse.albireo.core.ResourceConverter;
import org.eclipse.albireo.core.SizeEvent;
import org.eclipse.albireo.core.SizeListener;
import org.eclipse.albireo.core.SwtKeystroke;
import org.eclipse.albireo.core.SwtPopupRegistry;
import org.eclipse.albireo.core.ThreadingHandler;
import org.eclipse.albireo.internal.CleanResizeListener;
import org.eclipse.albireo.internal.FocusHandler;
import org.eclipse.albireo.internal.GlobalFocusHandler;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.albireo.internal.RunnableWithResult;
import org.eclipse.albireo.internal.SwtPopupHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public abstract class SwingControl
extends Composite {
    static final boolean verboseSizeLayout = false;
    public static final String SWT_PARENT_PROPERTY_KEY = "org.eclipse.albireo.swtParent";
    private Listener settingsListener = new Listener(){

        public void handleEvent(Event event) {
            SwingControl.this.handleSettingsChange();
        }
    };
    final Display display;
    private Composite layoutDeferredAncestor;
    private int borderWidth;
    private Composite borderlessChild;
    private Frame frame;
    private RootPaneContainer rootPaneContainer;
    private JComponent swingComponent;
    private boolean populated = false;
    private Dimension cachedMinSize = new Dimension(0, 0);
    private Dimension cachedPrefSize = new Dimension(0, 0);
    private Dimension cachedMaxSize = new Dimension(0, 0);
    private int cachedSizesInitialized = 0;
    static final boolean INITIAL_CLIENT_AREA_WORKAROUND;
    private Rectangle initialClientArea;
    private static int currentAWTTime;
    volatile int lastValidatedAWTTime;
    static Map onBehalfAWTTimes;
    static final boolean AUTOMATIC_SET_AWT_SIZE;
    private SetAWTSizeQueue setAWTSizeQueue = new SetAWTSizeQueue();
    private CleanResizeListener cleanResizeListener;
    private FocusHandler focusHandler;
    private boolean isSwtTabOrderExtended = true;
    private boolean isAWTPermanentFocusLossForced = true;
    private List sizeListeners = new ArrayList();
    private static final boolean HIDE_SWING_POPUPS_ON_SWT_SHELL_BOUNDS_CHANGE;
    private final ControlListener shellControlListener = new ControlListener(){

        public void controlMoved(ControlEvent controlEvent) {
            this.scheduleHide();
        }

        public void controlResized(ControlEvent controlEvent) {
            this.scheduleHide();
        }

        private void scheduleHide() {
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    AwtEnvironment.getInstance(2.access$0(this.this$1).display).hidePopups();
                }
            });
        }

        static /* synthetic */ SwingControl access$0(2 var0) {
            return var0.SwingControl.this;
        }
    };
    Set consumedKeystrokes = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.core.SwingControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        INITIAL_CLIENT_AREA_WORKAROUND = Platform.isGtk() || Platform.isMotif() || Platform.isWin32();
        onBehalfAWTTimes = Collections.synchronizedMap(new HashMap());
        AUTOMATIC_SET_AWT_SIZE = Platform.isGtk() || Platform.isCarbon();
        HIDE_SWING_POPUPS_ON_SWT_SHELL_BOUNDS_CHANGE = Platform.isWin32();
    }

    public SwingControl(Composite composite, int n) {
        super(composite, n | ((n & 0x800) == 0 ? 0x1000000 : 0) | 0x40000);
        this.setLayout((Layout)new FillLayout());
        this.display = this.getDisplay();
        this.display.addListener(39, this.settingsListener);
        this.layoutDeferredAncestor = this.getLayoutAncestor();
        if (this.layoutDeferredAncestor != null) {
            this.layoutDeferredAncestor.setLayoutDeferred(true);
            ThreadingHandler.getInstance().asyncExec(this.display, new Runnable(){

                public void run() {
                    SwingControl.this.populate();
                }
            });
        }
        this.borderWidth = this.getBorderWidth();
        if ((n & 0x800) != 0) {
            this.borderlessChild = new Composite(this, n & 0xFFFFF7FF | 0x1000000 | 0x40000){

                public Rectangle getClientArea() {
                    if (!$assertionsDisabled && Display.getCurrent() == null) {
                        throw new AssertionError();
                    }
                    Rectangle rectangle = super.getClientArea();
                    SwingControl.this.assignInitialClientArea(rectangle);
                    return rectangle;
                }

                public boolean forceFocus() {
                    this.checkWidget();
                    return SwingControl.this.handleFocusOperation(new RunnableWithResult(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            boolean bl;
                            if (this.this$1.isDisposed()) {
                                bl = false;
                            } else {
                                bl = 5.access$0(this.this$1);
                                bl = 5.access$2(this.this$1).postProcessForceFocus(bl);
                            }
                            this.setResult(new Boolean(bl));
                        }
                    });
                }

                public boolean setFocus() {
                    this.checkWidget();
                    return SwingControl.this.handleFocusOperation(new RunnableWithResult(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            boolean bl = this.this$1.isDisposed() ? false : 5.access$1(this.this$1);
                            this.setResult(new Boolean(bl));
                        }
                    });
                }

                private boolean superSetFocus() {
                    return super.setFocus();
                }

                private boolean superForceFocus() {
                    return super.forceFocus();
                }

                static /* synthetic */ boolean access$0(5 var0) {
                    return var0.superForceFocus();
                }

                static /* synthetic */ boolean access$1(5 var0) {
                    return var0.superSetFocus();
                }

                static /* synthetic */ SwingControl access$2(5 var0) {
                    return var0.SwingControl.this;
                }
            };
        } else {
            if (!$assertionsDisabled && this.borderWidth != 0) {
                throw new AssertionError();
            }
            this.borderlessChild = this;
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SwingControl.this.handleDispose();
            }
        });
        this.initCleanResizeListener();
    }

    protected void populate() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.populated) {
            this.populated = true;
            this.createFrame();
            this.scheduleComponentCreation();
        }
    }

    protected void createFrame() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        AwtEnvironment.getInstance(this.display);
        this.frame = SWT_AWT.new_Frame((Composite)this.borderlessChild);
        this.initializeFocusManagement();
        this.initKeystrokeManagement();
        this.initFirstResizeActions();
        if (HIDE_SWING_POPUPS_ON_SWT_SHELL_BOUNDS_CHANGE) {
            this.getShell().addControlListener(this.shellControlListener);
        }
    }

    protected void scheduleComponentCreation() {
        if (!$assertionsDisabled && this.frame == null) {
            throw new AssertionError();
        }
        final Color color = this.getForeground();
        final Color color2 = this.getBackground();
        final Font font = this.getFont();
        final FontData[] fontDataArray = font.getFontData();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (keyboardFocusManager.getDefaultFocusTraversalPolicy().getClass().getName() == "javax.swing.LegacyGlueFocusTraversalPolicy") {
                    keyboardFocusManager.setDefaultFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
                }
                if (SwingControl.this.frame.getFocusTraversalPolicy() != null && SwingControl.this.frame.getFocusTraversalPolicy().getClass().getName() == "javax.swing.LegacyGlueFocusTraversalPolicy") {
                    SwingControl.this.frame.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
                }
                SwingControl.this.rootPaneContainer = SwingControl.this.addRootPaneContainer(SwingControl.this.frame);
                SwingControl.this.initPopupMenuSupport(SwingControl.this.rootPaneContainer.getRootPane());
                SwingControl.this.setComponentBackground(SwingControl.this.frame, color2, true);
                SwingControl.this.swingComponent = SwingControl.this.createSwingComponent();
                if (SwingControl.this.swingComponent != null) {
                    SwingControl.this.setComponentForeground(SwingControl.this.rootPaneContainer.getContentPane(), color, true);
                    SwingControl.this.setComponentBackground(SwingControl.this.rootPaneContainer.getContentPane(), color2, true);
                    SwingControl.this.setComponentFont(font, fontDataArray, true);
                    SwingControl.this.rootPaneContainer.getRootPane().getContentPane().add(SwingControl.this.swingComponent);
                    SwingControl.this.swingComponent.putClientProperty(SwingControl.SWT_PARENT_PROPERTY_KEY, (Object)SwingControl.this);
                }
                SwingControl.this.afterComponentCreatedAWTThread();
                try {
                    ThreadingHandler.getInstance().asyncExec(SwingControl.this.display, new Runnable(this){
                        final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            SwingControl.access$7(9.access$0(this.this$1)).activateEmbeddedFrame();
                            if (SwingControl.access$8(9.access$0(this.this$1)) != null && !SwingControl.access$8(9.access$0(this.this$1)).isDisposed()) {
                                SwingControl.access$8(9.access$0(this.this$1)).layout();
                                SwingControl.access$8(9.access$0(this.this$1)).setLayoutDeferred(false);
                            }
                            9.access$0(this.this$1).afterComponentCreatedSWTThread();
                        }
                    });
                }
                catch (SWTException sWTException) {
                    if (sWTException.code == 24) {
                        return;
                    }
                    throw sWTException;
                }
            }

            static /* synthetic */ SwingControl access$0(9 var0) {
                return var0.SwingControl.this;
            }
        });
    }

    protected RootPaneContainer addRootPaneContainer(Frame frame) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && frame == null) {
            throw new AssertionError();
        }
        ToplevelPanel toplevelPanel = new ToplevelPanel();
        if (Platform.isWin32()) {
            toplevelPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }
        frame.add(toplevelPanel);
        return toplevelPanel;
    }

    protected abstract JComponent createSwingComponent();

    protected void afterComponentCreatedAWTThread() {
    }

    protected void afterComponentCreatedSWTThread() {
    }

    public JComponent getSwingComponent() {
        return this.swingComponent;
    }

    public Container getAWTHierarchyRoot() {
        if (this.isDisposed()) {
            SWT.error((int)24);
        }
        return this.frame;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        Rectangle rectangle = super.getClientArea();
        if (this.borderlessChild == this) {
            this.assignInitialClientArea(rectangle);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assignInitialClientArea(Rectangle rectangle) {
        if (INITIAL_CLIENT_AREA_WORKAROUND && this.initialClientArea == null) {
            Object object = this;
            synchronized (object) {
                if (this.cachedSizesInitialized >= 1) {
                    rectangle.width = this.cachedPrefSize.width;
                    rectangle.height = this.cachedPrefSize.height;
                }
            }
            object = new Exception();
            ((Throwable)object).fillInStackTrace();
            StackTraceElement[] stackTraceElementArray = ((Throwable)object).getStackTrace();
            if (stackTraceElementArray.length >= 3 && stackTraceElementArray[2].getClassName().startsWith("org.eclipse.swt.awt.SWT_AWT$")) {
                this.initialClientArea = rectangle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCachedAWTSizes(final Dimension dimension, final Dimension dimension2, final Dimension dimension3) {
        boolean bl;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.lastValidatedAWTTime = ++currentAWTTime;
        SwingControl swingControl = this;
        synchronized (swingControl) {
            boolean bl2 = bl = this.cachedSizesInitialized == 0;
            if (!bl) {
                boolean bl3 = bl = !dimension.equals(this.cachedMinSize) || !dimension2.equals(this.cachedPrefSize) || !dimension3.equals(this.cachedMaxSize);
            }
            if (this.cachedSizesInitialized == 0) {
                this.cachedSizesInitialized = 1;
            }
            this.cachedMinSize = dimension;
            this.cachedPrefSize = dimension2;
            this.cachedMaxSize = dimension3;
            if (INITIAL_CLIENT_AREA_WORKAROUND && this.initialClientArea != null) {
                this.initialClientArea.width = this.cachedPrefSize.width;
                this.initialClientArea.height = this.cachedPrefSize.height;
            }
        }
        if (bl) {
            final int n = this.lastValidatedAWTTime;
            ThreadingHandler.getInstance().asyncExec(this.display, new Runnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    if (SwingControl.this.isDisposed()) return;
                    try {
                        onBehalfAWTTimes.put(Thread.currentThread(), new Integer(n));
                        Point point = new Point(Math.min(dimension.width, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth, Math.min(dimension.height, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth);
                        Point point2 = new Point(Math.min(dimension2.width, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth, Math.min(dimension2.height, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth);
                        Point point3 = new Point(Math.min(dimension3.width, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth, Math.min(dimension3.height, Integer.MAX_VALUE - 2 * SwingControl.this.borderWidth) + 2 * SwingControl.this.borderWidth);
                        SwingControl.this.notePreferredSizeChanged(point, point2, point3);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        onBehalfAWTTimes.remove(Thread.currentThread());
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                        onBehalfAWTTimes.remove(Thread.currentThread());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getCachedAWTSizes(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        SwingControl swingControl = this;
        synchronized (swingControl) {
            block4: {
                if (this.cachedSizesInitialized < 1) break block4;
                dimension.setSize(this.cachedMinSize);
                dimension2.setSize(this.cachedPrefSize);
                dimension3.setSize(this.cachedMaxSize);
                return true;
            }
            return false;
        }
    }

    private void setAWTSize(int n, int n2) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        Integer n3 = (Integer)onBehalfAWTTimes.get(Thread.currentThread());
        if (this.setAWTSizeQueue.enqueue(n3, n, n2)) {
            EventQueue.invokeLater(this.setAWTSizeQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSetBounds(int n, int n2) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        this.populate();
        if (!AUTOMATIC_SET_AWT_SIZE || Platform.isGtk() && Platform.JAVA_VERSION < Platform.javaVersion(1, 6, 0)) {
            SwingControl swingControl = this;
            synchronized (swingControl) {
                if (this.cachedSizesInitialized >= 2 || Platform.isGtk() && Platform.JAVA_VERSION < Platform.javaVersion(1, 6, 0) || Platform.isWin32()) {
                    this.setAWTSize(Math.max(n - 2 * this.borderWidth, 0), Math.max(n2 - 2 * this.borderWidth, 0));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Dimension dimension = new Dimension();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = new Dimension();
        boolean bl2 = this.getCachedAWTSizes(dimension, dimension2, dimension3);
        if (!bl2) {
            return super.computeSize(n, n2, bl);
        }
        SwingControl swingControl = this;
        synchronized (swingControl) {
            if (!$assertionsDisabled && this.cachedSizesInitialized < 1) {
                throw new AssertionError();
            }
            this.cachedSizesInitialized = 2;
        }
        int n3 = n == -1 ? dimension2.width : (n < dimension.width ? dimension.width : (n > dimension3.width ? dimension3.width : n));
        n3 = Math.min(n3, Integer.MAX_VALUE - 2 * this.borderWidth) + 2 * this.borderWidth;
        int n4 = n2 == -1 ? dimension2.height : (n2 < dimension.width ? dimension.height : (n2 > dimension3.width ? dimension3.height : n2));
        n4 = Math.min(n4, Integer.MAX_VALUE - 2 * this.borderWidth) + 2 * this.borderWidth;
        return new Point(n3, n4);
    }

    public abstract Composite getLayoutAncestor();

    void notePreferredSizeChanged(Point point, Point point2, Point point3) {
        this.preferredSizeChanged(point, point2, point3);
        this.firePreferredSizeChangedEvent(point, point2, point3);
    }

    protected void preferredSizeChanged(Point point, Point point2, Point point3) {
        Composite composite = this.getLayoutAncestor();
        if (composite != null) {
            composite.layout(new Control[]{this.borderlessChild});
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        this.handleSetBounds(rectangle.width, rectangle.height);
        super.setBounds(rectangle);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.handleSetBounds(n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    public boolean isCleanResizeEnabled() {
        return this.cleanResizeListener != null;
    }

    public void setCleanResizeEnabled(boolean bl) {
        if (bl != this.isCleanResizeEnabled()) {
            if (bl) {
                this.cleanResizeListener = new CleanResizeListener();
                this.borderlessChild.addControlListener((ControlListener)this.cleanResizeListener);
            } else {
                this.borderlessChild.removeControlListener((ControlListener)this.cleanResizeListener);
                this.cleanResizeListener = null;
            }
        }
    }

    private void initCleanResizeListener() {
        if (Platform.isWin32() && Platform.JAVA_VERSION < Platform.javaVersion(1, 6, 0)) {
            this.setCleanResizeEnabled(true);
        }
    }

    public void setFont(final Font font) {
        super.setFont(font);
        final FontData[] fontDataArray = font.getFontData();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SwingControl.this.setComponentFont(font, fontDataArray, false);
            }
        });
    }

    private void updateDefaultFont(Font font, FontData[] fontDataArray) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        java.awt.Font font2 = LookAndFeelHandler.getInstance().propagateSwtFont(font, fontDataArray);
        if (font2 == null) {
            return;
        }
        this.updateAwtFont(font2);
        if (this.swingComponent != null) {
            Container container = this.swingComponent.getRootPane().getContentPane();
            SwingUtilities.updateComponentTreeUI(container);
        }
    }

    protected void setComponentFont(Font font, FontData[] fontDataArray, boolean bl) {
        Container container;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        ResourceConverter resourceConverter = ResourceConverter.getInstance();
        java.awt.Font font2 = resourceConverter.convertFont(font, fontDataArray);
        this.updateAwtFont(font2);
        if (!(this.rootPaneContainer == null || (container = this.rootPaneContainer.getContentPane()).getFont().equals(font2) && bl)) {
            container.setFont(font2);
        }
    }

    protected void updateAwtFont(java.awt.Font font) {
    }

    private void handleSettingsChange() {
        final Font font = this.getDisplay().getSystemFont();
        final FontData[] fontDataArray = font.getFontData();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SwingControl.this.updateDefaultFont(font, fontDataArray);
            }
        });
    }

    private void handleDispose() {
        if (this.focusHandler != null) {
            this.focusHandler.dispose();
        }
        if (this.borderlessChild != this) {
            this.borderlessChild.dispose();
        }
        this.display.removeListener(39, this.settingsListener);
    }

    public void setBackground(final Color color) {
        super.setBackground(color);
        if (this.rootPaneContainer != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SwingControl.this.setComponentBackground(SwingControl.this.rootPaneContainer.getContentPane(), color, false);
                }
            });
        }
    }

    public void setForeground(final Color color) {
        super.setForeground(color);
        if (this.rootPaneContainer != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SwingControl.this.setComponentForeground(SwingControl.this.rootPaneContainer.getContentPane(), color, false);
                }
            });
        }
    }

    protected void setComponentForeground(Component component, Color color, boolean bl) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        LookAndFeelHandler.getInstance().propagateSwtForeground(component, color, bl);
    }

    protected void setComponentBackground(Component component, Color color, boolean bl) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        LookAndFeelHandler.getInstance().propagateSwtBackground(component, color, bl);
    }

    protected void initializeFocusManagement() {
        if (!$assertionsDisabled && this.frame == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        GlobalFocusHandler globalFocusHandler = AwtEnvironment.getInstance(this.display).getGlobalFocusHandler();
        this.focusHandler = new FocusHandler(this, globalFocusHandler, this.borderlessChild, this.frame);
    }

    public void setSwtTabOrderExtended(boolean bl) {
        this.isSwtTabOrderExtended = bl;
    }

    public boolean isSwtTabOrderExtended() {
        return this.isSwtTabOrderExtended;
    }

    public boolean isAWTPermanentFocusLossForced() {
        return this.isAWTPermanentFocusLossForced;
    }

    public void setAWTPermanentFocusLossForced(boolean bl) {
        this.isAWTPermanentFocusLossForced = bl;
    }

    public boolean setFocus() {
        this.checkWidget();
        if (this.borderlessChild == this) {
            return this.handleFocusOperation(new RunnableWithResult(){

                public void run() {
                    boolean bl = SwingControl.this.isDisposed() ? false : SwingControl.this.superSetFocus();
                    this.setResult(new Boolean(bl));
                }
            });
        }
        return this.borderlessChild.setFocus();
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.borderlessChild == this) {
            return this.handleFocusOperation(new RunnableWithResult(){

                public void run() {
                    boolean bl;
                    if (SwingControl.this.isDisposed()) {
                        bl = false;
                    } else {
                        bl = SwingControl.this.superForceFocus();
                        bl = SwingControl.this.postProcessForceFocus(bl);
                    }
                    this.setResult(new Boolean(bl));
                }
            });
        }
        return this.borderlessChild.forceFocus();
    }

    protected boolean postProcessForceFocus(boolean bl) {
        if (this.focusHandler != null) {
            bl = this.focusHandler.handleForceFocus(bl);
        }
        return bl;
    }

    protected boolean handleFocusOperation(RunnableWithResult runnableWithResult) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (this.swingComponent != null) {
            runnableWithResult.run();
            return (Boolean)runnableWithResult.getResult();
        }
        return false;
    }

    private boolean superSetFocus() {
        return super.setFocus();
    }

    private boolean superForceFocus() {
        return super.forceFocus();
    }

    public void addSizeListener(SizeListener sizeListener) {
        this.checkWidget();
        if (sizeListener == null) {
            SWT.error((int)4);
        }
        this.sizeListeners.add(sizeListener);
    }

    public void removeSizeListener(SizeListener sizeListener) {
        this.checkWidget();
        if (sizeListener == null) {
            SWT.error((int)4);
        }
        this.sizeListeners.remove(sizeListener);
    }

    protected void firePreferredSizeChangedEvent(Point point, Point point2, Point point3) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        SizeEvent sizeEvent = new SizeEvent(this, point, point2, point3);
        Iterator iterator = this.sizeListeners.iterator();
        while (iterator.hasNext()) {
            SizeListener sizeListener = (SizeListener)iterator.next();
            sizeListener.preferredSizeChanged(sizeEvent);
        }
    }

    public Menu getMenu(Component component, int n, int n2, int n3, int n4) {
        this.checkWidget();
        Menu menu = SwtPopupRegistry.getInstance().findMenu(component, n, n2, n3, n4);
        if (menu == null) {
            menu = this.getMenu();
        }
        return menu;
    }

    protected void initPopupMenuSupport(JRootPane jRootPane) {
        SwtPopupHandler.getInstance().monitorAwtComponent(jRootPane);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [frame=" + (this.frame != null ? this.frame.getName() : "null") + "]";
    }

    protected void initKeystrokeManagement() {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        if (Platform.isWin32()) {
            this.addConsumedKeystroke(new SwtKeystroke(2, 0x1000013, 131072));
        }
        this.borderlessChild.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                SwingControl.this.handleKeyEvent(1, keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                SwingControl.this.handleKeyEvent(2, keyEvent);
            }
        });
    }

    protected void handleKeyEvent(int n, KeyEvent keyEvent) {
        if (!$assertionsDisabled && Display.getCurrent() == null) {
            throw new AssertionError();
        }
        SwtKeystroke swtKeystroke = new SwtKeystroke(n, keyEvent);
        if (this.consumedKeystrokes.contains(swtKeystroke)) {
            keyEvent.doit = false;
        }
    }

    public Set getConsumedKeystrokes() {
        this.checkWidget();
        return Collections.unmodifiableSet(this.consumedKeystrokes);
    }

    public void addConsumedKeystroke(SwtKeystroke swtKeystroke) {
        this.checkWidget();
        this.consumedKeystrokes.add(swtKeystroke);
    }

    public boolean removeConsumedKeystroke(SwtKeystroke swtKeystroke) {
        this.checkWidget();
        return this.consumedKeystrokes.remove(swtKeystroke);
    }

    protected void initFirstResizeActions() {
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SwingControl.this.scrollTextFields(SwingControl.this.frame);
                SwingControl.this.frame.removeComponentListener(this);
            }
        });
    }

    protected void scrollTextFields(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            if (jTextComponent.getDocument() != null && jTextComponent.getDocument().getLength() > 0) {
                int n = jTextComponent.getCaretPosition();
                int n2 = n > 0 ? 0 : 1;
                jTextComponent.setCaretPosition(n2);
                jTextComponent.setCaretPosition(n);
            }
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.scrollTextFields(componentArray[n]);
                ++n;
            }
        }
    }

    static /* synthetic */ FocusHandler access$7(SwingControl swingControl) {
        return swingControl.focusHandler;
    }

    static /* synthetic */ Composite access$8(SwingControl swingControl) {
        return swingControl.layoutDeferredAncestor;
    }

    class SetAWTSizeQueue
    implements Runnable {
        private boolean pending = false;
        private Integer onBehalfAWTTime;
        private int width;
        private int height;
        private boolean processing;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.albireo.core.SwingControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        SetAWTSizeQueue() {
        }

        synchronized boolean enqueue(Integer n, int n2, int n3) {
            boolean bl;
            if (!$assertionsDisabled && Display.getCurrent() == null) {
                throw new AssertionError();
            }
            if (this.processing) {
                n = null;
            }
            boolean bl2 = this.pending;
            boolean bl3 = bl = n == null || SwingControl.this.lastValidatedAWTTime - n < 0;
            if (bl2 || bl) {
                this.width = n2;
                this.height = n3;
                this.onBehalfAWTTime = bl2 ? (this.onBehalfAWTTime == null || n == null ? null : (this.onBehalfAWTTime - n < 0 ? n : this.onBehalfAWTTime)) : n;
                this.pending = true;
                return !bl2;
            }
            return false;
        }

        private synchronized Dimension dequeue() {
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            if (this.pending) {
                this.pending = false;
                if (this.onBehalfAWTTime == null || SwingControl.this.lastValidatedAWTTime - this.onBehalfAWTTime < 0) {
                    this.processing = true;
                    return new Dimension(this.width, this.height);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Dimension dimension;
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.processing) {
                throw new AssertionError();
            }
            while ((dimension = this.dequeue()) != null) {
                if (SwingControl.this.frame != null) {
                    SwingControl.this.frame.setBounds(0, 0, Math.max(dimension.width, 0), Math.max(dimension.height, 0));
                    SwingControl.this.frame.validate();
                }
                SetAWTSizeQueue setAWTSizeQueue = this;
                synchronized (setAWTSizeQueue) {
                    this.processing = false;
                    if (!this.pending) {
                        break;
                    }
                }
            }
            if (!$assertionsDisabled && this.processing) {
                throw new AssertionError();
            }
        }
    }

    private class ToplevelPanel
    extends JApplet {
        private ToplevelPanel() {
        }

        protected JRootPane createRootPane() {
            ToplevelRootPane toplevelRootPane = new ToplevelRootPane();
            toplevelRootPane.setOpaque(true);
            return toplevelRootPane;
        }
    }

    private class ToplevelRootPane
    extends JRootPane {
        private ToplevelRootPane() {
        }

        protected void validateTree() {
            super.validateTree();
            SwingControl.this.updateCachedAWTSizes(this.getMinimumSize(), this.getPreferredSize(), this.getContentPane().getMaximumSize());
        }
    }
}

