/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.core;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.io.PrintStream;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.eclipse.albireo.core.ResourceConverter;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;

public class LookAndFeelHandler {
    public static final String LAFChoiceSwingDefault = "swing.defaultlaf";
    public static final String LAFChoiceCrossPlatform = "swing.crossplatformlaf";
    public static final String LAFChoiceNativeSystem = "swing.systemlaf";
    public static final String LAFChoiceNativeSystemPreferGtk = "swing.systemlaf+gtk";
    public static final String LAFChoiceNativeSystemNoGtk = "swing.systemlaf-gtk";
    private String lafChoice = Platform.JAVA_VERSION >= Platform.javaVersion(1, 6, 0) ? "swing.systemlaf-gtk" : "swing.systemlaf+gtk";
    private boolean isDefaultSwtFontPropagated = true;
    private boolean isTooltipAlwaysShown = true;
    private static final String GTK_LOOK_AND_FEEL_NAME = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private org.eclipse.swt.graphics.Font lastPropagatedSwtFont;
    private static LookAndFeelHandler theHandler;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.core.LookAndFeelHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        theHandler = new LookAndFeelHandler();
    }

    public String getLAFChoice() {
        return this.lafChoice;
    }

    public void setLAFChoice(String string) {
        this.lafChoice = string;
    }

    public boolean isSwtDefaultFontPropagated() {
        return this.isDefaultSwtFontPropagated;
    }

    public void setSwtDefaultFontPropagated(boolean bl) {
        this.isDefaultSwtFontPropagated = bl;
    }

    public boolean isTooltipAlwaysShown() {
        return this.isTooltipAlwaysShown;
    }

    public void setTooltipAlwaysShown(boolean bl) {
        this.isTooltipAlwaysShown = bl;
    }

    public void setLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.isTooltipAlwaysShown) {
            UIManager.put("ToolTipManager.enableToolTipMode", "allWindows");
        }
        if (System.getProperty(LAFChoiceSwingDefault) != null) {
            return;
        }
        String string = this.getLAFChoice();
        if (LAFChoiceSwingDefault.equals(string)) {
            return;
        }
        if (LAFChoiceCrossPlatform.equals(string)) {
            string = UIManager.getCrossPlatformLookAndFeelClassName();
        } else if (LAFChoiceNativeSystem.equals(string)) {
            string = UIManager.getSystemLookAndFeelClassName();
        } else if (LAFChoiceNativeSystemPreferGtk.equals(string)) {
            string = UIManager.getSystemLookAndFeelClassName();
            if (Platform.isGtk() && string.equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
                string = GTK_LOOK_AND_FEEL_NAME;
            }
            if (string.equals(GTK_LOOK_AND_FEEL_NAME)) {
                try {
                    LookAndFeelHandler.doSetLookAndFeel(GTK_LOOK_AND_FEEL_NAME);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
        } else if (LAFChoiceNativeSystemNoGtk.equals(string) && GTK_LOOK_AND_FEEL_NAME.equals(string = UIManager.getSystemLookAndFeelClassName())) {
            string = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        LookAndFeelHandler.doSetLookAndFeel(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doSetLookAndFeel(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        PrintStream printStream = System.err;
        try {
            try {
                System.setErr(new PrintStream(printStream){

                    public void print(String string) {
                        throw new UnsupportedLookAndFeelRuntimeException(string);
                    }

                    public void println(String string) {
                        throw new UnsupportedLookAndFeelRuntimeException(string);
                    }
                });
                UIManager.setLookAndFeel(string);
            }
            catch (UnsupportedLookAndFeelRuntimeException unsupportedLookAndFeelRuntimeException) {
                UnsupportedLookAndFeelException unsupportedLookAndFeelException = new UnsupportedLookAndFeelException(unsupportedLookAndFeelRuntimeException.getMessage());
                unsupportedLookAndFeelException.initCause(unsupportedLookAndFeelRuntimeException);
                throw unsupportedLookAndFeelException;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            System.setErr(printStream);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        System.setErr(printStream);
    }

    public Font propagateSwtFont(org.eclipse.swt.graphics.Font font, FontData[] fontDataArray) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Font font2 = ResourceConverter.getInstance().convertFont(font, fontDataArray);
        if (this.isSwtDefaultFontPropagated() && !font.getDevice().isDisposed() && this.lastPropagatedSwtFont != font) {
            this.lastPropagatedSwtFont = font;
            this.updateLookAndFeelFonts(font2);
        }
        return font2;
    }

    protected void updateLookAndFeelFonts(Font font) {
        if (!$assertionsDisabled && font == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        FontUIResource fontUIResource = new FontUIResource(font);
        UIManager.put("Button.font", fontUIResource);
        UIManager.put("CheckBox.font", fontUIResource);
        UIManager.put("ComboBox.font", fontUIResource);
        UIManager.put("EditorPane.font", fontUIResource);
        UIManager.put("Label.font", fontUIResource);
        UIManager.put("List.font", fontUIResource);
        UIManager.put("Panel.font", fontUIResource);
        UIManager.put("ProgressBar.font", fontUIResource);
        UIManager.put("RadioButton.font", fontUIResource);
        UIManager.put("ScrollPane.font", fontUIResource);
        UIManager.put("TabbedPane.font", fontUIResource);
        UIManager.put("Table.font", fontUIResource);
        UIManager.put("TableHeader.font", fontUIResource);
        UIManager.put("TextField.font", fontUIResource);
        UIManager.put("TextPane.font", fontUIResource);
        UIManager.put("TitledBorder.font", fontUIResource);
        UIManager.put("ToggleButton.font", fontUIResource);
        UIManager.put("TreeFont.font", fontUIResource);
        UIManager.put("ViewportFont.font", fontUIResource);
    }

    public void propagateSwtForeground(Component component, Color color, boolean bl) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        ResourceConverter resourceConverter = ResourceConverter.getInstance();
        java.awt.Color color2 = resourceConverter.convertColor(color);
        if (!color2.equals(component.getForeground()) || !bl) {
            component.setForeground(color2);
        }
    }

    public void propagateSwtBackground(Component component, Color color, boolean bl) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && component == null) {
            throw new AssertionError();
        }
        ResourceConverter resourceConverter = ResourceConverter.getInstance();
        java.awt.Color color2 = resourceConverter.convertColor(color);
        if (!color2.equals(component.getBackground()) || !bl) {
            component.setBackground(color2);
        }
    }

    public static LookAndFeelHandler getInstance() {
        return theHandler;
    }

    public static void setInstance(LookAndFeelHandler lookAndFeelHandler) {
        theHandler = lookAndFeelHandler;
    }

    static class UnsupportedLookAndFeelRuntimeException
    extends RuntimeException {
        UnsupportedLookAndFeelRuntimeException(String string) {
            super(string);
        }
    }
}

