/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.albireo.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.UnsupportedLookAndFeelException;
import org.eclipse.albireo.core.LookAndFeelHandler;
import org.eclipse.albireo.core.SwingControl;
import org.eclipse.albireo.core.ThreadingHandler;
import org.eclipse.albireo.internal.AwtDialogListener;
import org.eclipse.albireo.internal.GlobalFocusHandler;
import org.eclipse.albireo.internal.Platform;
import org.eclipse.albireo.internal.SwtInputBlocker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public final class AwtEnvironment {
    private static Map environmentMap;
    private final Display display;
    private final AwtDialogListener dialogListener;
    private final GlobalFocusHandler globalFocusHandler;
    private static boolean isLookAndFeelInitialized;
    private static final boolean HIDE_SWING_POPUPS_ON_SWT_MENU_OPEN;
    private final Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            EventQueue.invokeLater(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$0(this.this$1).hidePopups();
                }
            });
        }

        static /* synthetic */ AwtEnvironment access$0(1 var0) {
            return var0.AwtEnvironment.this;
        }
    };
    private Shell popupParent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.albireo.core.AwtEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        environmentMap = new HashMap();
        isLookAndFeelInitialized = false;
        HIDE_SWING_POPUPS_ON_SWT_MENU_OPEN = Platform.isGtk() && Platform.JAVA_VERSION < Platform.javaVersion(1, 6, 0) || Platform.isWin32();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AwtEnvironment getInstance(final Display display) {
        if (display == null) {
            SWT.error((int)4);
        }
        Map map = environmentMap;
        synchronized (map) {
            AwtEnvironment awtEnvironment = (AwtEnvironment)environmentMap.get(display);
            if (awtEnvironment == null) {
                awtEnvironment = new AwtEnvironment(display);
                environmentMap.put(display, awtEnvironment);
                ThreadingHandler.getInstance().asyncExec(display, new Runnable(){

                    public void run() {
                        AwtEnvironment.installDisposeHandler(display);
                    }
                });
            }
            return awtEnvironment;
        }
    }

    private static void installDisposeHandler(final Display display) {
        if (!display.isDisposed()) {
            display.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    AwtEnvironment.removeInstance(display);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(Display display) {
        Map map = environmentMap;
        synchronized (map) {
            AwtEnvironment awtEnvironment = (AwtEnvironment)environmentMap.remove(display);
            if (awtEnvironment != null) {
                awtEnvironment.dispose();
            }
        }
    }

    private AwtEnvironment(final Display display) {
        if (!$assertionsDisabled && display == null) {
            throw new AssertionError();
        }
        this.display = display;
        System.setProperty("sun.awt.noerasebackground", "true");
        final Font[] fontArray = new Font[1];
        display.syncExec(new Runnable(){

            public void run() {
                fontArray[0] = display.getSystemFont();
            }
        });
        final Font font = fontArray[0];
        final FontData[] fontDataArray = font.getFontData();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    AwtEnvironment.setLookAndFeel();
                    LookAndFeelHandler.getInstance().propagateSwtFont(font, fontDataArray);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            SWT.error((int)46, (Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            SWT.error((int)46, (Throwable)invocationTargetException.getTargetException());
        }
        this.dialogListener = new AwtDialogListener(display);
        this.initSwingPopupsDismissal();
        this.globalFocusHandler = new GlobalFocusHandler(display);
    }

    void dispose() {
        this.dialogListener.dispose();
        if (this.popupParent != null) {
            this.popupParent.setVisible(false);
            this.popupParent.dispose();
        }
        this.globalFocusHandler.dispose();
    }

    private static void setLookAndFeel() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!isLookAndFeelInitialized) {
            isLookAndFeelInitialized = true;
            try {
                LookAndFeelHandler.getInstance().setLookAndFeel();
            }
            catch (ClassNotFoundException classNotFoundException) {
                SWT.error((int)20, (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                SWT.error((int)20, (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                SWT.error((int)20, (Throwable)illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                SWT.error((int)20, (Throwable)unsupportedLookAndFeelException);
            }
        }
    }

    private void initSwingPopupsDismissal() {
        if (HIDE_SWING_POPUPS_ON_SWT_MENU_OPEN) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    AwtEnvironment.this.display.addFilter(22, AwtEnvironment.this.menuListener);
                }
            });
        }
    }

    protected boolean hidePopups() {
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window == null) {
            return false;
        }
        this.findContainedPopups(window, arrayList);
        this.findOwnedPopups(window, arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!component.isVisible()) continue;
            bl = true;
            component.setVisible(false);
        }
        return bl;
    }

    protected void findOwnedPopups(Window window, List list) {
        if (!$assertionsDisabled && window == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Window[] windowArray = window.getOwnedWindows();
        int n = 0;
        while (n < windowArray.length) {
            this.findContainedPopups(windowArray[n], list);
            this.findOwnedPopups(windowArray[n], list);
            ++n;
        }
    }

    protected void findContainedPopups(Container container, List list) {
        if (!$assertionsDisabled && container == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && list == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof JPopupMenu) {
                list.add(component);
            } else if (component instanceof Container) {
                this.findContainedPopups((Container)component, list);
            }
            ++n;
        }
    }

    public void invokeAndBlockSwt(final Runnable runnable) {
        if (!$assertionsDisabled && this.display == null) {
            throw new AssertionError();
        }
        if (runnable == null) {
            SWT.error((int)4);
        }
        if (!this.display.equals(Display.getCurrent())) {
            SWT.error((int)22);
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    ThreadingHandler.getInstance().asyncExec(AwtEnvironment.this.display, new Runnable(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            SwtInputBlocker.unblock();
                        }
                    });
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    ThreadingHandler.getInstance().asyncExec(AwtEnvironment.this.display, new /* invalid duplicate definition of identical inner class */);
                    return;
                }
            }
        });
        SwtInputBlocker.block(this.dialogListener);
    }

    public Frame createDialogParentFrame() {
        Shell shell;
        if (!this.display.equals(Display.getCurrent())) {
            SWT.error((int)22);
        }
        if ((shell = this.display.getActiveShell()) == null) {
            throw new IllegalStateException("No Active Shell");
        }
        return this.createDialogParentFrame(shell);
    }

    public Frame createDialogParentFrame(Shell shell) {
        if (shell == null) {
            SWT.error((int)4);
        }
        if (!this.display.equals(Display.getCurrent())) {
            SWT.error((int)22);
        }
        final Shell shell2 = new Shell(shell, 65544);
        Composite composite = new Composite((Composite)shell2, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        shell2.setLocation(shell.getLocation());
        if (Platform.isGtk()) {
            shell2.setSize(0, 0);
            shell2.setVisible(true);
            shell2.setVisible(false);
        }
        shell2.setSize(shell.getSize());
        shell2.setLayout((Layout)new FillLayout());
        shell2.layout();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (!AwtEnvironment.this.display.isDisposed()) {
                    ThreadingHandler.getInstance().asyncExec(AwtEnvironment.this.display, new Runnable(this, shell2){
                        final /* synthetic */ 10 this$1;
                        private final /* synthetic */ Shell val$shell;
                        {
                            this.this$1 = var1_1;
                            this.val$shell = shell;
                        }

                        public void run() {
                            this.val$shell.dispose();
                        }
                    });
                }
            }
        });
        return frame;
    }

    public Shell getSwtPopupParent(SwingControl swingControl) {
        if (Platform.isGtk()) {
            if (this.popupParent == null) {
                this.popupParent = new Shell(this.display, 540680);
                this.popupParent.setSize(0, 0);
            }
            return this.popupParent;
        }
        return swingControl.getShell();
    }

    protected GlobalFocusHandler getGlobalFocusHandler() {
        return this.globalFocusHandler;
    }
}

