/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.security.internal;

import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.common.security.SecurityManagerFactory;
import com.jrockit.mc.core.wizards.IPerformFinishable;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.security.internal.Messages;
import java.util.logging.Level;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class MasterPasswordWizardPage
extends WizardPage
implements IPerformFinishable {
    static final String PAGE_NAME = Messages.MASTER_PASSWORD_WIZARD_PAGE;
    private Text passwordField;
    private Text passwordField2;
    private int editMode = 0;
    private static final int MODE_NEW_PASSWORD = 0;
    private static final int MODE_VERIFY_PASSWORD = 1;
    private static final int MIN_PASSWORD_LENGTH = 5;

    public MasterPasswordWizardPage() {
        super(PAGE_NAME);
        this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("bannerpasswordwiz.gif"));
        this.updateMode();
        if (this.editMode == 0) {
            this.setTitle(Messages.MasterPasswordWizardPage_CREATE_MASTER_PASSWORD_TITLE);
        }
        if (this.editMode == 1) {
            this.setTitle(Messages.MasterPasswordWizardPage_VERIFY_MASTER_PASSWORD_TITLE);
        }
    }

    public void createControl(Composite parent) {
        this.initializeMessages();
        InputVerifier listener = new InputVerifier();
        parent.setLayout((Layout)new GridLayout());
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new GridLayout(2, false));
        String labelText = this.editMode == 0 ? Messages.MasterPasswordWizardPage_CAPTION_NEW_PASSWORD : Messages.MasterPasswordWizardPage_CAPTION_ENTER_PASSWORD;
        Label firstPasswordLabel = new Label(c, 16384);
        firstPasswordLabel.setText(labelText);
        firstPasswordLabel.setToolTipText(Messages.MasterPasswordWizardPage_TOOLTIP_ENTER_PASSWORD);
        this.passwordField = new Text(c, 0x400804);
        GridData data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        this.passwordField.addModifyListener((ModifyListener)listener);
        if (this.editMode == 0) {
            Label secondPasswordLabel = new Label(c, 16384);
            secondPasswordLabel.setText(Messages.MasterPasswordWizardPage_CAPTION_CONFIRM_PASSWORD);
            secondPasswordLabel.setToolTipText(Messages.MasterPasswordWizardPage_TOOLTIP_CONFIRM_PASSWORD);
            data = new GridData(768);
            this.passwordField2 = new Text(c, 0x400804);
            GridData data2 = new GridData(768);
            this.passwordField2.setLayoutData((Object)data2);
            this.passwordField2.addModifyListener((ModifyListener)listener);
        }
        this.setControl((Control)c);
        this.setPageComplete(false);
        c.layout();
    }

    private void initializeMessages() {
        this.setErrorMessage(null);
        if (this.editMode == 0) {
            this.setMessage(Messages.MasterPasswordWizardPage_CREATE_MASTER_PASSWORD_DESCRIPTION_TEXT);
        } else {
            this.setMessage(Messages.MasterPasswordWizardPage_VERIFY_MASTER_PASSWORD_DESCRIPTION_TEXT);
        }
    }

    private void updateMode() {
        this.editMode = !SecurityManagerFactory.getSecurityManager().hasHash() ? 0 : 1;
    }

    public String storeToModel() {
        return this.passwordField.getText();
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        final Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        return messageComposite;
    }

    private void checkPageComplete() {
        if (this.passwordField.getText().length() <= 0) {
            this.setErrorMessage(Messages.MasterPasswordWizardPage_ERROR_PASSWORD_EMPTY_TEXT);
            return;
        }
        if (this.passwordField.getText().length() < 5) {
            this.setErrorMessage(NLS.bind((String)Messages.MasterPasswordWizardPage_ERROR_MESSAGE_PASSWORD_SHORTER_THAN_X_CAHARCTERS_TEXT, (Object)new Integer(5)));
            return;
        }
        if (this.editMode == 0 && !this.passwordField.getText().equals(this.passwordField2.getText())) {
            this.setErrorMessage(Messages.MasterPasswordWizardPage_ERROR_MESSAGE_PASSWORDS_DO_NOT_MATCH_TEXT);
            return;
        }
        if (this.editMode == 1) {
            try {
                if (!SecurityManagerFactory.getSecurityManager().checkHash(this.passwordField.getText())) {
                    this.setErrorMessage(Messages.MasterPasswordWizardPage_ERROR_MESSAGE_NOT_MATCHING_PREVIOUSLY_SET_PASSWORD_TEXT);
                    return;
                }
            }
            catch (SecurityException e) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem verifying password!", e);
                this.setErrorMessage(e.getMessage());
                return;
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    void handleException(Exception e) {
        RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem completing the Master Password Wizard!", e);
        this.setErrorMessage(e.getMessage());
        this.setPageComplete(false);
    }

    public boolean performFinish() {
        String password = this.storeToModel();
        try {
            SecurityManagerFactory.getSecurityManager().setMasterPassword(password);
        }
        catch (SecurityException e) {
            this.handleException((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private class InputVerifier
    implements ModifyListener {
        private InputVerifier() {
        }

        public void modifyText(ModifyEvent e) {
            MasterPasswordWizardPage.this.checkPageComplete();
        }
    }
}

