/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.security;

import com.jrockit.mc.common.security.IEncryptionScheme;
import com.jrockit.mc.common.security.SecurityException;
import com.jrockit.mc.common.security.SecurityManagerFactory;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IConnectionManager;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.ui.security.internal.MasterPasswordWizardPage;
import com.jrockit.mc.rjmx.ui.security.internal.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class SecurityToolkit {
    private SecurityToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static IConnectionHandle establishConnection(Shell shell, IConnectionDescriptor descriptor) throws ConnectionException {
        IConnectionManager manager = RJMXPlugin.getDefault().getConnectionManager();
        String scheme = ConnectionDescriptorToolkit.getEncryptionScheme((IConnectionDescriptor)descriptor);
        if (scheme == null) {
            return manager.connect(descriptor);
        }
        IEncryptionScheme[] schemes = SecurityManagerFactory.getSecurityManager().getEncryptionSchemes();
        int i = 0;
        while (i < schemes.length) {
            if (schemes[i].getIdentifier().equals(scheme) && SecurityManagerFactory.getSecurityManager().getEncryptionScheme() != schemes[i]) {
                SecurityManagerFactory.getSecurityManager().setEncryptionScheme(schemes[i]);
            }
            ++i;
        }
        if (!SecurityManagerFactory.getSecurityManager().hasMasterPassword()) {
            SecurityToolkit.promptForPassword(shell);
        }
        return manager.connect(descriptor);
    }

    public static void promptForPassword(final Shell parentShell) {
        DisplayToolkit.safeSyncExec((Widget)parentShell, (Runnable)new Runnable(){

            public void run() {
                MasterPasswordWizardPage page = new MasterPasswordWizardPage();
                OnePageWizardDialog owp = new OnePageWizardDialog(parentShell, (IWizardPage)page);
                owp.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
                owp.setTitle(Messages.ServicesToolkit_MASTER_PASSWORD_SETTINGS_TITLE);
                owp.open();
            }
        });
    }

    public static String encrypt(Shell parentShell, String message, IEncryptionScheme scheme) throws SecurityException {
        if (!SecurityManagerFactory.getSecurityManager().hasMasterPassword()) {
            SecurityToolkit.promptForPassword(parentShell);
        }
        SecurityManagerFactory.getSecurityManager().setEncryptionScheme(scheme);
        return SecurityManagerFactory.getSecurityManager().encrypt(message);
    }

    public static String decrypt(Shell parentShell, String message, String encryptionScheme) throws SecurityException {
        if (!SecurityManagerFactory.getSecurityManager().hasMasterPassword()) {
            SecurityToolkit.promptForPassword(parentShell);
        }
        if (!SecurityManagerFactory.getSecurityManager().getEncryptionScheme().getIdentifier().equals(encryptionScheme)) {
            IEncryptionScheme match = null;
            int i = 0;
            while (i < SecurityManagerFactory.getSecurityManager().getEncryptionSchemes().length) {
                if (SecurityManagerFactory.getSecurityManager().getEncryptionSchemes()[i].getIdentifier().equals(encryptionScheme)) {
                    match = SecurityManagerFactory.getSecurityManager().getEncryptionSchemes()[i];
                    break;
                }
                ++i;
            }
            if (match == null) {
                throw new SecurityException("Could not find any encryption scheme matching " + encryptionScheme);
            }
            SecurityManagerFactory.getSecurityManager().setEncryptionScheme(match);
        }
        return SecurityManagerFactory.getSecurityManager().decrypt(message);
    }
}

