/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.CombinedSectionPart;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

class ToggleAccessibleControlAction
extends Action {
    private final CombinedSectionPart m_sectionPart;
    private IPropertyChangeListener m_propertyChangeListener;

    public ToggleAccessibleControlAction(CombinedSectionPart sectionPart) {
        super(Messages.ToggleAccessibleControlAction_ACTION_NAME, 2);
        this.m_sectionPart = sectionPart;
        this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("accessibility-mode-toggle-on-16.png"));
        this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("accessibility-mode-toggle-off-16.png"));
        this.setToolTipText(Messages.ToggleAccessibleControlAction_TOOLTIP_TEXT);
        this.m_propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("accessibility.mode")) {
                    ToggleAccessibleControlAction.this.setChecked(CorePlugin.getDefault().getAccessibilityMode());
                    ToggleAccessibleControlAction.this.run();
                }
            }
        };
        CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_propertyChangeListener);
        this.setChecked(CorePlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode"));
        this.updateToolTipText();
    }

    public void dispose() {
        if (this.m_propertyChangeListener != null) {
            CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.m_propertyChangeListener);
            this.m_propertyChangeListener = null;
        }
    }

    public void run() {
        this.m_sectionPart.updateView(this.isChecked());
        this.updateToolTipText();
    }

    private void updateToolTipText() {
    }
}

