/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import se.hirt.greychart.data.ITimestampedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvingEventList
extends AbstractList<ITimestampedData> {
    private static final int PRUNE_LIMIT = 1000;
    private static final int DOUBLE_MAX_SCREEN_RESOLUTION = 5000;
    private final long range;
    private double msPerPixel;
    private long firstTimestamp = -1L;
    private long lastTimestamp = -1L;
    private int readOffset = 0;
    private int currentPixel = -1;
    private int eventsInLastPixel = 0;
    private ArrayList<ITimestampedData> coalescedList;

    public ResolvingEventList(long range) {
        this.range = range;
        this.msPerPixel = (double)range / 5000.0;
        if (this.msPerPixel < 1.0) {
            this.msPerPixel = 1.0;
        }
        this.coalescedList = new ArrayList(21010);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean add(ITimestampedData e) {
        block3: {
            if (this.firstTimestamp < 0L) {
                this.firstTimestamp = (Long)e.getX();
            }
            if ((Long)e.getX() < this.lastTimestamp) {
                throw new IllegalArgumentException("Tried to add an event with the timestamp " + e.getX() + " when the highest timestamp was " + this.lastTimestamp);
            }
            this.lastTimestamp = (Long)e.getX();
            this.coalesceAndAddEvent(e);
            if (this.readOffset <= 1000) ** GOTO lbl13
            l = new ArrayList<E>(this.coalescedList.subList(this.readOffset / 4 * 4, this.coalescedList.size()));
            this.coalescedList = l;
            this.readOffset = 0;
            break block3;
lbl-1000:
            // 1 sources

            {
                ++this.readOffset;
lbl13:
                // 2 sources

                ** while (((Long)this.coalescedList.get((int)this.readOffset).getX()).longValue() < this.lastTimestamp - this.range)
            }
        }
        return true;
    }

    @Override
    public synchronized ITimestampedData get(int index) {
        return this.coalescedList.get(index + this.readOffset / 4 * 4);
    }

    @Override
    public synchronized int size() {
        return this.coalescedList.size() - this.readOffset / 4 * 4;
    }

    @Override
    public synchronized void clear() {
        this.readOffset = 0;
        this.currentPixel = 0;
        this.firstTimestamp = -1L;
        this.lastTimestamp = -1L;
        this.eventsInLastPixel = 0;
        this.coalescedList.clear();
    }

    private void coalesceAndAddEvent(ITimestampedData e) {
        long timestamp = (Long)e.getX();
        int eventPixel = (int)((double)(timestamp - this.firstTimestamp) / this.msPerPixel);
        if (eventPixel > this.currentPixel) {
            this.coalescedList.add(e);
            this.currentPixel = eventPixel;
            this.eventsInLastPixel = 1;
        } else if (this.eventsInLastPixel < 4) {
            this.coalescedList.add(e);
            ++this.eventsInLastPixel;
        } else {
            double thirdLastValueD;
            int lastEventIndex = this.coalescedList.size() - 1;
            int nextLastEventIndex = lastEventIndex - 1;
            int thirdLastEventIndex = nextLastEventIndex - 1;
            ITimestampedData oldLastEvent = this.coalescedList.get(lastEventIndex);
            this.coalescedList.set(lastEventIndex, e);
            Number val = (Number)oldLastEvent.getY();
            ITimestampedData nextLastEvent = this.coalescedList.get(nextLastEventIndex);
            ITimestampedData thirdLastEvent = this.coalescedList.get(thirdLastEventIndex);
            Number nextLastValue = (Number)nextLastEvent.getY();
            Number thirdLastValue = (Number)thirdLastEvent.getY();
            if (nextLastValue == null || thirdLastValue == null || val == null) {
                return;
            }
            double valD = val.doubleValue();
            double nextLastValueD = nextLastValue.doubleValue();
            if (nextLastValueD == (thirdLastValueD = thirdLastValue.doubleValue())) {
                this.coalescedList.set(nextLastEventIndex, oldLastEvent);
            } else if (nextLastValueD > thirdLastValueD) {
                if (valD >= thirdLastValueD && valD <= nextLastValueD) {
                    return;
                }
                if (valD < thirdLastValueD) {
                    this.coalescedList.set(thirdLastEventIndex, nextLastEvent);
                }
            } else {
                if (valD >= nextLastValueD && valD <= thirdLastValueD) {
                    return;
                }
                if (valD > thirdLastValueD) {
                    this.coalescedList.set(thirdLastEventIndex, nextLastEvent);
                }
            }
            this.coalescedList.set(nextLastEventIndex, oldLastEvent);
        }
    }
}

