/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class MBeanTreeRefreshJob
extends WorkbenchJob {
    public static final int DEFAULT_VISIBLE_LEAVES = 10;
    private TreeViewer mbeanTreeViewer;
    private boolean mbeansAreLeaves;
    private ViewerFilter[] filters;
    private int wantedVisibleLeaves;

    public MBeanTreeRefreshJob(TreeViewer attributeViewer) {
        this(attributeViewer, 10);
    }

    public MBeanTreeRefreshJob(TreeViewer mbeanViewer, int wantedVisibleLeaves) {
        super("MBean Tree Refresh Job");
        this.setSystem(false);
        this.mbeanTreeViewer = mbeanViewer;
        this.wantedVisibleLeaves = wantedVisibleLeaves;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        this.refreshTree();
        return Status.OK_STATUS;
    }

    private void refreshTree() {
        Object[] expanded = this.mbeanTreeViewer.getExpandedElements();
        this.mbeanTreeViewer.getTree().setRedraw(false);
        this.mbeanTreeViewer.refresh(true);
        this.mbeanTreeViewer.setExpandedElements(expanded);
        MBeanTreeContentProvider contentProvider = (MBeanTreeContentProvider)this.mbeanTreeViewer.getContentProvider();
        this.mbeansAreLeaves = contentProvider.isShowOnlyBeans();
        this.filters = this.mbeanTreeViewer.getFilters();
        expanded = this.mbeanTreeViewer.getVisibleExpandedElements();
        int found = 0;
        int i = 0;
        while (i < expanded.length) {
            found += this.foundLeaves((ITreeNode)expanded[i]);
            ++i;
        }
        if (found < this.wantedVisibleLeaves) {
            found = this.expandNodes(null, true, (ITreeNode[])contentProvider.getElements(null), found);
        }
        this.mbeanTreeViewer.getTree().setRedraw(true);
        this.mbeanTreeViewer.getTree().redraw();
    }

    private int foundLeaves(ITreeNode node) {
        int found = 0;
        ITreeNode[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (this.isSelectable(node, children[i]) && this.isLeaf(children[i])) {
                    ++found;
                }
                ++i;
            }
        }
        return found;
    }

    private boolean isSelectable(ITreeNode parentNode, ITreeNode node) {
        ViewerFilter[] flters = this.filters;
        int i = 0;
        while (i < flters.length) {
            if (!flters[i].select((Viewer)this.mbeanTreeViewer, (Object)parentNode, (Object)node)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLeaf(ITreeNode node) {
        if (this.mbeansAreLeaves) {
            return node.getUserData() instanceof MBeanPropertiesOrderer.PropertyWithMBean;
        }
        return node.getUserData() instanceof IAttributeInfo;
    }

    private int expandNodes(ITreeNode parent, boolean grandparentVisible, ITreeNode[] children, int found) {
        boolean parentVisible = false;
        if (grandparentVisible) {
            parentVisible = parent == null ? true : this.mbeanTreeViewer.getExpandedState((Object)parent);
        }
        int i = 0;
        while (i < children.length) {
            ITreeNode child = children[i];
            if (this.isLeaf(child)) {
                if (this.isSelectable(parent, child) && !parentVisible) {
                    while (child != null) {
                        this.mbeanTreeViewer.setExpandedState((Object)child, true);
                        child = child.getParent();
                    }
                    ++found;
                }
            } else {
                found = this.expandNodes(child, parentVisible, child.getChildren(), found);
            }
            if (found >= this.wantedVisibleLeaves) {
                return found;
            }
            ++i;
        }
        return found;
    }

    public int getWantedVisibleLeaves() {
        return this.wantedVisibleLeaves;
    }

    public void setWantedVisibleLeaves(int wantedVisibleLeaves) {
        if (this.wantedVisibleLeaves != wantedVisibleLeaves) {
            this.wantedVisibleLeaves = wantedVisibleLeaves;
            this.refreshTree();
        }
    }
}

