/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.progress.WorkbenchJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanTreeOrderRefreshJob
extends WorkbenchJob {
    private TreeViewer treeViewer;

    public MBeanTreeOrderRefreshJob(TreeViewer treeViewer) {
        super("MBean Tree Order Refresh Job");
        this.treeViewer = treeViewer;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        this.refreshTree();
        return Status.OK_STATUS;
    }

    private void refreshTree() {
        Object[] oldSelectedObjects = this.retrieveSelectedObjects();
        Object[] oldExpandedObjects = this.retrieveExpandedLeafObjects();
        this.treeViewer.getTree().setRedraw(false);
        MBeanTreeContentProvider treeContentProvider = (MBeanTreeContentProvider)this.treeViewer.getContentProvider();
        treeContentProvider.buildContentTree(this.treeViewer);
        this.treeViewer.refresh(true);
        HashSet<ITreeNode> nodesToExpand = new HashSet<ITreeNode>();
        this.addNodesToExpand(treeContentProvider, nodesToExpand, oldSelectedObjects);
        this.addNodesToExpand(treeContentProvider, nodesToExpand, oldExpandedObjects);
        this.treeViewer.setExpandedElements(nodesToExpand.toArray());
        TreePath[] selectedTreePaths = this.createTreePaths(treeContentProvider, oldSelectedObjects);
        if (selectedTreePaths.length > 0) {
            this.treeViewer.setSelection((ISelection)new TreeSelection(selectedTreePaths));
        }
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.getTree().redraw();
    }

    private Object[] retrieveSelectedObjects() {
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        Object[] selectedNodes = selection.toArray();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        int i = 0;
        while (i < selectedNodes.length) {
            ITreeNode node = (ITreeNode)selectedNodes[i];
            if (node.getChildren() == null) {
                selectedObjects.add(node.getUserData());
            }
            ++i;
        }
        return selectedObjects.toArray();
    }

    private Object[] retrieveExpandedLeafObjects() {
        Object[] expandedNodes = this.treeViewer.getExpandedElements();
        ArrayList<Object> expandedLeafObjects = new ArrayList<Object>();
        int i = 0;
        while (i < expandedNodes.length) {
            ITreeNode node = (ITreeNode)expandedNodes[i];
            ITreeNode[] children = node.getChildren();
            if (children == null) {
                expandedLeafObjects.add(node.getUserData());
            } else {
                int j = 0;
                while (j < children.length) {
                    if (children[j].getChildren() == null) {
                        expandedLeafObjects.add(children[j].getUserData());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return expandedLeafObjects.toArray();
    }

    private void addNodesToExpand(MBeanTreeContentProvider treeContentProvider, HashSet<ITreeNode> nodesToExpand, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
                this.addNodesToRoot(nodesToExpand, treeContentProvider.findNode(((MBeanPropertiesOrderer.PropertyWithMBean)object).getBean()));
            } else if (object instanceof IAttributeInfo) {
                this.addNodesToRoot(nodesToExpand, treeContentProvider.findNode((IAttributeInfo)object));
            }
            ++i;
        }
    }

    private void addNodesToRoot(HashSet<ITreeNode> nodesToExpand, ITreeNode node) {
        while (node != null) {
            nodesToExpand.add(node);
            node = node.getParent();
        }
    }

    private TreePath[] createTreePaths(MBeanTreeContentProvider treeContentProvider, Object[] objects) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        int i = 0;
        while (i < objects.length) {
            ITreeNode node;
            MBeanPropertiesOrderer.PropertyWithMBean new_name;
            Object object = objects[i];
            if (object instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
                new_name = (MBeanPropertiesOrderer.PropertyWithMBean)object;
                node = treeContentProvider.findNode(new_name.getBean());
                if (node != null) {
                    treePaths.add(this.createTreePath(node));
                }
            } else if (object instanceof IAttributeInfo && (node = treeContentProvider.findNode((IAttributeInfo)(new_name = (IAttributeInfo)object))) != null) {
                treePaths.add(this.createTreePath(node));
            }
            ++i;
        }
        return treePaths.toArray(new TreePath[treePaths.size()]);
    }

    private TreePath createTreePath(ITreeNode node) {
        LinkedList<ITreeNode> nodes = new LinkedList<ITreeNode>();
        while (node != null) {
            nodes.addFirst(node);
            node = node.getParent();
        }
        return new TreePath(nodes.toArray());
    }
}

