/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MBeanTreeLabelProvider
implements ILabelProvider {
    private TreeViewer associatedViewer;
    private HashSet<ILabelProviderListener> labelProviderListeners = new HashSet();

    public MBeanTreeLabelProvider(TreeViewer associatedViewer) {
        this.associatedViewer = associatedViewer;
    }

    public Image getConsoleImage(String imageKey) {
        return RJMXUIPlugin.getDefault().getImage(imageKey);
    }

    public Image getImage(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            if (this.associatedViewer.getExpandedState(element)) {
                return this.getConsoleImage("mbean-16.png");
            }
            return this.getConsoleImage("mbean-16.png");
        }
        if (data instanceof String || data instanceof MBeanPropertiesOrderer.Property) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (data instanceof IAttributeInfo) {
            IAttributeInfo info = (IAttributeInfo)data;
            if (this.associatedViewer.getExpandedState(data)) {
                if (info.isNotification()) {
                    return this.getConsoleImage("composite-attribute-closed-16.png");
                }
                return this.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (info.isComposite()) {
                if (info.isNotification()) {
                    return this.getConsoleImage("composite-attribute-closed-16.png");
                }
                return this.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (info.isSynthetic()) {
                if (info.isNumerical()) {
                    return this.getConsoleImage("syn-num-attribute-16.png");
                }
                return this.getConsoleImage("synthetic-attribute-16.png");
            }
            if (info.isNumerical()) {
                return this.getConsoleImage("numerical-attribute-16.png");
            }
            return this.getConsoleImage("non-numerical-attribute-16.png");
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    public String getText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return this.formatProperty((MBeanPropertiesOrderer.Property)data);
        }
        if (data instanceof IAttributeInfo) {
            return ((IAttributeInfo)data).getAttributeDescriptor().getAttributeName();
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    private String formatProperty(MBeanPropertiesOrderer.Property data) {
        String value = data.getValue();
        if (value != null && "class".equals(data.getKey())) {
            return value.substring(value.lastIndexOf(46) + 1);
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove(listener);
    }
}

