/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.DefaultTreeNode;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.internal.DefaultAttributeInfoService;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeOrderRefreshJob;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.management.ObjectName;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanTreeContentProvider
implements ITreeContentProvider,
MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener {
    private IMBeanService mbeanService;
    private IAttributeInfoService attributeInfoService;
    private IConnectionHandle connectionHandle;
    private DefaultTreeNode[] domainNodes;
    private AttributeModelObserver treeUpdater;
    private boolean showOnlyBeans;
    private MBeanTreeOrderRefreshJob refreshJob;

    public MBeanTreeContentProvider(final TreeViewer treeViewer, boolean showOnlyBeans) {
        this.showOnlyBeans = showOnlyBeans;
        this.treeUpdater = new AttributeModelObserver(treeViewer);
        treeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                treeViewer.getTree().setToolTipText(null);
            }

            public void mouseHover(MouseEvent e) {
                if (treeViewer.getTree().isDisposed()) {
                    return;
                }
                TreeItem item = treeViewer.getTree().getItem(new Point(e.x, e.y));
                if (item == null) {
                    treeViewer.getTree().setToolTipText(null);
                    return;
                }
                Object data = ((ITreeNode)item.getData()).getUserData();
                if (data instanceof MBeanPropertiesOrderer.Property) {
                    MBeanPropertiesOrderer.Property property = (MBeanPropertiesOrderer.Property)data;
                    treeViewer.getTree().setToolTipText(String.valueOf(property.getKey()) + " = " + property.getValue());
                } else if (data instanceof IAttributeInfo && MBeanTreeContentProvider.this.mbeanService != null) {
                    IAttributeInfo attributeInfo = (IAttributeInfo)data;
                    treeViewer.getTree().setToolTipText(String.valueOf(AttributeInfoToolkit.getDisplayName((IConnectionHandle)MBeanTreeContentProvider.this.mbeanService.getConnectionHandle(), (AttributeDescriptor)attributeInfo.getAttributeDescriptor())) + " - " + MBeanPropertiesOrderer.getAttributePath(attributeInfo.getAttributeDescriptor()));
                } else if (data != null) {
                    treeViewer.getTree().setToolTipText(null);
                }
            }
        });
        this.refreshJob = new MBeanTreeOrderRefreshJob(treeViewer);
        MBeanPropertiesOrderer.addPropertiesOrderChangedListener(this);
    }

    private IConnectionHandle getConnectionHandle() {
        if (this.connectionHandle == null && this.mbeanService != null) {
            this.connectionHandle = (IConnectionHandle)this.mbeanService.getAdapter(IConnectionHandle.class);
        }
        return this.connectionHandle;
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode[] nodeChildren = ((ITreeNode)parentElement).getChildren();
        if (nodeChildren == null) {
            return new ITreeNode[0];
        }
        Object[] children = new ITreeNode[nodeChildren.length];
        System.arraycopy(nodeChildren, 0, children, 0, nodeChildren.length);
        return children;
    }

    public Object getParent(Object element) {
        return ((ITreeNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        ITreeNode[] children = ((ITreeNode)element).getChildren();
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (this.domainNodes == null) {
            return new ITreeNode[0];
        }
        Object[] elements = new ITreeNode[this.domainNodes.length];
        System.arraycopy(this.domainNodes, 0, elements, 0, this.domainNodes.length);
        return elements;
    }

    public void dispose() {
        this.domainNodes = null;
        MBeanPropertiesOrderer.removePropertiesOrderChangedListener(this);
        this.refreshJob = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.domainNodes = null;
            return;
        }
        if (this.attributeInfoService != null) {
            ((DefaultAttributeInfoService)this.attributeInfoService).removeAttributeInfoObserver((Observer)this.treeUpdater);
        }
        this.mbeanService = (IMBeanService)newInput;
        this.attributeInfoService = (IAttributeInfoService)this.mbeanService.getAdapter(IAttributeInfoService.class);
        this.connectionHandle = null;
        this.buildContentTree((TreeViewer)viewer);
        ((DefaultAttributeInfoService)this.attributeInfoService).addAttributeInfoObserver((Observer)this.treeUpdater);
    }

    public ITreeNode findNode(IAttributeInfo attribute) {
        AttributeDescriptor descriptor = attribute.getAttributeDescriptor();
        ObjectName bean = descriptor.getObjectName();
        ITreeNode node = this.findNode(bean);
        if (node == null) {
            return null;
        }
        ITreeNode[] set = node.getChildren();
        int a = 0;
        while (a < set.length) {
            node = this.findAttribute(attribute, set[a]);
            if (node != null) {
                return node;
            }
            ++a;
        }
        return null;
    }

    public ITreeNode findNode(ObjectName bean) {
        String domain = bean.getDomain();
        MBeanPropertiesOrderer.Property[] properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
        DefaultTreeNode node = null;
        DefaultTreeNode[] set = this.domainNodes;
        boolean found = false;
        int j = 0;
        while (j < set.length) {
            if (set[j].getUserData().equals(domain)) {
                node = set[j];
                set = set[j].getChildren();
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            return null;
        }
        int i = 0;
        while (i < properties.length) {
            found = false;
            int j2 = 0;
            while (j2 < set.length) {
                if (set[j2].getUserData().equals(properties[i])) {
                    node = set[j2];
                    set = set[j2].getChildren();
                    found = true;
                    break;
                }
                ++j2;
            }
            if (!found) {
                return null;
            }
            ++i;
        }
        return node;
    }

    private ITreeNode findAttribute(IAttributeInfo attribute, ITreeNode node) {
        IAttributeInfo nodeAttribute = (IAttributeInfo)node.getUserData();
        if (nodeAttribute.equals(attribute)) {
            return node;
        }
        if (attribute.getAttributeDescriptor().getQualifiedName().startsWith(nodeAttribute.getAttributeDescriptor().getQualifiedName())) {
            ITreeNode[] children = node.getChildren();
            if (children == null) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                node = this.findAttribute(attribute, children[i]);
                if (node != null) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    void buildContentTree(TreeViewer viewer) {
        Map connectorAttributeMap = this.attributeInfoService.getAvailableAttributes();
        HashMap<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap = new HashMap<ObjectName, List<DefaultTreeNode>>();
        for (AttributeDescriptor descriptor : connectorAttributeMap.keySet()) {
            this.mapObjectNameToAttributeNode((Viewer)viewer, beanToAttributeNodeMap, descriptor.getObjectName(), connectorAttributeMap.get(descriptor));
        }
        HashMap<String, ITreeNode> propertyToNodeMap = new HashMap<String, ITreeNode>();
        HashMap<String, List<ITreeNode>> propertyToChildrenMap = new HashMap<String, List<ITreeNode>>();
        Iterator<Object> beanIterator = beanToAttributeNodeMap.keySet().iterator();
        while (beanIterator.hasNext()) {
            this.mapPropertiesToNodes(propertyToNodeMap, propertyToChildrenMap, (ObjectName)beanIterator.next());
        }
        try {
            for (ObjectName bean : ((IMBeanHelperService)this.getConnectionHandle().getService(IMBeanHelperService.class)).getMBeanNames()) {
                this.mapPropertiesToNodes(propertyToNodeMap, propertyToChildrenMap, bean);
                if (beanToAttributeNodeMap.containsKey(bean)) continue;
                beanToAttributeNodeMap.put(bean, new ArrayList());
            }
        }
        catch (IOException e) {
            DialogToolkit.showException(Display.getCurrent().getActiveShell(), e.getMessage(), e);
        }
        this.connectPropertyTree((Viewer)viewer, propertyToNodeMap, propertyToChildrenMap, beanToAttributeNodeMap);
    }

    private void mapObjectNameToAttributeNode(Viewer viewer, Map<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap, ObjectName bean, Object object) {
        if (object instanceof IAttributeInfo) {
            List<DefaultTreeNode> attributeList = beanToAttributeNodeMap.get(bean);
            if (attributeList == null) {
                attributeList = new ArrayList<DefaultTreeNode>();
                beanToAttributeNodeMap.put(bean, attributeList);
            }
            attributeList.add(this.createAttributeNode(viewer, null, (IAttributeInfo)object));
        } else if (object instanceof Collection) {
            Iterator memberIterator = ((Collection)object).iterator();
            while (memberIterator.hasNext()) {
                this.mapObjectNameToAttributeNode(viewer, beanToAttributeNodeMap, bean, memberIterator.next());
            }
        } else {
            throw new IllegalArgumentException("Can only map beans to AttributeInfo objects or collections.");
        }
    }

    private DefaultTreeNode createAttributeNode(Viewer viewer, DefaultTreeNode parent, IAttributeInfo info) {
        DefaultTreeNode attributeNode = new DefaultTreeNode((ITreeNode)parent, (Object)info);
        if (!this.showOnlyBeans && info.isComposite()) {
            IAttributeInfo[] subAttributes = AttributeInfoToolkit.getCompositeChildren((IConnectionHandle)this.getConnectionHandle(), (IAttributeInfo)info);
            DefaultTreeNode[] subNodes = new DefaultTreeNode[subAttributes.length];
            int i = 0;
            while (i < subAttributes.length) {
                subNodes[i] = this.createAttributeNode(viewer, attributeNode, subAttributes[i]);
                ++i;
            }
            this.sortNodes(viewer, subNodes);
            attributeNode.setChildren((ITreeNode[])subNodes);
        }
        return attributeNode;
    }

    private void sortNodes(Viewer viewer, DefaultTreeNode[] nodes) {
        ViewerSorter sorter;
        if (viewer instanceof TreeViewer && (sorter = ((TreeViewer)viewer).getSorter()) != null) {
            sorter.sort(viewer, (Object[])nodes);
        }
    }

    private void mapPropertiesToNodes(Map<String, ITreeNode> propertyToNodeMap, Map<String, List<ITreeNode>> propertyToChildrenMap, ObjectName bean) {
        MBeanPropertiesOrderer.Property[] properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
        String parentPropertiesString = bean.getDomain();
        ITreeNode parentNode = propertyToNodeMap.get(parentPropertiesString);
        if (parentNode == null) {
            parentNode = new DefaultTreeNode((Object)parentPropertiesString);
            propertyToNodeMap.put(parentPropertiesString, parentNode);
        }
        String propertiesString = String.valueOf(parentPropertiesString) + ':';
        int i = 0;
        while (i < properties.length) {
            MBeanPropertiesOrderer.Property property = properties[i];
            ITreeNode propertyNode = propertyToNodeMap.get(propertiesString = String.valueOf(propertiesString) + property.getKey() + '=' + property.getValue());
            if (propertyNode == null) {
                propertyNode = new DefaultTreeNode(parentNode, (Object)properties[i]);
                propertyToNodeMap.put(propertiesString, propertyNode);
                if (parentNode != null) {
                    List<ITreeNode> parentChildren = propertyToChildrenMap.get(parentPropertiesString);
                    if (parentChildren == null) {
                        parentChildren = new ArrayList<ITreeNode>();
                        propertyToChildrenMap.put(parentPropertiesString, parentChildren);
                    }
                    parentChildren.add(propertyNode);
                }
            }
            parentNode = propertyNode;
            parentPropertiesString = propertiesString;
            propertiesString = String.valueOf(propertiesString) + ',';
            ++i;
        }
    }

    private void connectPropertyTree(Viewer viewer, Map<String, ITreeNode> propertyToNodeMap, Map<String, List<ITreeNode>> propertyToChildrenMap, Map<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap) {
        Iterator<String> nodeIterator = propertyToNodeMap.keySet().iterator();
        ArrayList<DefaultTreeNode> domainNodesList = new ArrayList<DefaultTreeNode>();
        while (nodeIterator.hasNext()) {
            List<ITreeNode> propertyChildren;
            String propertiesString = nodeIterator.next();
            DefaultTreeNode propertyNode = (DefaultTreeNode)propertyToNodeMap.get(propertiesString);
            if (propertyNode.getParent() == null) {
                domainNodesList.add(propertyNode);
            }
            if ((propertyChildren = propertyToChildrenMap.get(propertiesString)) == null) {
                if (this.showOnlyBeans) continue;
                ObjectName bean = ((MBeanPropertiesOrderer.PropertyWithMBean)propertyNode.getUserData()).getBean();
                List<DefaultTreeNode> attributeList = beanToAttributeNodeMap.get(bean);
                DefaultTreeNode[] children = attributeList.toArray(new DefaultTreeNode[attributeList.size()]);
                this.sortNodes(viewer, children);
                propertyNode.setChildren((ITreeNode[])children);
                int i = 0;
                while (i < children.length) {
                    children[i].setParent((ITreeNode)propertyNode);
                    ++i;
                }
                continue;
            }
            DefaultTreeNode[] children = propertyChildren.toArray(new DefaultTreeNode[propertyChildren.size()]);
            this.sortNodes(viewer, children);
            propertyNode.setChildren((ITreeNode[])children);
        }
        this.domainNodes = domainNodesList.toArray(new DefaultTreeNode[domainNodesList.size()]);
    }

    public boolean isShowOnlyBeans() {
        return this.showOnlyBeans;
    }

    @Override
    public void propertiesOrderChanged(PropertyChangeEvent e) {
        if (!e.getProperty().equals("console.ui.mbeanbrowser.showCompressedPaths")) {
            this.refreshJob.schedule();
        }
    }

    private static class AttributeModelObserver
    implements Observer {
        private TreeViewer treeViewer;

        public AttributeModelObserver(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void update(Observable source, final Object o) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!AttributeModelObserver.this.treeViewer.getTree().isDisposed()) {
                        if (o instanceof IAttributeInfo) {
                            AttributeModelObserver.this.treeViewer.refresh(o);
                        } else {
                            AttributeModelObserver.this.treeViewer.refresh();
                        }
                    }
                }
            });
        }
    }
}

