/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.misc.SwingSupport;
import com.jrockit.mc.rjmx.core.connections.internal.ConnectionDescriptorNode;
import com.jrockit.mc.rjmx.core.connections.internal.IConnectionHandler;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import com.jrockit.mc.rjmx.ui.misc.Messages;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.impl.DefaultXYGreyChart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalToolkit {
    private static Object swingPreloadState = Boolean.FALSE;

    public static boolean unsupportedKey(String key) {
        RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "The property " + key + " is not supported by the visualizer");
        return false;
    }

    public static synchronized void disconnect(Shell parent, Collection<ConnectionDescriptorNode> connectionNodes) {
        ArrayList list = new ArrayList();
        Iterator<ConnectionDescriptorNode> iter = connectionNodes.iterator();
        while (iter.hasNext()) {
            List handlers = iter.next().getConnectionHandlers();
            list.addAll(handlers);
        }
        StringBuffer builder = new StringBuffer(Messages.DialogUtils_MESSAGE_WILL_CLOSE_APPS);
        Iterator<Object> iter2 = list.iterator();
        while (iter2.hasNext()) {
            IConnectionHandler handler = (IConnectionHandler)iter2.next();
            if (handler == null) continue;
            builder.append(handler.getHandlerName());
            if (!iter2.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(".");
        if (MessageDialog.openQuestion((Shell)parent, (String)Messages.DialogUtils_TITLE_DISCONNECT, (String)builder.toString())) {
            for (ConnectionDescriptorNode connectionNode : connectionNodes) {
                List handlers = connectionNode.getConnectionHandlers();
                Iterator handlerIter = handlers.iterator();
                while (handlerIter.hasNext()) {
                    InternalToolkit.disconnect((IConnectionHandler)handlerIter.next(), connectionNode, true);
                }
            }
        }
    }

    public static synchronized void disconnect(IConnectionHandler handler, ConnectionDescriptorNode connectionNode, boolean hard) {
        handler.shutDown(hard);
        connectionNode.removeConnectionHandler(handler);
    }

    public static void preloadSwing() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                Class<InternalToolkit> clazz = InternalToolkit.class;
                synchronized (InternalToolkit.class) {
                    SwingSupport.initLookAndFeel();
                    if (swingPreloadState != Boolean.FALSE) return;
                    GreyChartPanel panel = new GreyChartPanel((GreyChart)new DefaultXYGreyChart());
                    panel.paint((Graphics)new BufferedImage(100, 100, 2).createGraphics());
                    Class<DialogToolkit> clazz2 = DialogToolkit.class;
                    synchronized (DialogToolkit.class) {
                        swingPreloadState = panel;
                        DialogToolkit.class.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    public static synchronized void waitUntilSwingPreloaded() {
        InternalToolkit.preloadSwing();
        while (swingPreloadState == Boolean.FALSE) {
            try {
                DialogToolkit.class.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

