/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.ClassFactory;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeMetaDataManager;
import com.jrockit.mc.rjmx.ui.internal.AttributeColorData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class GraphSettingRegistry
implements XmlEnabled {
    private static final String PROPERTY_COLOR = "color";
    private static final String ELEMENT_MULTIPLIER_MAP = "multiplierMap";
    private static final String ELEMENT_COLOR_DATA_MAP = "colorDataMap";
    static final String MULTIPLIER_PROPERTY_KEY = "multiplier";
    public static final String TAG_ATTRIBUTE_COLOR_MANAGER = "AttributeColorManager";
    public static final Double DEFAULT_MULTIPLIER = new Double(1.0);
    public static final int THUMBNAIL_SIZE = 16;
    public static final Color[] DEFAULT_COLORS = new Color[]{Color.RED, Color.BLUE, Color.GREEN, Color.CYAN, Color.MAGENTA};
    private static AttributeColorData greyedOutColorData = new AttributeColorData(Color.LIGHT_GRAY);
    private IAttributeInfoService attributeInfoService;
    private Map<AttributeDescriptor, Double> multiplierMap;
    private ArrayList<Runnable> undoTaskList;
    private AttributeDescriptor[] trackedAttributes;
    private Map<AttributeDescriptor, AttributeColorData> attributeColorDataMap;
    private String uid;
    private ArrayList<Runnable> commitTaskList = new ArrayList();

    public GraphSettingRegistry(String uid) {
        this(uid, null);
    }

    public GraphSettingRegistry(String uid, IAttributeInfoService infoManager) {
        this.uid = uid;
        this.attributeColorDataMap = new HashMap<AttributeDescriptor, AttributeColorData>();
        this.multiplierMap = new HashMap<AttributeDescriptor, Double>();
        this.undoTaskList = new ArrayList();
        this.attributeInfoService = infoManager;
    }

    public Image getColorThumbnail(AttributeDescriptor descriptor) {
        return this.getAttributeColorData(descriptor).getColorThumbnail();
    }

    public Color getAWTColor(AttributeDescriptor descriptor) {
        return this.getAttributeColorData(descriptor).getAWTColor();
    }

    public static Color getGreyedOutAWTColor() {
        return greyedOutColorData.getAWTColor();
    }

    public static Image getGreyedOutColorThumbnail() {
        return greyedOutColorData.getColorThumbnail();
    }

    public boolean canUpdateMultiplier() {
        return this.attributeInfoService != null;
    }

    public void registerUndoableMultiplierChange(final AttributeDescriptor descriptor, final Double multiplier) {
        final Double oldMultiplier = this.getMultiplier(descriptor);
        this.multiplierMap.put(descriptor, multiplier);
        this.undoTaskList.add(new Runnable(){

            public void run() {
                GraphSettingRegistry.this.multiplierMap.put(descriptor, oldMultiplier);
            }
        });
        if (this.uid != null) {
            this.registerCommitTask(new Runnable(){

                public void run() {
                    if (GraphSettingRegistry.this.canUpdateMultiplier()) {
                        GraphSettingRegistry.this.attributeInfoService.setMetaData(descriptor, GraphSettingRegistry.MULTIPLIER_PROPERTY_KEY, (Object)multiplier.toString());
                    }
                }
            });
        }
    }

    public void registerUndoableColorChange(final AttributeDescriptor descriptor, final Color color) {
        final AttributeColorData oldColorData = this.getAttributeColorData(descriptor);
        this.attributeColorDataMap.put(descriptor, new AttributeColorData(color));
        this.undoTaskList.add(new Runnable(){

            public void run() {
                GraphSettingRegistry.this.attributeColorDataMap.put(descriptor, oldColorData);
            }
        });
        if (this.uid != null) {
            this.registerCommitTask(new Runnable(){

                public void run() {
                    String colorString = "#" + GraphSettingRegistry.this.getTwoCharColorString(color.getRed()) + GraphSettingRegistry.this.getTwoCharColorString(color.getGreen()) + GraphSettingRegistry.this.getTwoCharColorString(color.getBlue());
                    ((AttributeMetaDataManager)RJMXPlugin.getDefault().getService(AttributeMetaDataManager.class)).setMetaData(GraphSettingRegistry.this.uid, descriptor, GraphSettingRegistry.PROPERTY_COLOR, (Object)colorString);
                }
            });
        }
    }

    private String getTwoCharColorString(int colorVal) {
        String val = Integer.toHexString(colorVal);
        if (val.length() == 1) {
            val = String.valueOf(Integer.toString(0)) + val;
        }
        return val;
    }

    private void registerCommitTask(Runnable task) {
        this.commitTaskList.add(task);
    }

    public Double getMultiplier(AttributeDescriptor descriptor) {
        Double multiplier = this.multiplierMap.get(descriptor);
        if (multiplier == null) {
            multiplier = this.getDefaultMultiplierValue(descriptor);
        }
        return multiplier;
    }

    public void commit() {
        this.undoTaskList.clear();
        Iterator<Runnable> iter = this.commitTaskList.iterator();
        while (iter.hasNext()) {
            iter.next().run();
        }
    }

    public void rollback() {
        Iterator<Runnable> iter = this.undoTaskList.iterator();
        while (iter.hasNext()) {
            iter.next().run();
        }
        this.undoTaskList.clear();
        this.commitTaskList.clear();
    }

    private Double getDefaultMultiplierValue(AttributeDescriptor descriptor) {
        String s = (String)((AttributeMetaDataManager)RJMXPlugin.getDefault().getService(AttributeMetaDataManager.class)).getMetaData(this.uid, descriptor, MULTIPLIER_PROPERTY_KEY);
        if (s != null) {
            try {
                return new Double(Double.parseDouble(s));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            return DEFAULT_MULTIPLIER;
        }
        return new Double(1.0);
    }

    public void trackMultipliersForAttributes(AttributeDescriptor[] descriptors) {
        this.trackedAttributes = descriptors;
    }

    private AttributeColorData getAttributeColorData(AttributeDescriptor descriptor) {
        if (!this.attributeColorDataMap.containsKey(descriptor)) {
            String colorString = (String)((AttributeMetaDataManager)RJMXPlugin.getDefault().getService(AttributeMetaDataManager.class)).getMetaData(this.uid, descriptor, PROPERTY_COLOR);
            if (colorString != null) {
                this.attributeColorDataMap.put(descriptor, new AttributeColorData(Color.decode(colorString)));
            } else {
                this.attributeColorDataMap.put(descriptor, new AttributeColorData(this.getUniqueColor(descriptor)));
            }
        }
        return this.attributeColorDataMap.get(descriptor);
    }

    private Color getUniqueColor(AttributeDescriptor descriptor) {
        if (this.attributeColorDataMap.size() < DEFAULT_COLORS.length) {
            return DEFAULT_COLORS[this.attributeColorDataMap.size()];
        }
        Random r = new Random(descriptor.hashCode());
        return Color.getHSBColor(r.nextFloat(), 0.8f, 0.8f);
    }

    public void exportToXml(Element parentNode) {
        if (this.trackedAttributes != null) {
            int i = 0;
            while (i < this.trackedAttributes.length) {
                this.multiplierMap.put(this.trackedAttributes[i], this.getMultiplier(this.trackedAttributes[i]));
                ++i;
            }
        }
        Element managerNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setNameTypeValue((Element)managerNode, (String)ELEMENT_COLOR_DATA_MAP, this.attributeColorDataMap);
        XmlToolkit.setNameTypeValue((Element)managerNode, (String)ELEMENT_MULTIPLIER_MAP, this.multiplierMap);
    }

    public String getComponentTag() {
        return TAG_ATTRIBUTE_COLOR_MANAGER;
    }

    public void initializeFromXml(Element node) {
        try {
            ClassFactory factory = new ClassFactory(){

                public Class<?> forName(String name) throws ClassNotFoundException {
                    if (name.equals("com.jrockit.console.attribute.AttributeName")) {
                        name = AttributeDescriptor.class.getName();
                    }
                    return Class.forName(name);
                }
            };
            this.attributeColorDataMap = (Map)XmlToolkit.getNameTypeValue((Element)node, (String)ELEMENT_COLOR_DATA_MAP, (ClassFactory)factory);
            this.multiplierMap = (Map)XmlToolkit.getNameTypeValue((Element)node, (String)ELEMENT_MULTIPLIER_MAP, (ClassFactory)factory);
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
    }
}

