/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.core.sections.MultiSectionPart;
import com.jrockit.mc.core.ui.IRefreshable;
import com.jrockit.mc.core.ui.MCToolBarManager;
import com.jrockit.mc.core.ui.dial.RefreshController;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeDialSectionPart;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardSectionPart
extends MultiSectionPart
implements IAttributeVisualizer,
XmlEnabled {
    public static final String TAG_DASHBOARD = "dashBoard";
    public static final String XML_ATTRIBUTE_SECTION_IDENTIFIER = "sectionIdentifier";
    private static final String XML_DASHBOARD_TITLE = "title";
    private final RefreshController m_refreshController;
    private Object m_input;
    private AddDialAction m_addDialAction;
    private RemoveDialAction m_removeDialAction;
    private String m_title;

    public DashboardSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 322, sectionIdentifier);
        this.m_refreshController = new RefreshController(parent.getDisplay());
    }

    @Override
    public boolean add(AttributeDescriptor attributeDescriptor) {
        AttributeDialSectionPart dsp = new AttributeDialSectionPart(this.getSectionParent(), this.getFormToolkit(), DashboardSectionPart.createIdentifier(this.getChildren().size()));
        dsp.setRemoveAction((IAction)new RemoveAction(dsp));
        dsp.setFormInput(this.m_input);
        dsp.add(attributeDescriptor);
        this.addSectionPart((SectionPart)dsp);
        this.getController().add((IRefreshable)dsp.getDialViewer());
        this.getController().start();
        this.updatePart();
        return true;
    }

    public void removeLastDial() {
        List children = this.getChildren();
        if (children.size() >= 1) {
            SectionPart lastDial = (SectionPart)children.get(children.size() - 1);
            this.removeSectionPart(lastDial);
            this.updatePart();
        }
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.m_input;
    }

    private void updatePart() {
        this.updateAddAction();
        this.updateRemoveDialAction();
        this.update();
        this.getManagedForm().reflow(true);
    }

    @Override
    public List<AttributeDescriptor> getAttributeDescriptors() {
        ArrayList<AttributeDescriptor> list = new ArrayList<AttributeDescriptor>();
        for (AttributeDialSectionPart ads : this.getChildren()) {
            list.addAll(ads.getAttributeDescriptors());
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean remove(AttributeDescriptor attributeDescriptor) {
        for (AttributeDialSectionPart dsp : this.getChildren()) {
            if (!dsp.getAttributeDescriptors().contains(attributeDescriptor)) continue;
            this.removeSectionPart((SectionPart)dsp);
            if (this.getChildren().size() == 0) {
                this.getController().stop();
            }
            this.updatePart();
            return true;
        }
        return false;
    }

    void updateAddAction() {
        if (this.m_addDialAction != null) {
            if (!this.getMCToolBarManager().getActions().contains((Object)this.m_addDialAction)) {
                this.getMCToolBarManager().add((IAction)this.m_addDialAction, MCToolBarManager.ALIGN_LEFT);
            }
            this.m_removeDialAction.setEnabled(true);
            this.getMCToolBarManager().update();
        }
    }

    void updateRemoveDialAction() {
        if (this.m_removeDialAction != null) {
            if (!this.getMCToolBarManager().getActions().contains((Object)this.m_removeDialAction)) {
                this.getMCToolBarManager().add((IAction)this.m_removeDialAction, MCToolBarManager.ALIGN_CENTER_LEFT);
            }
            if (this.getChildren().size() > 0) {
                this.m_removeDialAction.setEnabled(true);
            } else {
                this.m_removeDialAction.setEnabled(false);
            }
            this.getMCToolBarManager().update();
        }
    }

    @Override
    public Control getControl() {
        return this.getSection();
    }

    public void initializePart() {
        super.initializePart();
        this.updatePart();
    }

    public void dispose() {
        super.dispose();
        this.getController().stop();
    }

    private RefreshController getController() {
        return this.m_refreshController;
    }

    public String getComponentTag() {
        return TAG_DASHBOARD;
    }

    public boolean setFormInput(Object input) {
        this.m_input = input;
        for (MCSectionPart mc : this.getChildren()) {
            mc.setFormInput(input);
        }
        return true;
    }

    protected void initializeSection(Section section) {
        section.setText("");
        this.m_addDialAction = new AddDialAction();
        this.m_removeDialAction = new RemoveDialAction();
    }

    public void exportToXml(Element parentNode) {
        Element e1 = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)e1, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)this.getSectionIdentifier());
        XmlToolkit.setSetting((Element)e1, (String)XML_DASHBOARD_TITLE, (String)this.m_title);
        List parts = super.getChildren();
        for (AttributeDialSectionPart part : parts) {
            part.exportToXml(e1);
        }
    }

    public void initializeFromXml(Element node) throws Exception {
        try {
            this.setSectionIdentifier(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)"unknown"));
            this.setHelpContextID(this.getSectionIdentifier());
            this.m_title = XmlToolkit.getSetting((Element)node, (String)XML_DASHBOARD_TITLE, (String)"");
            List attributeNodes = XmlToolkit.getChildNodesByTag((Node)node, (String)"dial");
            int i = 0;
            while (i < attributeNodes.size()) {
                AttributeDialSectionPart dsp = new AttributeDialSectionPart(this.getSectionParent(), this.getFormToolkit(), DashboardSectionPart.createIdentifier(i));
                dsp.setFormInput(this.m_input);
                this.addSectionPart((SectionPart)dsp);
                dsp.initializeFromXml((Element)attributeNodes.get(i));
                dsp.setRemoveAction((IAction)new RemoveAction(dsp));
                this.getController().add((IRefreshable)dsp.getDialViewer());
                this.getController().start();
                this.update();
                ++i;
            }
            this.updateTitle();
        }
        catch (Exception e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not initialize dials properly. Will use default dials", e);
        }
    }

    private void updateTitle() {
        if (!this.getSection().isDisposed()) {
            this.getSection().setText(this.m_title == null ? "" : this.m_title);
            this.getSection().layout(true, true);
        }
    }

    private static String createIdentifier(int index) {
        return "com.jrockit.mc.console.ui.dashboard.dial" + index;
    }

    protected void initSectionPart(Composite parent) {
    }

    @Override
    public Object getProperty(String key) {
        return null;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (key.equals(AttributeVisualizerBuilder.TITLE) && value instanceof String) {
            this.m_title = (String)value;
            this.updateTitle();
            return true;
        }
        return InternalToolkit.unsupportedKey(key);
    }

    class AddDialAction
    extends Action {
        public AddDialAction() {
            super("", RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
            this.setToolTipText(Messages.DashboardSectionPart_ADD_DIAL_ACTION_TEXT);
            this.setText(Messages.DashboardSectionPart_ADD_DIAL_ACTION_TEXT);
            this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj-off.gif"));
        }

        public void run() {
            IProxyNames names = (IProxyNames)DashboardSectionPart.this.getConnectionHandle().getService(IProxyNames.class);
            DashboardSectionPart.this.add(names.getAttributeDescriptor(IProxyNames.Key.OS_JVM_CPU_LOAD));
        }
    }

    public class RemoveAction
    extends Action {
        private final IAttributeVisualizer m_visualizer;

        public RemoveAction(IAttributeVisualizer visualizer) {
            this.setImageDescriptor(CorePlugin.getDefault().getMCImageDescriptor("delete-16.png"));
            this.setText(Messages.DashboardSectionPart_REMOVE_CONTROL_TEXT);
            this.setToolTipText(Messages.DashboardSectionPart_REMOVE_CONTROL_TEXT);
            this.m_visualizer = visualizer;
        }

        public void run() {
            List<AttributeDescriptor> list = this.m_visualizer.getAttributeDescriptors();
            if (!list.isEmpty()) {
                DashboardSectionPart.this.remove(list.get(0));
            }
        }
    }

    class RemoveDialAction
    extends Action {
        public RemoveDialAction() {
            super("", RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj.png"));
            this.setToolTipText(Messages.DashboardSectionPart_REMOVE_DIAL_ACTION_TEXT);
            this.setText(Messages.DashboardSectionPart_REMOVE_DIAL_ACTION_TEXT);
            this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj-off.gif"));
        }

        public void run() {
            DashboardSectionPart.this.removeLastDial();
        }
    }
}

