/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.sections.MCClientSectionPart;
import com.jrockit.mc.core.ui.MCBook;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AccessibleComposite;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.internal.ToggleAccessibleControlAction;
import com.jrockit.mc.rjmx.ui.internal.ToggleFreezeAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;

public abstract class CombinedSectionPart
extends MCClientSectionPart
implements XmlEnabled {
    public static final String XML_ATTRIBUTE_SECTION_IDENTIFIER = "sectionIdentifier";
    public static final String XML_ATTRIBUTE_SECTION_TITLE = "sectionTitle";
    public static final String XML_ATTRIBUTE_SHOWING_ACCESSIBLE_MODE = "showingAccessibleMode";
    public static final String XML_ATTRIBUTE_GLOBAL_ACCESSIBLE_MODE = "globalAccessibleMode";
    private Map<String, Object> m_properties;
    private String m_title;
    private MCBook m_book;
    private Control m_graphicalControl;
    private AccessibleComposite m_accessibleControl;
    private ToggleAccessibleControlAction m_toggleAccessibleControlAction;

    public CombinedSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    public void dispose() {
        super.dispose();
        if (this.m_toggleAccessibleControlAction != null) {
            this.m_toggleAccessibleControlAction.dispose();
            this.m_toggleAccessibleControlAction = null;
        }
        this.m_graphicalControl.dispose();
        this.m_accessibleControl.dispose();
    }

    protected void updateTitle(String title) {
        this.m_title = title;
        if (!this.getSection().isDisposed()) {
            this.getSection().setText(this.m_title == null ? "" : this.m_title);
            this.getSection().layout(true, true);
        }
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        this.m_book = new MCBook(section, 262144);
        formToolkit.adapt((Composite)this.m_book);
        FreezeModel freezeModel = new FreezeModel();
        this.m_graphicalControl = this.createGraphicalControl((Composite)this.m_book, formToolkit, freezeModel);
        this.m_accessibleControl = this.createAccessibleComposite((Composite)this.m_book, formToolkit, freezeModel);
        this.updateView(CorePlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode"));
        this.addSectionActions(freezeModel);
        return this.m_book;
    }

    private void addSectionActions(FreezeModel freezeModel) {
        this.m_toggleAccessibleControlAction = new ToggleAccessibleControlAction(this);
        this.getMCToolBarManager().add((IAction)this.m_toggleAccessibleControlAction);
        this.getMCToolBarManager().add((IAction)new ToggleFreezeAction(this.getMCToolBarManager(), freezeModel));
    }

    protected abstract Control createGraphicalControl(Composite var1, FormToolkit var2, FreezeModel var3);

    protected abstract AccessibleComposite createAccessibleComposite(Composite var1, FormToolkit var2, FreezeModel var3);

    protected void updateView(boolean useAccessibilityMode) {
        if (useAccessibilityMode) {
            this.m_book.showPage((Control)this.m_accessibleControl);
        } else {
            this.m_book.showPage(this.m_graphicalControl);
        }
    }

    protected void initializeSection(Section section) {
    }

    protected void exportExtraToXml(Element node) {
    }

    public void exportToXml(Element parentNode) {
        Element node = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)this.getSectionIdentifier());
        XmlToolkit.setSetting((Element)node, (String)XML_ATTRIBUTE_SHOWING_ACCESSIBLE_MODE, (boolean)this.m_toggleAccessibleControlAction.isChecked());
        XmlToolkit.setSetting((Element)node, (String)XML_ATTRIBUTE_GLOBAL_ACCESSIBLE_MODE, (boolean)CorePlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode"));
        if (this.m_title != null) {
            XmlToolkit.setSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_TITLE, (String)this.m_title);
        }
        this.exportExtraToXml(node);
    }

    protected void initializeExtraFromXml(Element node) throws Exception {
    }

    public void initializeFromXml(Element node) throws Exception {
        this.setSectionIdentifier(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)"unknown"));
        this.setHelpContextID(this.getSectionIdentifier());
        boolean savedShowingAccessibleMode = XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SHOWING_ACCESSIBLE_MODE, (boolean)false);
        boolean savedGlobalAccessibleMode = XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_GLOBAL_ACCESSIBLE_MODE, (boolean)false);
        boolean currentGlobalAccessibleMode = CorePlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode");
        if (savedGlobalAccessibleMode == currentGlobalAccessibleMode) {
            this.m_toggleAccessibleControlAction.setChecked(savedShowingAccessibleMode);
        } else {
            this.m_toggleAccessibleControlAction.setChecked(currentGlobalAccessibleMode);
        }
        this.m_toggleAccessibleControlAction.run();
        this.updateTitle(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_TITLE, null));
        this.getMCToolBarManager().update();
        this.initializeExtraFromXml(node);
    }

    protected void storeProperty(String key, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>();
        }
        this.m_properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.m_properties != null ? this.m_properties.get(key) : null;
    }

    public boolean setProperty(String key, Object value) {
        if (value instanceof String) {
            if (key.equals(AttributeVisualizerBuilder.TITLE)) {
                this.storeProperty(key, value);
                this.updateTitle((String)value);
                return true;
            }
        } else {
            throw new IllegalArgumentException("Unkown property " + key);
        }
        return InternalToolkit.unsupportedKey(key);
    }
}

