/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeSubscriptionChart;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.ui.internal.ChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedAttributeSectionPart;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.hirt.greychart.data.ITimestampedData;

public class CombinedChartSectionPart
extends CombinedAttributeSectionPart {
    public static final String TAG_COMBINED_CHART_SECTION_PART = "CombinedChartSectionPart";
    private AttributeChartModel<ITimestampedData> m_chartModel;
    private AttributeDescriptorModel m_attributeDescriptorModel;

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    private void addLoggingAction() {
        if (this.m_attributeDescriptorModel != null) {
            final ChartSectionPart.LogToHistoricalDataAction lhda = new ChartSectionPart.LogToHistoricalDataAction(this.getSection().getShell(), this.m_attributeDescriptorModel);
            this.getMCToolBarManager().add((IAction)lhda);
            this.m_attributeDescriptorModel.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    lhda.setChecked(CombinedChartSectionPart.this.m_attributeDescriptorModel.getPersistenceEnabled());
                    CombinedChartSectionPart.this.getMCToolBarManager().update();
                }
            });
        }
    }

    protected Control createGraphicalControl(Composite parent, FormToolkit formToolkit, FreezeModel freezeModel) {
        AttributeXYDataProvider dataProvider = new AttributeXYDataProvider(this.getMBeanService());
        dataProvider.setDisplayedXRange(60000L);
        this.m_chartModel = new AttributeChartModel<ITimestampedData>(new GraphSettingRegistry(this.getConnectionHandle().getDescriptor().getGUID(), (IAttributeInfoService)this.getConnectionHandle().getService(IAttributeInfoService.class)), dataProvider);
        this.m_attributeDescriptorModel = new AttributeDescriptorModel(this.getConnectionHandle(), this.m_chartModel);
        this.getAttributeModel().addAttributeModelListener(new IAttributeModelListener(){
            private IAttributeInfoService attributeInfoService;
            {
                this.attributeInfoService = CombinedChartSectionPart.this.getMBeanService().getAttributeInfoService();
            }

            public void attributeAdded(AttributeModelEvent event) {
                AttributeDescriptor attribute = event.getAttribute();
                IAttributeInfo info = this.attributeInfoService.getAttributeInfo(attribute);
                if (info.isNumerical()) {
                    CombinedChartSectionPart.this.m_attributeDescriptorModel.add(info.getAttributeDescriptor());
                }
            }

            public void attributeRemoved(AttributeModelEvent event) {
                CombinedChartSectionPart.this.m_attributeDescriptorModel.remove(event.getAttribute());
            }

            public void attributeChanged(AttributeModelEvent event) {
            }
        });
        this.m_attributeDescriptorModel.addObserver(new Observer(){
            private IAttributeInfoService attributeInfoService;
            {
                this.attributeInfoService = CombinedChartSectionPart.this.getMBeanService().getAttributeInfoService();
            }

            public void update(Observable o, Object arg) {
                AttributeDescriptorModel adm = (AttributeDescriptorModel)o;
                List<AttributeDescriptor> attributes = adm.getAttributeDescriptors();
                ArrayList<AttributeDescriptor> addedAttributes = new ArrayList<AttributeDescriptor>();
                Iterator<Object> iterator = attributes.iterator();
                while (iterator.hasNext()) {
                    AttributeDescriptor ao;
                    AttributeDescriptor attribute = ao = iterator.next();
                    if (CombinedChartSectionPart.this.getAttributeModel().contains(attribute)) continue;
                    addedAttributes.add(attribute);
                }
                for (AttributeDescriptor attribute : addedAttributes) {
                    CombinedChartSectionPart.this.getAttributeModel().add(attribute);
                }
                ArrayList<AttributeDescriptor> removedAttributes = new ArrayList<AttributeDescriptor>();
                AttributeDescriptor[] attributeDescriptorArray = CombinedChartSectionPart.this.getAttributeModel().getAttributeDescriptors();
                int n = attributeDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDescriptor attribute = attributeDescriptorArray[n2];
                    if (!attributes.contains(attribute) && this.attributeInfoService.getAttributeInfo(attribute).isNumerical()) {
                        removedAttributes.add(attribute);
                    }
                    ++n2;
                }
                for (AttributeDescriptor attribute : removedAttributes) {
                    CombinedChartSectionPart.this.getAttributeModel().remove(attribute);
                }
            }
        });
        AttributeSubscriptionChart chart = new AttributeSubscriptionChart(parent, 0, formToolkit, this.m_attributeDescriptorModel, this.getMBeanService(), freezeModel);
        this.addLoggingAction();
        return chart;
    }

    public String getComponentTag() {
        return TAG_COMBINED_CHART_SECTION_PART;
    }

    protected void exportExtraToXml(Element node) {
        super.exportExtraToXml(node);
        this.m_attributeDescriptorModel.exportToXml(node);
    }

    protected void initializeExtraFromXml(Element node) throws Exception {
        super.initializeExtraFromXml(node);
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)this.m_attributeDescriptorModel.getComponentTag());
        if (l.size() > 0) {
            this.m_attributeDescriptorModel.initializeFromXml((Element)l.get(0));
        }
    }

    public boolean setProperty(String key, Object value) {
        if (value instanceof String) {
            if (key.equals(AttributeVisualizerBuilder.TITLE)) {
                this.storeProperty(key, value);
                this.m_chartModel.setChartTitle((String)value);
                this.m_chartModel.notifyObservers();
                return true;
            }
            if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_Y)) {
                this.storeProperty(key, value);
                this.m_chartModel.getYAxis().setTitle((String)value);
                this.m_chartModel.getYAxis().notifyObservers();
                return true;
            }
            if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_X)) {
                this.storeProperty(key, value);
                this.m_chartModel.getXAxis().setTitle((String)value);
                this.m_chartModel.getXAxis().notifyObservers();
                return true;
            }
        } else if (value instanceof Integer && key.equals(AttributeVisualizerBuilder.RANGE_TYPE_AXIS_Y)) {
            this.storeProperty(key, value);
            this.m_chartModel.getYAxis().setRangeType((Integer)value);
            this.m_chartModel.getYAxis().notifyObservers();
            return true;
        }
        return super.setProperty(key, value);
    }
}

