/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.internal.AccessibleAttributeComposite;
import com.jrockit.mc.rjmx.ui.internal.AccessibleComposite;
import com.jrockit.mc.rjmx.ui.internal.AttributeModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedSectionPart;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CombinedAttributeSectionPart
extends CombinedSectionPart
implements IAttributeVisualizer {
    private IConnectionHandle m_connectionHandle;
    private AttributeModel m_attributeModel = new AttributeModel();

    public CombinedAttributeSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected AttributeModel getAttributeModel() {
        return this.m_attributeModel;
    }

    protected IMBeanService getMBeanService() {
        if (this.getConnectionHandle() != null) {
            return (IMBeanService)this.getConnectionHandle().getService(IMBeanService.class);
        }
        return null;
    }

    protected IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IConnectionHandle) {
            this.m_connectionHandle = (IConnectionHandle)input;
            this.getAttributeModel().setMBeanService(this.getMBeanService());
            return true;
        }
        return false;
    }

    @Override
    protected AccessibleComposite createAccessibleComposite(Composite parent, FormToolkit formToolkit, FreezeModel freezeModel) {
        return new AccessibleAttributeComposite(parent, 0, formToolkit, this.getMBeanService(), this.getSite(), this.getAttributeModel(), freezeModel);
    }

    @Override
    protected void exportExtraToXml(Element node) {
        super.exportExtraToXml(node);
        this.getAttributeModel().exportToXml(node);
    }

    @Override
    protected void initializeExtraFromXml(Element node) throws Exception {
        super.initializeExtraFromXml(node);
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)this.getAttributeModel().getComponentTag());
        if (l.size() > 0) {
            this.getAttributeModel().initializeFromXml((Element)l.get(0));
        }
    }

    @Override
    public boolean add(AttributeDescriptor attribute) {
        return this.getAttributeModel().add(attribute);
    }

    @Override
    public boolean remove(AttributeDescriptor attribute) {
        return this.getAttributeModel().remove(attribute);
    }

    @Override
    public List<AttributeDescriptor> getAttributeDescriptors() {
        return Arrays.asList(this.getAttributeModel().getAttributeDescriptors());
    }

    @Override
    public void clear() {
        this.getAttributeModel().clear();
    }

    @Override
    public Control getControl() {
        return this.getSection();
    }
}

