/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.sections.MCClientSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeSubscriptionChart;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.ToggleFreezeAction;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.hirt.greychart.data.ITimestampedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartSectionPart
extends MCClientSectionPart
implements IAttributeVisualizer,
XmlEnabled {
    public static final String TAG_CHART_SECTION_PART = "ChartSectionPart";
    public static final String SECTION_TITLE = "AbstractAttributeVisualizerTitle";
    public static final String XML_ATTRIBUTE_SECTION_IDENTIFIER = "sectionIdentifier";
    private AttributeDescriptorModel m_attributeDescriptorModel;
    private IConnectionHandle m_connectionHandle;
    private AttributeSubscriptionChart m_chart;
    private AttributeXYDataProvider m_xyDataProvider;

    public ChartSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        this.m_xyDataProvider = new AttributeXYDataProvider(this.getMBeanService());
        this.m_xyDataProvider.setDisplayedXRange(60000L);
        AttributeChartModel<ITimestampedData> chartModel = new AttributeChartModel<ITimestampedData>(new GraphSettingRegistry(this.getConnectionHandle().getDescriptor().getGUID(), (IAttributeInfoService)this.getConnectionHandle().getService(IAttributeInfoService.class)), this.m_xyDataProvider);
        this.m_attributeDescriptorModel = new AttributeDescriptorModel(this.getConnectionHandle(), chartModel);
        FreezeModel freezeModel = new FreezeModel();
        this.m_chart = new AttributeSubscriptionChart(section, 0, formToolkit, this.m_attributeDescriptorModel, this.getMBeanService(), freezeModel);
        this.addLoggingAction();
        this.getMCToolBarManager().add((IAction)new ToggleFreezeAction(this.getMCToolBarManager(), freezeModel));
        return this.m_chart;
    }

    protected AttributeDescriptorModel getModel() {
        return this.m_attributeDescriptorModel;
    }

    protected IMBeanService getMBeanService() {
        return (IMBeanService)this.getConnectionHandle().getService(IMBeanService.class);
    }

    protected void initializeSection(Section section) {
    }

    @Override
    public boolean add(AttributeDescriptor attributeDescriptor) {
        return this.notifyListener(this.m_attributeDescriptorModel.add(attributeDescriptor));
    }

    @Override
    public boolean remove(AttributeDescriptor attributeDescriptor) {
        return this.notifyListener(this.m_attributeDescriptorModel.remove(attributeDescriptor));
    }

    @Override
    public void clear() {
        List<AttributeDescriptor> list = this.getAttributeDescriptors();
        Iterator<AttributeDescriptor> it = list.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    @Override
    public Control getControl() {
        return this.getSection();
    }

    @Override
    public List<AttributeDescriptor> getAttributeDescriptors() {
        return this.m_attributeDescriptorModel.getAttributeDescriptors();
    }

    private boolean notifyListener(boolean notify) {
        if (notify) {
            this.m_attributeDescriptorModel.notifyObservers();
        }
        return notify;
    }

    protected void addLoggingAction() {
        final LogToHistoricalDataAction lhda = new LogToHistoricalDataAction(this.getSection().getShell(), this.m_attributeDescriptorModel);
        this.getMCToolBarManager().add((IAction)lhda);
        this.getModel().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                lhda.setChecked(ChartSectionPart.this.m_attributeDescriptorModel.getPersistenceEnabled());
                ChartSectionPart.this.getMCToolBarManager().update();
            }
        });
    }

    protected IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IConnectionHandle) {
            this.m_connectionHandle = (IConnectionHandle)input;
            return true;
        }
        return false;
    }

    public String getComponentTag() {
        return TAG_CHART_SECTION_PART;
    }

    public void exportToXml(Element parentNode) {
        Element chartCompositeNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)chartCompositeNode, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)this.getSectionIdentifier());
        this.getModel().exportToXml(chartCompositeNode);
    }

    public void initializeFromXml(Element node) throws Exception {
        this.setSectionIdentifier(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)"unknown"));
        this.setHelpContextID(this.getSectionIdentifier());
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)this.getModel().getComponentTag());
        if (l.size() > 0) {
            this.getModel().initializeFromXml((Element)l.get(0));
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.equals(AttributeVisualizerBuilder.TITLE)) {
            return this.m_attributeDescriptorModel.getChartModel().getChartTitle();
        }
        if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_Y)) {
            return this.m_attributeDescriptorModel.getChartModel().getYAxis().getTitle();
        }
        if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_X)) {
            return this.m_attributeDescriptorModel.getChartModel().getXAxis().getTitle();
        }
        return null;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (value instanceof String) {
            if (key.equals(AttributeVisualizerBuilder.TITLE)) {
                this.m_attributeDescriptorModel.getChartModel().setChartTitle((String)value);
                this.m_attributeDescriptorModel.getChartModel().notifyObservers();
                return true;
            }
            if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_Y)) {
                this.m_attributeDescriptorModel.getChartModel().getYAxis().setTitle((String)value);
                this.m_attributeDescriptorModel.getChartModel().getYAxis().notifyObservers();
                return true;
            }
            if (key.equals(AttributeVisualizerBuilder.TITLE_AXIS_X)) {
                this.m_attributeDescriptorModel.getChartModel().getXAxis().setTitle((String)value);
                this.m_attributeDescriptorModel.getChartModel().getXAxis().notifyObservers();
                return true;
            }
        } else {
            throw new IllegalArgumentException("Property " + key + " must be of type String");
        }
        return InternalToolkit.unsupportedKey(key);
    }

    static class LogToHistoricalDataAction
    extends Action {
        private final AttributeDescriptorModel m_model;
        private final Shell m_shell;

        public LogToHistoricalDataAction(Shell shell, AttributeDescriptorModel model) {
            super(Messages.ChartSectionPart_LOG_CHECKBOX_TEXT, 2);
            this.m_model = model;
            this.m_shell = shell;
            this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-on-16.gif"));
            this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("persistence-toggle-off-16.gif"));
            this.setToolTipText(Messages.ChartSectionPart_TOOLTIP_TOGGLE_LOGGING_TEXT);
        }

        public void run() {
            try {
                if (this.isChecked()) {
                    this.m_model.startPersistence();
                } else {
                    this.m_model.stopPersistence();
                }
                this.m_model.notifyObservers();
            }
            catch (Exception e1) {
                DialogToolkit.showException(this.m_shell, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_IO_ERROR_MESSAGE, e1);
                DialogToolkit.showError(this.m_shell, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_MULTIPLE_EDITORS_ERROR_MESSAGE);
            }
        }
    }
}

