/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import java.util.Observable;
import java.util.logging.Level;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartModel<T>
extends Observable {
    public static final String XML_TAG_CHART_MODEL = "chartModel";
    public static final String XML_Y_RANGE_SETTING = "yRangeSetting";
    public static final String XML_FROM_RANGE_VALUE = "rangeFromValue";
    public static final String XML_TO_RANGE_VALUE = "rangeToValue";
    public static final String XML_Y_AXIS_TITLE = "yAxisTitle";
    public static final String XML_X_AXIS_TITLE = "xAxisTitle";
    public static final String XML_CHART_TITLE = "chartTitle";
    public static final String DEFAULT_PERCENT_TITLE = "(%)";
    public static final int RANGE_PERCENT = 0;
    public static final int RANGE_AUTO = 1;
    public static final int RANGE_CUSTOM = 2;
    public static final int RANGE_AUTO_ZERO = 3;
    public static final String NO_VALUE = "";
    private final GraphSettingRegistry m_graphSettingsRegistry;
    private final Axis m_xAxis = new Axis();
    private final RangedAxis m_yAxis = new RangedAxis();
    private final TracingDataProvider<T> m_dataProvider;
    private String m_title = "";
    private boolean m_allowNegativeDisplayOffsets;

    public ChartModel(GraphSettingRegistry graphSettingsRegistry, TracingDataProvider<T> provider) {
        this.m_graphSettingsRegistry = graphSettingsRegistry;
        this.m_dataProvider = provider;
    }

    public Axis getXAxis() {
        return this.m_xAxis;
    }

    public RangedAxis getYAxis() {
        return this.m_yAxis;
    }

    public String getComponentTag() {
        return XML_TAG_CHART_MODEL;
    }

    public GraphSettingRegistry getGraphSettingsRegistry() {
        return this.m_graphSettingsRegistry;
    }

    public void setChartTitle(String title) {
        this.m_title = title;
        this.setChanged();
    }

    public String getChartTitle() {
        return this.m_title;
    }

    public void setAllowNegativeDisplayOffsets(boolean alloow) {
        this.m_allowNegativeDisplayOffsets = alloow;
        this.setChanged();
    }

    public boolean getAllowNegativeDisplayOffsets() {
        return this.m_allowNegativeDisplayOffsets;
    }

    public TracingDataProvider<T> getDataProvider() {
        return this.m_dataProvider;
    }

    public void exportChartModelToXml(Element parentNode) {
        String rancho = Integer.toString(this.getYAxis().getRangeType());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_Y_RANGE_SETTING, (String)rancho);
        if (this.getYAxis().getRangeType() == 2) {
            XmlToolkit.setSetting((Element)parentNode, (String)XML_FROM_RANGE_VALUE, (String)String.valueOf(this.getYAxis().getMinValue()));
            XmlToolkit.setSetting((Element)parentNode, (String)XML_TO_RANGE_VALUE, (String)String.valueOf(this.getYAxis().getMaxValue()));
        }
        XmlToolkit.setSetting((Element)parentNode, (String)XML_Y_AXIS_TITLE, (String)this.m_yAxis.getTitle());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_X_AXIS_TITLE, (String)this.m_xAxis.getTitle());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_CHART_TITLE, (String)this.getChartTitle());
        this.getGraphSettingsRegistry().exportToXml(parentNode);
    }

    public void initializeChartModelFromXml(Element node) {
        block4: {
            int yRangeValue = 1;
            try {
                yRangeValue = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_Y_RANGE_SETTING, (String)"0"));
                if (yRangeValue == 2) {
                    this.getYAxis().setMinValue(new Double(XmlToolkit.getSetting((Element)node, (String)XML_FROM_RANGE_VALUE, (String)NO_VALUE)));
                    this.getYAxis().setMaxValue(new Double(XmlToolkit.getSetting((Element)node, (String)XML_TO_RANGE_VALUE, (String)NO_VALUE)));
                }
            }
            catch (NumberFormatException ex) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
                if (yRangeValue != 2) break block4;
                this.getYAxis().setMinValue(new Double(0.0));
                this.getYAxis().setMaxValue(new Double(100.0));
            }
        }
        this.getYAxis().setTitle(XmlToolkit.getSetting((Element)node, (String)XML_Y_AXIS_TITLE, (String)NO_VALUE));
        this.getXAxis().setTitle(XmlToolkit.getSetting((Element)node, (String)XML_X_AXIS_TITLE, (String)NO_VALUE));
        this.setChartTitle(XmlToolkit.getSetting((Element)node, (String)XML_CHART_TITLE, (String)NO_VALUE));
        Element registryNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)this.m_graphSettingsRegistry.getComponentTag());
        if (registryNode != null) {
            this.getGraphSettingsRegistry().initializeFromXml(registryNode);
        }
        this.getXAxis().notifyObservers();
        this.getYAxis().notifyObservers();
        this.notifyObservers();
    }

    public static class Axis
    extends Observable {
        private String m_title = "";

        public String getTitle() {
            return this.m_title;
        }

        public void setTitle(String title) {
            this.m_title = title;
            this.setChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RangedAxis
    extends Axis {
        private int m_rangeType = 0;
        private Number m_minValue;
        private Number m_maxValue;

        public Number getMinValue() {
            return this.m_minValue;
        }

        public Number getMaxValue() {
            return this.m_maxValue;
        }

        public void setMinValue(Number minValue) {
            this.m_minValue = minValue;
            this.setChanged();
        }

        public void setMaxValue(Number maxValue) {
            this.m_maxValue = maxValue;
            this.setChanged();
        }

        public void setRangeType(int rangeType) {
            if (rangeType == this.m_rangeType) {
                return;
            }
            if (this.m_rangeType == 0) {
                this.setTitle(this.removeTrailingPercent(this.getTitle()));
            }
            if (rangeType == 0 && !this.getTitle().endsWith(ChartModel.DEFAULT_PERCENT_TITLE)) {
                this.setTitle(this.addTrailingPercent(this.getTitle()));
            }
            this.m_rangeType = rangeType;
            this.setChanged();
        }

        private String addTrailingPercent(String title) {
            if (title.trim().length() == 0) {
                return ChartModel.DEFAULT_PERCENT_TITLE;
            }
            return String.valueOf(title) + " " + ChartModel.DEFAULT_PERCENT_TITLE;
        }

        private String removeTrailingPercent(String title) {
            if ((title = title.trim()).endsWith(ChartModel.DEFAULT_PERCENT_TITLE)) {
                return title.replace(ChartModel.DEFAULT_PERCENT_TITLE, ChartModel.NO_VALUE).trim();
            }
            return title;
        }

        public int getRangeType() {
            return this.m_rangeType;
        }
    }
}

