/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.accessibility.AccessibilityConstants;
import com.jrockit.mc.core.accessibility.FocusTracker;
import com.jrockit.mc.core.accessibility.MCAccessibleListener;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AntiAliasingListener;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.SwingComponentWrapperCanvas;
import com.jrockit.mc.rjmx.ui.internal.TableToolTipMouseTrackAdapter;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import se.hirt.greychart.ChartChangeEvent;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.GreyChartPanel;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.DefaultTimestampedData;
import se.hirt.greychart.data.DefaultXYData;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.DateXAxis;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultXYLineRenderer;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.EmptyTitleRenderer;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartComposite
extends Composite {
    private static final String Y_AXIS_AUTO_RANGE_TITLE = "";
    private static final String Y_AXIS_AUTO_RANGE_ZERO_TITLE = "";
    private static final String DEFAULT_Y_AXIS_TITLE = "";
    private SwingComponentWrapperCanvas wrapper;
    private TableViewer attributesTableViewer;
    private Button addAttributeButton;
    private Button removeAttributeButton;
    private EndSelectionListener endSelectionListener;
    private ChartSelectionListener startSelectionListener;
    private MenuItem zoomSelectionItem;
    private MenuItem zoomInItem;
    private Menu zoomMenu;
    private AntiAliasingListener antialiasingListener;
    private final AttributeChartModel<ITimestampedData> m_chartModel;
    private final FreezeModel m_freezeModel;
    private final GreyChartPanel m_chartPanel;
    private final ProviderListener redrawListener;
    private final IChartDataToolTipTextProvider m_chartDataToolTipTextProvider;

    public ChartComposite(Composite parent, int style, FormToolkit toolkit, AttributeChartModel<ITimestampedData> model, FreezeModel freezeModel, IChartDataToolTipTextProvider chartDataToolTipTextProvider) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.m_chartModel = model;
        this.m_freezeModel = freezeModel;
        this.redrawListener = new ProviderListener();
        this.m_chartPanel = this.createChartPanel();
        this.setupAntiAliasingListener();
        this.m_chartDataToolTipTextProvider = chartDataToolTipTextProvider;
        this.setupObservers();
        this.setupSelectionListeners();
        this.createClient(this, toolkit);
        this.addMenuItems(new Menu((Control)this.wrapper));
        this.setupAccessibility();
        this.createAttributeTablePopupMenu();
        toolkit.adapt((Composite)this);
        this.setupMouseTracker();
        this.m_chartModel.getDataProvider().addChangeListener(this.redrawListener);
        this.getChart().setDataProvider((DataProvider)this.m_chartModel.getDataProvider());
        this.updateUI();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)ChartComposite.this.antialiasingListener);
            }
        });
    }

    private void setupAntiAliasingListener() {
        this.antialiasingListener = new AntiAliasingListener(this.m_chartPanel.getChart());
        CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.antialiasingListener);
    }

    private void setupAccessibility() {
        FocusTracker.enableFocusTracking((Composite)this.wrapper);
        final MCAccessibleListener accessabilityListener = new MCAccessibleListener();
        accessabilityListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
        this.wrapper.getAccessible().addAccessibleListener((AccessibleListener)accessabilityListener);
        this.m_chartModel.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                accessabilityListener.setName(ChartComposite.this.m_chartModel.getChartTitle());
            }
        });
    }

    private void setupMouseTracker() {
        this.wrapper.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (!ChartComposite.this.getDataProvider().hasData()) {
                    return;
                }
                if (ChartComposite.this.m_chartDataToolTipTextProvider != null && ChartComposite.this.getDataProvider().isTraceActive()) {
                    org.eclipse.swt.graphics.Rectangle clientArea = ChartComposite.this.wrapper.getClientArea();
                    Rectangle plotArea = ChartComposite.this.getChartPanel().getRenderedChartBounds();
                    int topMargin = plotArea.x + clientArea.x;
                    int leftMargin = plotArea.y + clientArea.y;
                    Point mousePoint = new Point(e.x - topMargin, e.y - leftMargin);
                    SamplePoint closestSample = null;
                    DataSeries closestSeries = null;
                    double distance = Double.MAX_VALUE;
                    OptimizingProvider[] optimizingProviderArray = ChartComposite.this.getChart().getOptimizingProvider().getChildren();
                    int n = optimizingProviderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OptimizingProvider provider = optimizingProviderArray[n2];
                        Iterator samples = provider.getSamples(plotArea.width);
                        DefaultYAxis yaxis = ChartComposite.this.getChart().getDescriptor(provider.getDataSeries()).getYAxis();
                        ITimestampedData mouseValue = ChartComposite.this.convertToSampleRange(mousePoint, (YAxis)yaxis);
                        SamplePoint data = ChartComposite.this.getClosestPoint(mouseValue, samples);
                        double newDistance = ChartComposite.this.getSqaredDistance(data, mouseValue);
                        if (closestSample == null || newDistance < distance) {
                            closestSample = data;
                            closestSeries = provider.getDataSeries();
                            distance = newDistance;
                            if (distance == 0.0) break;
                        }
                        ++n2;
                    }
                    ((DefaultXYLineRenderer)ChartComposite.this.getChart().getSeriesPlotRenderer()).circleValue((IXYData)new DefaultXYData((Object)closestSample.x, (Object)ChartComposite.this.getChart().getDescriptor(closestSeries).getYAxis().convertAxisValueToDrawingCoordinate(closestSample.y)));
                    ChartComposite.this.wrapper.setToolTipText(ChartComposite.this.m_chartDataToolTipTextProvider.getToolTipText(ChartComposite.this.getChart().getDescriptor(closestSeries).getName(), closestSample.y, ChartComposite.this.getDataProvider().getAttributeDescriptor(closestSeries)));
                    ChartComposite.this.wrapper.redraw();
                } else {
                    ChartComposite.this.clearCircledValue();
                }
            }

            public void mouseExit(MouseEvent e) {
                ChartComposite.this.clearCircledValue();
            }
        });
    }

    private ITimestampedData convertToSampleRange(Point p, YAxis yaxis) {
        return new DefaultTimestampedData(Long.valueOf(p.x), (Number)yaxis.convertDrawingCoordinateToAxisValue(p.y));
    }

    private void setupSelectionListeners() {
        this.endSelectionListener = new EndSelectionListener();
        this.startSelectionListener = new ChartSelectionListener();
    }

    private GreyChartPanel createChartPanel() {
        DefaultXYGreyChart chart = new DefaultXYGreyChart();
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 10));
        chart.setIndexRenderer(null);
        chart.setAntialiasingEnabled(AntiAliasingListener.isUsingAntialiasing());
        chart.setAutoUpdateOnAxisChange(false);
        chart.setAutoUpdateOnDataChange(false);
        DefaultXYLineRenderer plotRenderer = (DefaultXYLineRenderer)chart.getPlotRenderer();
        plotRenderer.setUseClip(false);
        plotRenderer.setDrawOnXAxis(true);
        plotRenderer.setExtrapolateMissingData(false);
        chart.setXAxis((XAxis)new DateXAxis((GreyChart)chart));
        chart.getXAxis().setTitle(Messages.ChartComposite_X_AXIS_TITLE);
        DefaultYAxis yAxis = new DefaultYAxis((GreyChart)chart);
        yAxis.setTitle("(%)");
        yAxis.setMin((Number)new Integer(0));
        yAxis.setMax((Number)new Integer(100));
        yAxis.setPosition(YAxis.Position.LEFT);
        chart.addYAxis((YAxis)yAxis);
        GreyChartPanel chartPanel = new GreyChartPanel((GreyChart)chart){
            private static final long serialVersionUID = 1L;

            public void onChartChanged(ChartChangeEvent e) {
            }
        };
        return chartPanel;
    }

    public void updateUI() {
        this.updateChartAndTable();
        this.updateXAxis();
        this.updateYAxis();
    }

    private void updateChartAndTable() {
        this.attributesTableViewer.setInput((Object)this.getChartModel().getAttributesInTable());
        this.m_chartModel.getGraphSettingsRegistry().trackMultipliersForAttributes(this.m_chartModel.getAttributesInTable());
        this.updateMultipliersAndPaints();
        this.antialiasingListener.updateAntialiasing();
        this.updateChartTitle();
        this.redraw();
    }

    private void updateXAxis() {
        DateXAxis xAxis = (DateXAxis)this.getChart().getXAxis();
        xAxis.setTitle(this.getChartModel().getXAxis().getTitle());
        this.redraw();
    }

    private void updateYAxis() {
        DefaultYAxis yAxisLeft = this.getFirstLeftAxis();
        yAxisLeft.setTitle(this.getChartModel().getYAxis().getTitle());
        switch (this.getChartModel().getYAxis().getRangeType()) {
            case 1: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case 3: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(true);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case 0: {
                yAxisLeft.setAutoRangeEnabled(false);
                yAxisLeft.setRange((Number)new Double(0.0), (Number)new Double(100.0));
                yAxisLeft.setAutoPadding(0.0);
                break;
            }
            case 2: {
                yAxisLeft.setAutoRangeEnabled(false);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setRange(this.getChartModel().getYAxis().getMinValue(), this.getChartModel().getYAxis().getMaxValue());
                yAxisLeft.setAutoPadding(0.0);
            }
        }
        this.redraw();
    }

    private DefaultYAxis getFirstLeftAxis() {
        YAxis[] yAxis;
        YAxis[] yAxisArray = yAxis = this.getChart().getYAxis();
        int n = yAxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            if (((DefaultYAxis)y).getPosition() == YAxis.Position.LEFT) {
                return (DefaultYAxis)y;
            }
            ++n2;
        }
        return (DefaultYAxis)yAxis[0];
    }

    private void setupObservers() {
        this.getChartModel().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ChartComposite.this.updateChartAndTable();
            }
        });
        this.getChartModel().getXAxis().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ChartComposite.this.updateXAxis();
            }
        });
        this.getChartModel().getYAxis().addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ChartComposite.this.updateYAxis();
            }
        });
        if (this.getFreezeModel() != null) {
            this.getFreezeModel().addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    ChartComposite.this.getDataProvider().setTraceActive(ChartComposite.this.getFreezeModel().isFreezed());
                    if (!ChartComposite.this.getFreezeModel().isFreezed() && !ChartComposite.this.m_chartModel.getAllowNegativeDisplayOffsets()) {
                        ChartComposite.this.zoomToRange(ChartComposite.this.getDataProvider().getDisplayedXRange(), 0L);
                    }
                }
            });
        }
    }

    public AttributeChartModel<ITimestampedData> getChartModel() {
        return this.m_chartModel;
    }

    private FreezeModel getFreezeModel() {
        return this.m_freezeModel;
    }

    protected final TableViewer getTableViewer() {
        return this.attributesTableViewer;
    }

    TracingDataProvider<ITimestampedData> getDataProvider() {
        return this.m_chartModel.getDataProvider();
    }

    private void clearCircledValue() {
        ((DefaultXYLineRenderer)this.getChart().getSeriesPlotRenderer()).circleValue(null);
        this.wrapper.setToolTipText(null);
        this.wrapper.redraw();
    }

    public GreyChartPanel getChartPanel() {
        return this.m_chartPanel;
    }

    public DefaultXYGreyChart<DefaultTimestampedData> getChart() {
        return (DefaultXYGreyChart)this.getChartPanel().getChart();
    }

    public Menu getZoomMenu() {
        return this.zoomMenu;
    }

    private SamplePoint getClosestPoint(ITimestampedData mousePoint, Iterator<SamplePoint> s) {
        SamplePoint result = null;
        double distance = Double.MAX_VALUE;
        Iterator<SamplePoint> iter = s;
        while (iter.hasNext()) {
            SamplePoint data = iter.next();
            double tmpDist = this.getSqaredDistance(data, mousePoint);
            if (!(tmpDist < distance)) continue;
            distance = tmpDist;
            result = data;
        }
        return result;
    }

    private double getSqaredDistance(SamplePoint data, ITimestampedData mousePoint) {
        long xdiff = (long)data.x - (Long)mousePoint.getX();
        double ydiff = data.y - ((Number)mousePoint.getY()).doubleValue();
        return (double)(xdiff * xdiff) + ydiff * ydiff;
    }

    protected void addMenuItems(final Menu popupMenu) {
        this.createZoomMenu(popupMenu);
        this.createRangeMenu(popupMenu);
        this.createTitleMenu(popupMenu);
        MenuItem exportItem = new MenuItem(popupMenu, 0);
        exportItem.setText(Messages.ChartComposite_MENU_ITEM_EXPORT_AS_IMAGE_TEXT);
        exportItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                popupMenu.setVisible(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        String fileName;
                        ImageData swtData = ChartComposite.this.captureComponentImage();
                        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell().getShell(), 8192);
                        dialog.setFilterExtensions(new String[]{"*.png"});
                        while ((fileName = dialog.open()) != null) {
                            File f;
                            if (!fileName.toLowerCase().endsWith(".png")) {
                                fileName = fileName.concat(".png");
                            }
                            if ((f = new File(fileName)).exists() && !MessageDialog.openQuestion((Shell)ChartComposite.this.getShell(), (String)Messages.ChartComposite_DIALOG_FILE_EXISTS_TITLE, (String)NLS.bind((String)Messages.ChartComposite_DIALOG_OVERWRITE_QUESTION_TEXT, (Object)fileName))) continue;
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{swtData};
                            loader.save(fileName, 5);
                            break;
                        }
                    }
                });
            }
        });
    }

    private void createAttributeTablePopupMenu() {
        Menu popupMenu = new Menu((Control)this.getTableViewer().getTable());
        final MenuItem editColorItem = new MenuItem(popupMenu, 0);
        editColorItem.setText(Messages.ChartSectionPart_EDIT_COLOR_TEXT);
        editColorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartComposite.this.attributesTableViewer.getSelection();
                AttributeDescriptor descriptor = (AttributeDescriptor)selection.getFirstElement();
                ChartComposite.this.editColor(descriptor, ChartComposite.this.getGraphSettingsRegistry());
                ChartComposite.this.getGraphSettingsRegistry().commit();
                ChartComposite.this.updateMultipliersAndPaints();
                ChartComposite.this.getTableViewer().refresh();
            }
        });
        editColorItem.setEnabled(false);
        final MenuItem[] editMultiplierItemHolder = new MenuItem[1];
        if (this.getGraphSettingsRegistry().canUpdateMultiplier()) {
            MenuItem editMultiplierItem;
            editMultiplierItemHolder[0] = editMultiplierItem = new MenuItem(popupMenu, 0);
            editMultiplierItem.setText(Messages.ChartSectionPart_EDIT_MULTIPLIER_TEXT);
            editMultiplierItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)ChartComposite.this.getTableViewer().getSelection();
                    AttributeDescriptor descriptor = (AttributeDescriptor)selection.getFirstElement();
                    ChartComposite.this.editMultiplier(descriptor, ChartComposite.this.getGraphSettingsRegistry());
                    ChartComposite.this.getGraphSettingsRegistry().commit();
                    ChartComposite.this.updateMultipliersAndPaints();
                    ChartComposite.this.getTableViewer().refresh();
                }
            });
            editMultiplierItem.setEnabled(false);
        }
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable = ((IStructuredSelection)ChartComposite.this.getTableViewer().getSelection()).size() == 1;
                editColorItem.setEnabled(enable);
                if (editMultiplierItemHolder[0] != null) {
                    editMultiplierItemHolder[0].setEnabled(enable);
                }
            }
        });
        this.attributesTableViewer.getTable().setMenu(popupMenu);
    }

    protected void editMultiplier(AttributeDescriptor descriptor, GraphSettingRegistry manager) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartSectionPart_EDIT_MULTIPLIER_TEXT, Messages.ChartSectionPart_ENTER_MULTIPLIER_VALUE_TEXT, manager.getMultiplier(descriptor).toString(), new IInputValidator(){

            public String isValid(String newText) {
                try {
                    Double.parseDouble(newText);
                    return null;
                }
                catch (NumberFormatException e) {
                    return Messages.ChartSectionPart_MULTIPLIER_MUST_BE_NUMBER_TEXT;
                }
            }
        });
        if (dialog.open() == 0) {
            manager.registerUndoableMultiplierChange(descriptor, new Double(dialog.getValue()));
        }
    }

    protected void editColor(AttributeDescriptor descriptor, GraphSettingRegistry manager) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        Color awtColor = manager.getAWTColor(descriptor);
        RGB rgb = new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        dialog.setRGB(rgb);
        RGB newRGB = dialog.open();
        if (newRGB != null) {
            manager.registerUndoableColorChange(descriptor, new Color(newRGB.red, newRGB.green, newRGB.blue));
        }
    }

    protected void updateMultipliersAndPaints() {
        AttributeDescriptor[] subscriptionAttributes = this.getChartModel().getAttributesInTable();
        int i = 0;
        while (i < subscriptionAttributes.length) {
            this.getDataProvider().setMultiplier(subscriptionAttributes[i], this.getGraphSettingsRegistry().getMultiplier(subscriptionAttributes[i]));
            this.getChart().setDescriptor(this.getDataProvider().getDataSeries(subscriptionAttributes[i]), this.createDescriptor(this.getGraphSettingsRegistry().getAWTColor(subscriptionAttributes[i]), subscriptionAttributes[i]));
            ++i;
        }
    }

    DataSeriesDescriptor createDescriptor(Color color, AttributeDescriptor descriptor) {
        return new DefaultDataSeriesDescriptor().setLineColor(color).setDrawLine(true).setName(descriptor.getAttributeName()).setYAxis(this.getFirstLeftAxis());
    }

    protected Composite createClient(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        container.setLayout((Layout)gLayout);
        this.wrapper = new SwingComponentWrapperCanvas(container, (JComponent)this.getChartPanel());
        this.wrapper.setLayoutData(new GridData(4, 4, true, true));
        this.wrapper.addMouseListener((MouseListener)this.startSelectionListener);
        toolkit.adapt((Composite)this.wrapper);
        Composite indexComposite = toolkit.createComposite(container, 0);
        Table table = toolkit.createTable(indexComposite, 65538);
        this.attributesTableViewer = new TableViewer(table);
        this.attributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((AttributeDescriptor)element).getAttributeName();
            }

            public Image getImage(Object element) {
                if (element instanceof IAttributeInfo) {
                    return ChartComposite.this.m_chartModel.getGraphSettingsRegistry().getColorThumbnail(((IAttributeInfo)element).getAttributeDescriptor());
                }
                return ChartComposite.this.m_chartModel.getGraphSettingsRegistry().getColorThumbnail((AttributeDescriptor)element);
            }
        });
        this.attributesTableViewer.getTable().addMouseTrackListener((MouseTrackListener)new TableToolTipMouseTrackAdapter(this.attributesTableViewer.getTable(), new IToolTipTextProvider(){

            public String getToolTipText(Object obj) {
                return MBeanPropertiesOrderer.getAttributePath((AttributeDescriptor)obj);
            }
        }));
        GridData gd2 = new GridData(4, 4, true, true);
        this.attributesTableViewer.getControl().setLayoutData((Object)gd2);
        Composite buttonComposite = toolkit.createComposite(indexComposite, 32);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)gridLayout);
        this.createButtons(buttonComposite, toolkit);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = Math.max(buttonComposite.computeSize((int)-1, (int)-1).x + 2, 180);
        indexComposite.setLayoutData((Object)gd);
        GridLayout indexLayout = new GridLayout(1, false);
        indexLayout.marginWidth = 2;
        indexLayout.marginHeight = 2;
        indexComposite.setLayout((Layout)indexLayout);
        toolkit.paintBordersFor(container);
        toolkit.paintBordersFor(indexComposite);
        return container;
    }

    protected void createButtons(Composite buttonComposite, FormToolkit toolkit) {
        GridData gd1 = new GridData(4, 4, true, false);
        this.addAttributeButton = toolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_ADD_TEXT, 0);
        this.addAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        this.addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.addButtonPressed();
            }
        });
        this.addAttributeButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.removeAttributeButton = toolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_REMOVE_TEXT, 0);
        this.removeAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("remove-graph-16.png"));
        this.removeAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.removeButtonPressed();
            }
        });
        this.removeAttributeButton.setLayoutData((Object)gd2);
    }

    private void createZoomMenu(Menu popupMenu) {
        MenuItem zoomItem = new MenuItem(popupMenu, 64);
        zoomItem.setText(Messages.ChartComposite_MENU_ZOOM_TEXT);
        this.zoomMenu = new Menu(popupMenu);
        zoomItem.setMenu(this.zoomMenu);
        this.zoomSelectionItem = new MenuItem(this.zoomMenu, 0);
        this.zoomSelectionItem.setText(Messages.ChartComposite_MENU_SELECTION_TEXT);
        this.zoomSelectionItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                double[] selection = ChartComposite.this.getChartPanel().getSelectionPercentages();
                if (selection != null) {
                    ChartComposite.this.getDataProvider().setTraceActive(true);
                    if (ChartComposite.this.getFreezeModel() != null) {
                        ChartComposite.this.getFreezeModel().setFreezed(true);
                    }
                    long range = ChartComposite.this.getDataProvider().getDisplayedXRange();
                    long newRange = (long)((selection[1] - selection[0]) * (double)range);
                    ChartComposite.this.zoomToRange(newRange, ChartComposite.this.getDataProvider().getDisplayOffset() + (long)((1.0 - selection[1]) * (double)range));
                    ChartComposite.this.clearSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.zoomSelectionItem.setEnabled(false);
        MenuItem zoomSecondsItem = new MenuItem(this.zoomMenu, 0);
        zoomSecondsItem.setText(Messages.ChartComposite_MENU_SECONDS_TEXT);
        zoomSecondsItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                long range = 10000L;
                long offset = ChartComposite.this.getCenteredDisplayOffset(ChartComposite.this.getDataProvider().getDisplayedXRange(), range, ChartComposite.this.getDataProvider().getDisplayOffset());
                if (!ChartComposite.this.getChartModel().getAllowNegativeDisplayOffsets()) {
                    offset = 0L;
                }
                ChartComposite.this.zoomToRange(range, offset);
                ChartComposite.this.clearSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem zoomMinutesItem = new MenuItem(this.zoomMenu, 0);
        zoomMinutesItem.setText(Messages.ChartComposite_MENU_MINUTES_TEXT);
        zoomMinutesItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                long range = 600000L;
                long offset = ChartComposite.this.getCenteredDisplayOffset(ChartComposite.this.getDataProvider().getDisplayedXRange(), range, ChartComposite.this.getDataProvider().getDisplayOffset());
                if (!ChartComposite.this.getChartModel().getAllowNegativeDisplayOffsets()) {
                    offset = 0L;
                }
                ChartComposite.this.zoomToRange(range, offset);
                ChartComposite.this.clearSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem zoomHoursItem = new MenuItem(this.zoomMenu, 0);
        zoomHoursItem.setText(Messages.ChartComposite_MENU_HOURS_TEXT);
        zoomHoursItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                long range = 36000000L;
                long offset = ChartComposite.this.getCenteredDisplayOffset(ChartComposite.this.getDataProvider().getDisplayedXRange(), range, ChartComposite.this.getDataProvider().getDisplayOffset());
                if (!ChartComposite.this.getChartModel().getAllowNegativeDisplayOffsets()) {
                    offset = 0L;
                }
                ChartComposite.this.zoomToRange(range, offset);
                ChartComposite.this.clearSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.zoomInItem = new MenuItem(this.zoomMenu, 0);
        this.zoomInItem.setText(Messages.ChartComposite_MENU_ZOOM_IN_TEXT);
        this.zoomInItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.zoomIn();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem zoomOutItem = new MenuItem(this.zoomMenu, 0);
        zoomOutItem.setText(Messages.ChartComposite_MENU_ZOOM_OUT_TEXT);
        zoomOutItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.zoomOut();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.wrapper.setMenu(popupMenu);
    }

    private long getCenteredDisplayOffset(long oldRange, long newRange, long oldDisplayOffset) {
        long rangeDiff = (newRange - oldRange) / 2L;
        return oldDisplayOffset - rangeDiff;
    }

    private void createRangeMenu(Menu popupMenu) {
        MenuItem rangeItem = new MenuItem(popupMenu, 64);
        rangeItem.setText(Messages.ChartComposite_MENU_Y_AXIS_RANGE_TEXT);
        Menu rangeMenu = new Menu(popupMenu);
        rangeItem.setMenu(rangeMenu);
        MenuItem autoRangeItem = new MenuItem(rangeMenu, 0);
        autoRangeItem.setText(Messages.ChartComposite_MENU_AUTO_RANGE_TEXT);
        autoRangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setMinValue(null);
                ChartComposite.this.m_chartModel.getYAxis().setMaxValue(null);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(1);
                if (ChartComposite.this.m_chartModel.getYAxis().getTitle().length() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setTitle("");
                }
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem autoRangeZeroItem = new MenuItem(rangeMenu, 0);
        autoRangeZeroItem.setText(Messages.ChartComposite_MENU_AUTO_RANGE_ZERO_TEXT);
        autoRangeZeroItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setMinValue(null);
                ChartComposite.this.m_chartModel.getYAxis().setMaxValue(null);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(3);
                if (ChartComposite.this.m_chartModel.getYAxis().getTitle().length() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setTitle("");
                }
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem percentRangeItem = new MenuItem(rangeMenu, 0);
        percentRangeItem.setText(Messages.ChartComposite_MENU_PERCENT_TEXT);
        percentRangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(0);
                ChartComposite.this.m_chartModel.getYAxis().setMinValue(null);
                ChartComposite.this.m_chartModel.getYAxis().setMaxValue(null);
                if (ChartComposite.this.m_chartModel.getYAxis().getTitle().length() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setTitle("(%)");
                }
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem customRangeItem = new MenuItem(rangeMenu, 0);
        customRangeItem.setText(Messages.ChartComposite_MENU_CUSTOM_RANGE_TEXT);
        customRangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RangeInputDialog rangeInputDialog = new RangeInputDialog(Display.getCurrent().getActiveShell());
                if (rangeInputDialog.open() == 0) {
                    if (ChartComposite.this.m_chartModel.getYAxis().getTitle().length() == 0) {
                        ChartComposite.this.m_chartModel.getYAxis().setTitle("");
                    }
                    ChartComposite.this.m_chartModel.getYAxis().setRangeType(2);
                    ChartComposite.this.m_chartModel.getYAxis().setMinValue(rangeInputDialog.getFromValue());
                    ChartComposite.this.m_chartModel.getYAxis().setMaxValue(rangeInputDialog.getToValue());
                    ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
                }
            }
        });
    }

    private void createTitleMenu(Menu popupMenu) {
        MenuItem rangeItem = new MenuItem(popupMenu, 64);
        rangeItem.setText(Messages.ChartComposite_MENU_EDIT_TITLES_TEXT);
        Menu rangeMenu = new Menu(popupMenu);
        rangeItem.setMenu(rangeMenu);
        MenuItem graphTitleItem = new MenuItem(rangeMenu, 0);
        graphTitleItem.setText(Messages.ChartComposite_MENU_GRAPH_TITLE_TEXT);
        graphTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String defaultValue = ChartComposite.this.m_chartModel.getChartTitle();
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_GRAPH_TITLE_TITLE, Messages.ChartComposite_INPUT_GRAPH_TITLE_MESSAGE, defaultValue, null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.setChartTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem yAxisTitleItem = new MenuItem(rangeMenu, 0);
        yAxisTitleItem.setText(Messages.ChartComposite_MENU_Y_AXIS_TITLE_TEXT);
        yAxisTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_Y_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_Y_AXIS_TITLE_MESSAGE, ChartComposite.this.getFirstLeftAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem xAxisTitleItem = new MenuItem(rangeMenu, 0);
        xAxisTitleItem.setText(Messages.ChartComposite_MENU_X_AXIS_TITLE_TEXT);
        xAxisTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_X_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_X_AXIS_TITLE_MESSAGE, ChartComposite.this.getChart().getXAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.getXAxis().setTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.getXAxis().notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void addButtonPressed() {
    }

    protected void removeButtonPressed() {
    }

    public void synchronizeZoomWithChart(ChartComposite chart) {
        chart.getChartModel().getDataProvider().setTraceActive(true);
        this.getChartModel().getDataProvider().setTraceActive(true);
        long displayedRange = chart.getChartModel().getDataProvider().getDisplayedXRange();
        long offset = chart.getChartModel().getDataProvider().getDisplayOffset();
        this.zoomToRange(displayedRange, offset);
        if (!chart.getFreezeModel().isFreezed()) {
            chart.getFreezeModel().setFreezed(true);
        }
        if (!this.getFreezeModel().isFreezed()) {
            this.getFreezeModel().setFreezed(true);
        }
        this.redraw();
    }

    protected void zoomToRange(long range, long offset) {
        if (this.getChartModel().getAllowNegativeDisplayOffsets()) {
            this.getDataProvider().setDisplayOffset(offset);
        } else if (offset >= 0L) {
            this.getDataProvider().setDisplayOffset(offset);
        } else {
            this.getDataProvider().setDisplayOffset(0L);
        }
        if (range <= 0L) {
            range = 1L;
            this.zoomInItem.setEnabled(false);
        } else {
            this.zoomInItem.setEnabled(true);
        }
        this.getDataProvider().setDisplayedXRange(range);
        this.redraw();
    }

    public List<AttributeDescriptor> getSelectedAttributes() {
        return ((IStructuredSelection)this.attributesTableViewer.getSelection()).toList();
    }

    public void redraw() {
        this.redrawListener.onDataChange(null);
    }

    public void setXAxisRange(Number start, Number end) {
        ((DateXAxis)this.getChart().getXAxis()).setRange(start, end);
        ((DateXAxis)this.getChart().getXAxis()).setFixedRange(end.longValue() - start.longValue());
    }

    private void clearSelection() {
        this.getChartPanel().clearSelection();
        this.zoomSelectionItem.setEnabled(false);
        this.wrapper.redraw();
        Display.getCurrent().removeFilter(3, (Listener)this.endSelectionListener);
    }

    public ImageData captureComponentImage() {
        Section s = this.findUndisposedSectionParent();
        GC gc = new GC((Drawable)s);
        Point p = s.getSize();
        Image image = new Image((Device)Display.getCurrent(), p.x, p.y);
        org.eclipse.swt.graphics.Rectangle cliprect = gc.getClipping();
        gc.setClipping(cliprect.x, cliprect.y, p.x, p.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    private Section findUndisposedSectionParent() {
        ChartComposite c = this;
        while (!c.isDisposed() && c.getParent() != null) {
            if (c.getParent() instanceof Section) {
                if (c.getParent().isDisposed()) break;
                return (Section)c.getParent();
            }
            c = c.getParent();
        }
        return null;
    }

    private void updateChartTitle() {
        Section sectionParent = this.findUndisposedSectionParent();
        if (sectionParent != null) {
            sectionParent.setText(this.m_chartModel.getChartTitle());
            sectionParent.layout();
            sectionParent.redraw();
        }
    }

    public void zoomIn() {
        long range = this.getDataProvider().getDisplayedXRange();
        this.getDataProvider().setTraceActive(true);
        if (this.getFreezeModel() != null) {
            this.getFreezeModel().setFreezed(true);
        }
        if (range > this.getDataProvider().getMaxX().longValue() - this.getDataProvider().getMinX().longValue()) {
            range = this.getDataProvider().getMaxX().longValue() - this.getDataProvider().getMinX().longValue();
            this.zoomToRange(range, 0L);
        } else {
            this.zoomToRange(range / 2L, this.getCenteredDisplayOffset(range, range / 2L, this.getDataProvider().getDisplayOffset()));
        }
        this.clearSelection();
    }

    public void zoomOut() {
        long range = this.getDataProvider().getDisplayedXRange();
        this.zoomToRange(range * 2L, this.getCenteredDisplayOffset(range, range * 2L, this.getDataProvider().getDisplayOffset()));
        this.clearSelection();
    }

    public GraphSettingRegistry getGraphSettingsRegistry() {
        return this.m_chartModel.getGraphSettingsRegistry();
    }

    class ChartSelectionListener
    extends MouseAdapter {
        private int selectionStart;
        private int selectionEnd;
        Listener mouseTrackListener = new Listener(){

            public void handleEvent(Event event) {
                org.eclipse.swt.graphics.Rectangle bounds = ChartComposite.this.wrapper.getBounds();
                ChartSelectionListener.this.mouseMove(event.x - bounds.x, event.y - bounds.y);
            }
        };

        ChartSelectionListener() {
        }

        public void mouseDown(MouseEvent e) {
            Rectangle selArea;
            if (e.button == 1 && (selArea = ChartComposite.this.getChartPanel().getRenderedChartBounds()) != null && selArea.contains(new java.awt.Point(e.x, e.y))) {
                if (ChartComposite.this.getDataProvider().getDisplayedXRange() > 1L) {
                    ChartComposite.this.zoomSelectionItem.setEnabled(true);
                }
                this.selectionStart = e.x - selArea.x;
                this.selectionEnd = e.x - selArea.x;
                ChartComposite.this.getChartPanel().setSelection(this.selectionStart, this.selectionEnd);
                ChartComposite.this.wrapper.removeMouseListener((MouseListener)this);
                Display.getCurrent().addFilter(5, this.mouseTrackListener);
                Display.getCurrent().addFilter(4, (Listener)ChartComposite.this.endSelectionListener);
            }
        }

        public void mouseMove(int x, int y) {
            Rectangle selArea = ChartComposite.this.getChartPanel().getRenderedChartBounds();
            int selEnd = x - selArea.x;
            this.selectionEnd = selEnd > selArea.width ? selArea.width : (selEnd < 0 ? 0 : selEnd);
            int lowestSel = this.selectionStart < this.selectionEnd ? this.selectionStart : this.selectionEnd;
            int selWidth = Math.abs(this.selectionEnd - this.selectionStart);
            ChartComposite.this.getChartPanel().setSelection(lowestSel, lowestSel + selWidth);
            ChartComposite.this.wrapper.redraw();
        }
    }

    class EndSelectionListener
    implements Listener {
        EndSelectionListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 4 && event.button == 1) {
                ChartComposite.this.wrapper.addMouseListener((MouseListener)ChartComposite.this.startSelectionListener);
                Display.getCurrent().addFilter(3, (Listener)ChartComposite.this.endSelectionListener);
                Display.getCurrent().removeFilter(5, ((ChartComposite)ChartComposite.this).startSelectionListener.mouseTrackListener);
                Display.getCurrent().removeFilter(4, (Listener)this);
            } else if (event.button == 1) {
                ChartComposite.this.clearSelection();
            }
        }
    }

    public static interface IChartDataToolTipTextProvider {
        public String getToolTipText(String var1, Number var2, AttributeDescriptor var3);
    }

    class ProviderListener
    implements DataChangeListener {
        ProviderListener() {
        }

        public void onDataChange(DataChangeEvent event) {
            if (ChartComposite.this.getDataProvider().getNumberOfEntries() > 0) {
                long maxDisplayedByProvider = ChartComposite.this.getDataProvider().getMaxX().longValue() - ChartComposite.this.getDataProvider().getDisplayOffset();
                ChartComposite.this.setXAxisRange(new Long(maxDisplayedByProvider - ChartComposite.this.getDataProvider().getDisplayedXRange()), new Long(maxDisplayedByProvider));
            }
            if (!ChartComposite.this.wrapper.isDisposed()) {
                DisplayToolkit.safeAsyncExec((Display)ChartComposite.this.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (!ChartComposite.this.wrapper.isDisposed()) {
                            ChartComposite.this.wrapper.redraw();
                        }
                    }
                });
            }
        }
    }

    public class RangeInputDialog
    extends Dialog {
        private Button okButton;
        private Text errorMessageText;
        private Text fromText;
        private Text toText;
        private Number fromValue;
        private Number toValue;

        public RangeInputDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_TITLE);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.fromText.setFocus();
            DefaultYAxis yaxis = ChartComposite.this.getFirstLeftAxis();
            if (yaxis.isAutoRangeEnabled()) {
                this.fromText.setText("0");
                this.toText.setText("100");
            } else {
                this.fromText.setText(yaxis.getMin().toString());
                this.toText.setText(yaxis.getMax().toString());
            }
        }

        protected Button getOkButton() {
            return this.okButton;
        }

        protected void validateInput() {
            String errorMessage = null;
            try {
                if (Double.parseDouble(this.fromText.getText()) > Double.parseDouble(this.toText.getText())) {
                    errorMessage = Messages.ChartComposite_DIALOG_RANGE_INPUT_MESSAGE_FROM_SMALLER_THAN_TO;
                }
            }
            catch (NumberFormatException e) {
                errorMessage = Messages.ChartComposite_DIALOG_RANGE_INPUT_MESSAGE_MUST_BE_NUMBERS;
            }
            this.setErrorMessage(errorMessage);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 64);
            label.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_TEXT);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.createCustomArea(composite);
            this.fromText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            this.toText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            this.errorMessageText = new Text(composite, 8);
            this.errorMessageText.setLayoutData((Object)new GridData(768));
            this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
            RangeInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.getOkButton().setEnabled(errorMessage == null);
            this.errorMessageText.getParent().update();
        }

        protected Control createCustomArea(Composite parent) {
            Composite numberFields = new Composite(parent, 0);
            numberFields.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 80;
            Label minimumLabel = new Label(numberFields, 0);
            minimumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MINIMUM_TEXT);
            minimumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.fromText = new Text(numberFields, 2052);
            this.fromText.setLayoutData((Object)gd);
            Label maximumLabel = new Label(numberFields, 0);
            maximumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MAXIMUM_TEXT);
            maximumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.toText = new Text(numberFields, 2052);
            this.toText.setLayoutData((Object)gd);
            return numberFields;
        }

        public Number getFromValue() {
            return this.fromValue;
        }

        public Number getToValue() {
            return this.toValue;
        }

        protected void okPressed() {
            this.fromValue = new Double(Double.parseDouble(this.fromText.getText()));
            this.toValue = new Double(Double.parseDouble(this.toText.getText()));
            super.okPressed();
        }
    }
}

