/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ui.TreeLayout;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.AttributeSubscriptionChart;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import java.awt.Color;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ChartAttributeSelectorDialog
extends AttributeSelectorDialog {
    private AttributeSubscriptionChart m_chart;

    public ChartAttributeSelectorDialog(Shell parentShell, boolean multiSelection, AttributeSubscriptionChart chart) {
        super(parentShell, multiSelection);
        this.m_chart = chart;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        final Tree tree = new Tree(parent, this.getTreeStyle() | 0x10000);
        final TreeViewer viewer = new TreeViewer(tree);
        tree.setHeaderVisible(true);
        TreeLayout layout = new TreeLayout();
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_NAME_COLUMN);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 50, true));
        column = new TreeColumn(tree, 0x1000000);
        column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_MULTIPLIER_COLUMN);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 20, true));
        column = new TreeColumn(tree, 0x1000000);
        column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_COLOR_COLUMN);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 15, true));
        tree.setLayout((Layout)layout);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
        viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(viewer, this.m_chart.getGraphSettingsRegistry()));
        final TreeEditor editor = new TreeEditor(tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = tree.getItem(new Point(e.x, e.y))) == null || !(item.getData() instanceof IAttributeInfo)) {
                    return;
                }
                int columnNum = 0;
                if (item.getBounds(1).contains(e.x, e.y)) {
                    columnNum = 1;
                } else if (item.getBounds(2).contains(e.x, e.y)) {
                    columnNum = 2;
                } else {
                    return;
                }
                final Button newEditor = new Button((Composite)tree, 0);
                final int editedColumn = columnNum;
                newEditor.setText(Messages.ChartSectionPart_EDIT_TEXT);
                newEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IAttributeInfo info = (IAttributeInfo)item.getData();
                        if (editedColumn == 1) {
                            ChartAttributeSelectorDialog.this.editMultiplier(info.getAttributeDescriptor(), ChartAttributeSelectorDialog.this.m_chart.getGraphSettingsRegistry());
                        } else {
                            ChartAttributeSelectorDialog.this.editColor(info.getAttributeDescriptor(), ChartAttributeSelectorDialog.this.m_chart.getGraphSettingsRegistry());
                        }
                        newEditor.dispose();
                        viewer.refresh();
                    }
                });
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, columnNum);
            }
        });
        return viewer;
    }

    protected void okPressed() {
        this.m_chart.getGraphSettingsRegistry().commit();
        this.updateMultipliersAndPaints();
        super.okPressed();
    }

    protected void updateMultipliersAndPaints() {
        AttributeDescriptor[] subscriptionAttributes = this.m_chart.getChartModel().getAttributesInTable();
        Color[] paints = new Color[subscriptionAttributes.length];
        int i = 0;
        while (i < subscriptionAttributes.length) {
            this.m_chart.getDataProvider().setMultiplier(subscriptionAttributes[i], this.m_chart.getGraphSettingsRegistry().getMultiplier(subscriptionAttributes[i]));
            this.m_chart.getChart().setDescriptor(((AttributeXYDataProvider)this.m_chart.getDataProvider()).getDataSeries(subscriptionAttributes[i]), this.m_chart.createDescriptor(this.m_chart.getGraphSettingsRegistry().getAWTColor(subscriptionAttributes[i]), subscriptionAttributes[i]));
            ++i;
        }
    }

    protected void editMultiplier(AttributeDescriptor descriptor, GraphSettingRegistry manager) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartSectionPart_EDIT_MULTIPLIER_TEXT, Messages.ChartSectionPart_ENTER_MULTIPLIER_VALUE_TEXT, manager.getMultiplier(descriptor).toString(), new IInputValidator(){

            public String isValid(String newText) {
                try {
                    Double.parseDouble(newText);
                    return null;
                }
                catch (NumberFormatException e) {
                    return Messages.ChartSectionPart_MULTIPLIER_MUST_BE_NUMBER_TEXT;
                }
            }
        });
        if (dialog.open() == 0) {
            manager.registerUndoableMultiplierChange(descriptor, new Double(dialog.getValue()));
        }
    }

    protected void editColor(AttributeDescriptor descriptor, GraphSettingRegistry manager) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        Color awtColor = manager.getAWTColor(descriptor);
        RGB rgb = new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        dialog.setRGB(rgb);
        RGB newRGB = dialog.open();
        if (newRGB != null) {
            manager.registerUndoableColorChange(descriptor, new Color(newRGB.red, newRGB.green, newRGB.blue));
        }
    }
}

