/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeValueListener;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeExceptionEvent;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.subscription.storage.internal.BufferingAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.EventWrapper;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.ResolvingEventList;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import se.hirt.greychart.data.AbstractDataSeries;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.TimestampedDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeXYDataProvider
extends TimestampedDataProvider
implements TracingDataProvider<ITimestampedData> {
    private static final Number NULL_VALUE_REPRESENTATION = new Double(0.0);
    private IMBeanService mbeanService;
    private final ArrayList<DataChangeListener> dataChangeListeners = new ArrayList();
    private final Map<AttributeDescriptor, String> seriesNames = new HashMap<AttributeDescriptor, String>();
    private final Map<AttributeDescriptor, ResolvingEventList> dataLists = new HashMap<AttributeDescriptor, ResolvingEventList>();
    private final Map<AttributeDescriptor, Range> yRangeMap = new HashMap<AttributeDescriptor, Range>();
    private final Map<AttributeDescriptor, Range> xRangeMap = new HashMap<AttributeDescriptor, Range>();
    private final Map<AttributeDescriptor, Double> multipliers = new HashMap<AttributeDescriptor, Double>();
    private final Map<AttributeDescriptor, DataSeries<ITimestampedData>> attributeToSeriesMap = new LinkedHashMap<AttributeDescriptor, DataSeries<ITimestampedData>>();
    private Long totalMaxX;
    private Long totalMinX;
    private Range totalYRange = new Range();
    private boolean traceActive;
    private long displayedXRange;
    private long displayOffset;
    private SubscriptionListener minMaxUpdater = new SubscriptionListener();
    private final DataChangeEvent eventStructureChange;
    private final DataChangeEvent eventDataAdded;

    public AttributeXYDataProvider(IMBeanService mbeanService) {
        this.mbeanService = mbeanService;
        this.eventStructureChange = new DataChangeEvent((DataProvider)this, DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED);
        this.eventDataAdded = new DataChangeEvent((DataProvider)this, DataChangeEvent.ChangeType.TYPE_DATA_ADDED);
    }

    private void notifyDataChangeListeners(DataChangeEvent event) {
        Iterator<DataChangeListener> iter = this.dataChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().onDataChange(event);
        }
    }

    public void addSubscriptionAttributes(AttributeDescriptor[] addedSubscriptionsAttributes, GraphSettingRegistry graphSettingRegistry) {
        IConnectionHandle connectionHandle = this.mbeanService.getConnectionHandle();
        ISubscriptionService attributeSubscriptionService = this.mbeanService.getAttributeSubscriptionService();
        IAttributeStorageService attributeStorageService = (IAttributeStorageService)connectionHandle.getService(IAttributeStorageService.class);
        AttributeDescriptor[] attributeDescriptorArray = addedSubscriptionsAttributes;
        int n = addedSubscriptionsAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor descriptor = attributeDescriptorArray[n2];
            if (!this.attributeToSeriesMap.keySet().contains(descriptor)) {
                if (attributeStorageService.getAttributeStorage(descriptor) == null) {
                    attributeStorageService.setAttributeStorage(descriptor, (IAttributeStorage)new BufferingAttributeStorage());
                }
                DataSeries<ITimestampedData> newSeries = this.createNewDataSeries(descriptor);
                this.attributeToSeriesMap.put(descriptor, newSeries);
                this.addDataSeries(newSeries);
                int updateTime = UpdatePolicyToolkit.getUpdateTime((IConnectionHandle)connectionHandle, (AttributeDescriptor)descriptor);
                String displayName = AttributeInfoToolkit.getDisplayName((IConnectionHandle)connectionHandle, (AttributeDescriptor)descriptor);
                this.dataLists.put(descriptor, new ResolvingEventList(this.getDisplayedXRange() + (long)(updateTime * 2)));
                this.multipliers.put(descriptor, graphSettingRegistry.getMultiplier(descriptor));
                this.seriesNames.put(descriptor, displayName);
                attributeSubscriptionService.addAttributeValueListener(descriptor, (IAttributeValueListener)this.minMaxUpdater);
                this.updateXRange(descriptor);
            }
            ++n2;
        }
        if (this.totalMaxX == null) {
            IMBeanHelperService service = (IMBeanHelperService)connectionHandle.getService(IMBeanHelperService.class);
            this.totalMaxX = new Long(service.getApproximateServerTime(System.currentTimeMillis()));
            this.totalMinX = new Long(this.totalMaxX - this.getDisplayedXRange());
        }
        this.initData();
        this.calculateTotalMinMax();
        this.notifyDataChangeListeners(this.eventStructureChange);
    }

    private DataSeries<ITimestampedData> createNewDataSeries(AttributeDescriptor attributeDescriptor) {
        return new SpecialDataSeries(attributeDescriptor);
    }

    @Override
    public void setMultiplier(AttributeDescriptor descriptor, Double multiplier) {
        Double oldMultiplier = this.getMultiplier(descriptor);
        if (multiplier == null || !multiplier.equals(oldMultiplier)) {
            this.multipliers.put(descriptor, multiplier);
            this.calculateTotalMinMax();
        }
    }

    private Double getMultiplier(AttributeDescriptor descriptor) {
        Double multiplier = this.multipliers.get(descriptor);
        return multiplier;
    }

    private void updateDataList(AttributeDescriptor subscriptionAttribute, Range yRange) {
        int margin = UpdatePolicyToolkit.getUpdateTime((IConnectionHandle)this.mbeanService.getConnectionHandle(), (AttributeDescriptor)subscriptionAttribute) * 2;
        ResolvingEventList list = new ResolvingEventList(this.getDisplayedXRange() + (long)(margin * 2));
        this.dataLists.put(subscriptionAttribute, list);
        IAttributeStorageService attributeStorageService = (IAttributeStorageService)this.mbeanService.getConnectionHandle().getService(IAttributeStorageService.class);
        IAttributeStorage storage = attributeStorageService.getAttributeStorage(subscriptionAttribute);
        if (storage != null && !storage.isEmpty()) {
            long endTime = this.getMaxX().longValue() - this.getDisplayOffset();
            for (AttributeValueEvent event : storage.getAttributeValueEvents(endTime - this.getDisplayedXRange() - (long)margin, endTime + (long)margin, yRange)) {
                list.add(EventWrapper.create(event, this.getMultiplier(subscriptionAttribute)));
            }
        }
    }

    public void removeSubscriptionAttributes(AttributeDescriptor[] removedSubscriptionAttributes) {
        AttributeDescriptor[] attributeDescriptorArray = removedSubscriptionAttributes;
        int n = removedSubscriptionAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor descriptor = attributeDescriptorArray[n2];
            this.dataLists.remove(descriptor);
            this.multipliers.remove(descriptor);
            this.seriesNames.remove(descriptor);
            this.yRangeMap.remove(descriptor);
            this.xRangeMap.remove(descriptor);
            this.removeDataSeries(this.getDataSeries(descriptor));
            this.attributeToSeriesMap.remove(descriptor);
            ++n2;
        }
        this.initData();
        this.calculateTotalMinMax();
        this.notifyDataChangeListeners(this.eventStructureChange);
    }

    private void calculateTotalXRange() {
        for (AttributeDescriptor descriptor : this.attributeToSeriesMap.keySet()) {
            this.updateXRange(descriptor);
        }
        long minX = Long.MAX_VALUE;
        long maxX = Long.MIN_VALUE;
        if (this.xRangeMap.values().isEmpty()) {
            IMBeanHelperService service = (IMBeanHelperService)this.mbeanService.getConnectionHandle().getService(IMBeanHelperService.class);
            maxX = service.getApproximateServerTime(System.currentTimeMillis());
            minX = maxX - this.getDisplayedXRange();
        } else {
            for (Range r : this.xRangeMap.values()) {
                minX = Math.min(r.getMinValue().longValue(), minX);
                maxX = Math.max(r.getMaxValue().longValue(), maxX);
            }
        }
        this.totalMaxX = new Long(maxX);
        this.totalMinX = new Long(minX);
    }

    private void calculateTotalMinMax() {
        this.calculateTotalXRange();
        this.totalYRange = new Range();
        for (AttributeDescriptor descriptor : this.attributeToSeriesMap.keySet()) {
            Range yRange = this.getYRange(descriptor);
            double multiplier = this.getMultiplier(descriptor);
            if (!yRange.isValid()) continue;
            this.totalYRange.update((Number)new Double(yRange.getMinValue().doubleValue() * multiplier));
            this.totalYRange.update((Number)new Double(yRange.getMaxValue().doubleValue() * multiplier));
        }
    }

    @Override
    public Number getMaxX() {
        return this.totalMaxX;
    }

    public Number getMaxY() {
        return this.totalYRange.getMaxValue();
    }

    @Override
    public Number getMinX() {
        long minValue = this.getMaxX().longValue() - (this.getDisplayedXRange() + this.getDisplayOffset());
        if (this.totalMinX < minValue) {
            minValue = this.totalMinX;
        }
        return new Long(minValue);
    }

    public Number getMinY() {
        return this.totalYRange.getMinValue();
    }

    private void updateYRange(AttributeValueEvent e) {
        if (e.getValue() == null) {
            return;
        }
        double multiplier = this.getMultiplier(e.getSubscriptionAttribute());
        double mulValue = ((Number)e.getValue()).doubleValue() * multiplier;
        this.getYRange(e.getSubscriptionAttribute()).update((Number)new Double(mulValue));
        this.totalYRange.update((Number)new Double(mulValue));
    }

    private void updateXRange(AttributeDescriptor attribute) {
        IAttributeStorageService attributeStorageService = (IAttributeStorageService)this.mbeanService.getConnectionHandle().getService(IAttributeStorageService.class);
        IAttributeStorage storage = null;
        if (attributeStorageService != null) {
            storage = attributeStorageService.getAttributeStorage(attribute);
        }
        if (storage == null || storage.isEmpty()) {
            return;
        }
        Range r = this.xRangeMap.get(attribute);
        if (r == null) {
            r = new Range((Number)storage.getFirstTimestamp(), (Number)storage.getLastTimestamp());
            this.xRangeMap.put(attribute, r);
        }
        r.setMinValue((Number)storage.getFirstTimestamp());
        r.setMaxValue((Number)storage.getLastTimestamp());
        if (this.totalMinX == null || r.getMinValue().longValue() < this.totalMinX) {
            this.totalMinX = r.getMinValue().longValue();
        }
        if (this.totalMaxX == null || r.getMaxValue().longValue() > this.totalMaxX) {
            this.totalMaxX = r.getMaxValue().longValue();
        }
    }

    public int getSeriesValueCount(AttributeDescriptor series) {
        return this.dataLists.get(series).size();
    }

    public Number getXValue(int series, int index) {
        AttributeValueEvent event = (AttributeValueEvent)this.dataLists.get(series).get(index);
        return new Long(event.getTimestamp());
    }

    public Number getYValue(int series, int index) {
        AttributeValueEvent event = (AttributeValueEvent)this.dataLists.get(series).get(index);
        Number yValue = (Number)event.getValue();
        if (yValue == null) {
            yValue = NULL_VALUE_REPRESENTATION;
        }
        return new Double(yValue.doubleValue() * this.multipliers.get(series));
    }

    public int getSeriesCount() {
        return this.attributeToSeriesMap.keySet().size();
    }

    public String[] getSeriesNames() {
        return this.seriesNames.values().toArray(new String[this.seriesNames.size()]);
    }

    public void addChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.add(listener);
    }

    @Override
    public int getNumberOfEntries() {
        int size = 0;
        for (AttributeDescriptor descriptor : this.dataLists.keySet()) {
            size += this.getSeriesValueCount(descriptor);
        }
        return size;
    }

    public void removeChangeListener(DataChangeListener listener) {
        this.dataChangeListeners.remove(listener);
    }

    private Range getYRange(AttributeDescriptor subscriptionAttribute) {
        Range yRange = this.yRangeMap.get(subscriptionAttribute);
        if (yRange == null) {
            yRange = new Range();
            this.yRangeMap.put(subscriptionAttribute, yRange);
        }
        return yRange;
    }

    private void initData() {
        this.calculateTotalXRange();
        for (AttributeDescriptor descriptor : this.dataLists.keySet()) {
            Range yRange = this.getYRange(descriptor);
            yRange.clear();
            this.updateDataList(descriptor, yRange);
        }
        this.calculateTotalMinMax();
        this.notifyDataChangeListeners(this.eventDataAdded);
    }

    @Override
    public boolean isTraceActive() {
        return this.traceActive;
    }

    @Override
    public void setTraceActive(boolean active) {
        this.traceActive = active;
        if (!this.isTraceActive()) {
            this.setDisplayOffset(0L);
            this.setDisplayedXRange(this.getDisplayedXRange());
        }
    }

    @Override
    public long getDisplayedXRange() {
        return this.displayedXRange;
    }

    @Override
    public void setDisplayedXRange(long range) {
        this.displayedXRange = range;
        this.initData();
    }

    @Override
    public long getDisplayOffset() {
        return this.displayOffset;
    }

    @Override
    public void setDisplayOffset(long offset) {
        this.displayOffset = offset;
    }

    public AttributeDescriptor[] getSubscriptionAttributes() {
        return this.attributeToSeriesMap.keySet().toArray(new AttributeDescriptor[this.attributeToSeriesMap.keySet().size()]);
    }

    @Override
    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.getSubscriptionAttributes();
    }

    @Override
    public AttributeDescriptor getAttributeDescriptor(DataSeries s) {
        for (AttributeDescriptor descriptor : this.attributeToSeriesMap.keySet()) {
            if (this.attributeToSeriesMap.get(descriptor) != s) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public DataSeries getDataSeries(AttributeDescriptor descriptor) {
        return this.attributeToSeriesMap.get(descriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SpecialDataSeries
    extends AbstractDataSeries<ITimestampedData> {
        private AttributeDescriptor descriptor;

        private SpecialDataSeries(AttributeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Iterator<ITimestampedData> createIterator(long min, long max) {
            return ((ResolvingEventList)AttributeXYDataProvider.this.dataLists.get(this.descriptor)).iterator();
        }

        public boolean hasData() {
            return AttributeXYDataProvider.this.dataLists.get(this.descriptor) != null && !((ResolvingEventList)AttributeXYDataProvider.this.dataLists.get(this.descriptor)).isEmpty();
        }
    }

    private class SubscriptionListener
    implements IAttributeValueListener {
        private SubscriptionListener() {
        }

        public void valueChanged(AttributeValueEvent event) {
            List dataList;
            if (event instanceof AttributeExceptionEvent || event.getValue() == null) {
                return;
            }
            if (AttributeXYDataProvider.this.isTraceActive()) {
                long oldMax = AttributeXYDataProvider.this.getMaxX().longValue();
                AttributeXYDataProvider.this.calculateTotalXRange();
                AttributeXYDataProvider.this.setDisplayOffset(AttributeXYDataProvider.this.getMaxX().longValue() - oldMax + AttributeXYDataProvider.this.getDisplayOffset());
            }
            if ((dataList = (List)AttributeXYDataProvider.this.dataLists.get(event.getSubscriptionAttribute())) != null) {
                AttributeXYDataProvider.this.updateXRange(event.getSubscriptionAttribute());
                if (dataList.size() == 0 || event.getTimestamp() > (Long)((ITimestampedData)dataList.get(dataList.size() - 1)).getX()) {
                    AttributeXYDataProvider.this.updateYRange(event);
                    dataList.add(EventWrapper.create(event, AttributeXYDataProvider.this.getMultiplier(event.getSubscriptionAttribute())));
                }
            }
            AttributeXYDataProvider.this.notifyDataChangeListeners(AttributeXYDataProvider.this.eventDataAdded);
        }
    }
}

