/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.ui.TreeLayout;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.ui.internal.AbstractAttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.misc.DialogToolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AttributeSubscriptionChart
extends ChartComposite {
    private MenuItem logToHistoricalDataItem;
    private IMBeanService mbeanService;
    private AttributeDescriptorModel attributeDescriptorModel;
    private Observer observer;
    private AttributeDescriptorModel.ISubscriptionFailListener failListener;

    public AttributeSubscriptionChart(Composite parent, int style, FormToolkit toolkit, AttributeDescriptorModel model, IMBeanService mbeanService, FreezeModel freezeModel) {
        super(parent, style, toolkit, model.getChartModel(), freezeModel, new ChartComposite.IChartDataToolTipTextProvider(mbeanService){
            private AttributeDescriptorToolTipTextProvider toolTipTextProvider;
            {
                this.toolTipTextProvider = new AttributeDescriptorToolTipTextProvider(iMBeanService);
            }

            public String getToolTipText(String seriesName, Number value, AttributeDescriptor attribute) {
                return this.toolTipTextProvider.getAttributeDescriptorToolTipText(attribute, value);
            }
        });
        this.mbeanService = mbeanService;
        this.attributeDescriptorModel = model;
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new AbstractAttributeLabelProvider(this.getTableViewer().getTable(), mbeanService.getConnectionHandle()){

            public String getColumnText(Object element, int columnIndex) {
                return AttributeInfoToolkit.getDisplayName((IConnectionHandle)this.getConnectionHandle(), (AttributeDescriptor)((AttributeDescriptor)element));
            }

            public Image getColumnImage(Object element, int columnIndex) {
                AttributeDescriptor descriptor = (AttributeDescriptor)element;
                if (this.getAttributeSubscriptionService().isAttributeUnavailable(descriptor)) {
                    return GraphSettingRegistry.getGreyedOutColorThumbnail();
                }
                return AttributeSubscriptionChart.this.getGraphSettingsRegistry().getColorThumbnail(descriptor);
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.observer = new Observer(){

            public void update(Observable o, Object arg) {
                AttributeSubscriptionChart.this.logToHistoricalDataItem.setSelection(AttributeSubscriptionChart.this.attributeDescriptorModel.getPersistenceEnabled());
            }
        };
        this.attributeDescriptorModel.addObserver(this.observer);
        this.failListener = new AttributeDescriptorModel.ISubscriptionFailListener(){

            public void onSubscriptionFailed() {
                DisplayToolkit.safeAsyncExec((Widget)AttributeSubscriptionChart.this.getTableViewer().getTable(), (Runnable)new Runnable(){

                    public void run() {
                        AttributeSubscriptionChart.this.getTableViewer().refresh();
                    }
                });
            }
        };
        this.attributeDescriptorModel.addSubscriptionFailListener(this.failListener);
    }

    public void addMenuItems(Menu popupMenu) {
        super.addMenuItems(popupMenu);
        this.logToHistoricalDataItem = new MenuItem(popupMenu, 32);
        this.logToHistoricalDataItem.setText(Messages.AttributeSubscriptionChart_MENU_ITEM_LOG_TO_HISTORICAL_DATA_TEXT);
        this.logToHistoricalDataItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (AttributeSubscriptionChart.this.logToHistoricalDataItem.getEnabled()) {
                        if (AttributeSubscriptionChart.this.logToHistoricalDataItem.getSelection()) {
                            AttributeSubscriptionChart.this.attributeDescriptorModel.startPersistence();
                        } else {
                            AttributeSubscriptionChart.this.attributeDescriptorModel.stopPersistence();
                        }
                        AttributeSubscriptionChart.this.attributeDescriptorModel.notifyObservers();
                    }
                }
                catch (Exception e1) {
                    DialogToolkit.showException(AttributeSubscriptionChart.this.getShell(), Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_IO_ERROR_MESSAGE, e1);
                    DialogToolkit.showError(AttributeSubscriptionChart.this.getShell(), Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_MULTIPLE_EDITORS_ERROR_MESSAGE);
                }
            }
        });
    }

    protected void addButtonPressed() {
        AttributeSelectorDialog dialog = new AttributeSelectorDialog(null, true){

            protected TreeViewer createTreeViewer(Composite parent) {
                final Tree tree = new Tree(parent, this.getTreeStyle() | 0x10000);
                final TreeViewer viewer = new TreeViewer(tree);
                tree.setHeaderVisible(true);
                TreeLayout layout = new TreeLayout();
                TreeColumn column = new TreeColumn(tree, 16384);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_NAME_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 50, true));
                column = new TreeColumn(tree, 0x1000000);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_MULTIPLIER_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 20, true));
                column = new TreeColumn(tree, 0x1000000);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_COLOR_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 15, true));
                tree.setLayout((Layout)layout);
                viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
                viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(viewer, AttributeSubscriptionChart.this.getGraphSettingsRegistry()));
                final TreeEditor editor = new TreeEditor(tree);
                editor.horizontalAlignment = 16384;
                editor.grabHorizontal = true;
                editor.minimumWidth = 50;
                tree.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TreeItem item;
                        Control oldEditor = editor.getEditor();
                        if (oldEditor != null) {
                            oldEditor.dispose();
                        }
                        if ((item = tree.getItem(new Point(e.x, e.y))) == null || !(item.getData() instanceof IAttributeInfo)) {
                            return;
                        }
                        int columnNum = 0;
                        if (item.getBounds(1).contains(e.x, e.y)) {
                            columnNum = 1;
                        } else if (item.getBounds(2).contains(e.x, e.y)) {
                            columnNum = 2;
                        } else {
                            return;
                        }
                        final Button newEditor = new Button((Composite)tree, 0);
                        final int editedColumn = columnNum;
                        newEditor.setText(Messages.ChartSectionPart_EDIT_TEXT);
                        newEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                IAttributeInfo info = (IAttributeInfo)item.getData();
                                if (editedColumn == 1) {
                                    AttributeSubscriptionChart.this.editMultiplier(info.getAttributeDescriptor(), AttributeSubscriptionChart.this.getGraphSettingsRegistry());
                                } else {
                                    AttributeSubscriptionChart.this.editColor(info.getAttributeDescriptor(), AttributeSubscriptionChart.this.getGraphSettingsRegistry());
                                }
                                newEditor.dispose();
                                viewer.refresh();
                            }
                        });
                        newEditor.setFocus();
                        editor.setEditor((Control)newEditor, item, columnNum);
                    }
                });
                return viewer;
            }

            protected void okPressed() {
                AttributeSubscriptionChart.this.getGraphSettingsRegistry().commit();
                AttributeSubscriptionChart.this.updateMultipliersAndPaints();
                super.okPressed();
            }
        };
        AttributeDescriptor[] selectedAttributes = dialog.show(this.getMBeanService(), new AttributeDescriptor[0], this.attributeDescriptorModel.createAttributeDescriptorArray(), true);
        this.getGraphSettingsRegistry().rollback();
        if (selectedAttributes != null && selectedAttributes.length > 0) {
            IAttributeInfoService attributeInfoService = this.getMBeanService().getAttributeInfoService();
            ArrayList addList = new ArrayList(Arrays.asList(selectedAttributes));
            int i = 0;
            while (i < addList.size()) {
                Object object = addList.get(i);
                IAttributeInfo info = object instanceof IAttributeInfo ? (IAttributeInfo)object : attributeInfoService.getAttributeInfo((AttributeDescriptor)object);
                if (info.isNumerical()) {
                    this.attributeDescriptorModel.add(info.getAttributeDescriptor());
                } else if (info.isComposite()) {
                    IAttributeInfo[] children = AttributeInfoToolkit.getCompositeChildren((IConnectionHandle)this.getMBeanService().getConnectionHandle(), (IAttributeInfo)info);
                    addList.addAll(Arrays.asList(children));
                }
                ++i;
            }
            if (this.attributeDescriptorModel.hasChanged()) {
                this.attributeDescriptorModel.notifyObservers();
            }
        }
    }

    private IMBeanService getMBeanService() {
        return this.mbeanService;
    }

    protected void removeButtonPressed() {
        this.attributeDescriptorModel.removeAll(this.getSelectedAttributes());
        this.attributeDescriptorModel.notifyObservers();
    }
}

