/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.ui.fields.FilterMatcher;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class AttributeSelectorDialog
extends TitleAreaDialog {
    private TreeViewer mbeanTreeViewer;
    private MBeanTreeRefreshJob mbeanTreeRefreshJob;
    private ArrayList<Object> selectedAttributes;
    private boolean multiSelectionAllowed;
    private String filterText;

    public AttributeSelectorDialog(Shell parentShell, boolean multiSelection) {
        super(parentShell);
        this.multiSelectionAllowed = multiSelection;
        this.setTitleImage(RJMXUIPlugin.getDefault().getImage("attribute-browser-wiz.gif"));
        this.selectedAttributes = new ArrayList();
    }

    public AttributeDescriptor[] show(IMBeanService mbeanService, AttributeDescriptor[] selected, AttributeDescriptor[] expanded, boolean showNumericalsOnly) {
        IAttributeInfo[] result = this.show(mbeanService, this.getAttibuteInfosFromAttributeDescriptors(mbeanService, selected), this.getAttibuteInfosFromAttributeDescriptors(mbeanService, expanded), showNumericalsOnly);
        if (result != null) {
            AttributeDescriptor[] selectedDescriptors = new AttributeDescriptor[result.length];
            int i = 0;
            while (i < result.length) {
                selectedDescriptors[i] = result[i].getAttributeDescriptor();
                ++i;
            }
            return selectedDescriptors;
        }
        return null;
    }

    private IAttributeInfo[] getAttibuteInfosFromAttributeDescriptors(IMBeanService mbeanService, AttributeDescriptor[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            return new IAttributeInfo[0];
        }
        IAttributeInfoService attributeInfoService = (IAttributeInfoService)mbeanService.getAdapter(IAttributeInfoService.class);
        IAttributeInfo[] infos = new IAttributeInfo[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            infos[i] = attributeInfoService.getAttributeInfo(descriptors[i]);
            ++i;
        }
        return infos;
    }

    private IAttributeInfo[] show(IMBeanService mbeanService, IAttributeInfo[] selected, IAttributeInfo[] expanded, boolean showNumericalsOnly) {
        IConnectionHandle connectionHandle = (IConnectionHandle)mbeanService.getAdapter(IConnectionHandle.class);
        if (connectionHandle.isConnected()) {
            this.create();
            this.getButton(0).setEnabled(false);
            this.mbeanTreeViewer.addFilter((ViewerFilter)new AttributeTreeFilter(showNumericalsOnly));
            this.mbeanTreeViewer.setInput((Object)mbeanService);
            this.expandNodes(expanded);
            this.expandNodes(selected);
            this.selectNodes(selected);
            DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
            if (this.open() == 0) {
                return this.selectedAttributes.toArray(new IAttributeInfo[this.selectedAttributes.size()]);
            }
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.AttributeSelectorDialog_SELECT_ATTRIOBUTE_DIALOG_TITLE);
        Control contents = super.createContents(parent);
        contents.getShell().setSize(620, 500);
        contents.getShell().setImage(RJMXUIPlugin.getDefault().getImage("non-numerical-attribute-16.png"));
        this.setMessage(Messages.AttributeSelectorDialog_MESSAGE);
        this.setTitle(Messages.AttributeSelectorDialog_TEXT);
        return contents;
    }

    protected int getTreeStyle() {
        int style = 2048;
        style = this.multiSelectionAllowed ? (style |= 2) : (style |= 4);
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, this.getTreeStyle());
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(viewer));
        return viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        Composite filterAreaComposite = new Composite(dialogArea, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterAreaComposite.setLayout((Layout)filterLayout);
        filterAreaComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label filterLabel = new Label(filterAreaComposite, 0);
        filterLabel.setText(Messages.AttributeSelectorDialog_LABEL_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text filterText = new Text(filterAreaComposite, 2048);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!filterText.isDisposed()) {
                    AttributeSelectorDialog.this.setFilterText(filterText.getText());
                }
            }
        });
        this.mbeanTreeViewer = this.createTreeViewer(dialogArea);
        this.mbeanTreeViewer.setUseHashlookup(true);
        this.mbeanTreeRefreshJob = new MBeanTreeRefreshJob(this.mbeanTreeViewer);
        this.mbeanTreeViewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        this.mbeanTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttributeSelectorDialog.this.selectedAttributes.clear();
                Iterator iter = ((IStructuredSelection)event.getSelection()).iterator();
                while (iter.hasNext()) {
                    Object selectedElement = ((ITreeNode)iter.next()).getUserData();
                    if (!(selectedElement instanceof IAttributeInfo) || !AttributeSelectorDialog.this.multiSelectionAllowed && ((IAttributeInfo)selectedElement).isComposite()) continue;
                    AttributeSelectorDialog.this.selectedAttributes.add(selectedElement);
                }
                AttributeSelectorDialog.this.getButton(0).setEnabled(!AttributeSelectorDialog.this.selectedAttributes.isEmpty());
            }
        });
        this.mbeanTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                AttributeSelectorDialog.this.mbeanTreeViewer.setExpandedState(element, !AttributeSelectorDialog.this.mbeanTreeViewer.getExpandedState(element));
            }
        });
        this.mbeanTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        return dialogArea;
    }

    private void setFilterText(String text) {
        this.mbeanTreeRefreshJob.cancel();
        if (text == null || text.length() == 0) {
            this.filterText = null;
        } else {
            this.filterText = text.toLowerCase();
            this.filterText = FilterMatcher.autoAddKleene((String)this.filterText, (FilterMatcher.Where)FilterMatcher.Where.AFTER);
        }
        this.mbeanTreeRefreshJob.schedule(600L);
    }

    private void expandNodes(IAttributeInfo[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return;
        }
        MBeanTreeContentProvider contentProvider = (MBeanTreeContentProvider)this.mbeanTreeViewer.getContentProvider();
        int i = 0;
        while (i < attributes.length) {
            ITreeNode node = contentProvider.findNode(attributes[i]);
            if (node != null) {
                this.mbeanTreeViewer.expandToLevel((Object)node, 0);
            }
            ++i;
        }
    }

    private void selectNodes(IAttributeInfo[] selected) {
        if (selected == null || selected.length == 0) {
            return;
        }
        MBeanTreeContentProvider contentProvider = (MBeanTreeContentProvider)this.mbeanTreeViewer.getContentProvider();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        int i = 0;
        while (i < selected.length) {
            ITreeNode node = contentProvider.findNode(selected[i]);
            if (node != null) {
                LinkedList<ITreeNode> path = new LinkedList<ITreeNode>();
                while (node != null) {
                    path.addFirst(node);
                    node = node.getParent();
                }
                paths.add(new TreePath(path.toArray()));
            }
            ++i;
        }
        this.mbeanTreeViewer.setSelection((ISelection)new TreeSelection(paths.toArray(new TreePath[paths.size()])));
    }

    private boolean matchesFilterText(String stringToTest) {
        if (this.filterText != null) {
            return FilterMatcher.getInstance().match(stringToTest.toLowerCase(), this.filterText);
        }
        return true;
    }

    class AttributeTreeFilter
    extends ViewerFilter {
        private boolean showOnlyNumericalAttributes;

        public AttributeTreeFilter(boolean onlyNumericals) {
            this.showOnlyNumericalAttributes = onlyNumericals;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ITreeNode node = (ITreeNode)element;
            if (node.getUserData() instanceof IAttributeInfo) {
                IAttributeInfo info = (IAttributeInfo)node.getUserData();
                if (this.showOnlyNumericalAttributes && !info.isNumerical() && !info.isComposite()) {
                    return false;
                }
                IBaseLabelProvider baseLabelProvider = AttributeSelectorDialog.this.mbeanTreeViewer.getLabelProvider();
                ILabelProvider labelProvider = baseLabelProvider instanceof ILabelProvider ? (ILabelProvider)baseLabelProvider : null;
                ITableLabelProvider tableLabelProvider = baseLabelProvider instanceof ITableLabelProvider ? (ITableLabelProvider)baseLabelProvider : null;
                while (node != null) {
                    String nodeText;
                    String string = nodeText = labelProvider != null ? labelProvider.getText((Object)node) : tableLabelProvider.getColumnText((Object)node, 0);
                    if (AttributeSelectorDialog.this.matchesFilterText(nodeText)) {
                        return true;
                    }
                    node = node.getParent();
                }
            } else {
                ITreeNode[] children = node.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.select(viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

