/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AttributeModel
implements XmlEnabled {
    private static final String TAG_ATTRIBUTE_MODEL = "AttributeModel";
    private IMBeanService m_mbeanService;
    private IAttributeInfoService m_attributeInfoService;
    private List<AttributeDescriptor> m_attributes = new ArrayList<AttributeDescriptor>();
    private List<IAttributeModelListener> m_listeners = Collections.synchronizedList(new ArrayList());

    public void setMBeanService(IMBeanService mbeanService) {
        this.m_mbeanService = mbeanService;
        this.m_attributeInfoService = this.m_mbeanService.getAttributeInfoService();
    }

    public void clear() {
        while (!this.m_attributes.isEmpty()) {
            this.remove(this.m_attributes.get(0));
        }
    }

    public boolean add(AttributeDescriptor attribute) {
        if (this.m_attributes.contains(attribute)) {
            return false;
        }
        IAttributeInfo info = this.m_attributeInfoService.getAttributeInfo(attribute);
        if (info.isComposite()) {
            boolean res = false;
            IAttributeInfo[] iAttributeInfoArray = AttributeInfoToolkit.getCompositeChildren((IConnectionHandle)this.m_mbeanService.getConnectionHandle(), (IAttributeInfo)info);
            int n = iAttributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAttributeInfo child = iAttributeInfoArray[n2];
                res |= this.add(child.getAttributeDescriptor());
                ++n2;
            }
            return res;
        }
        if (this.m_attributes.add(attribute)) {
            AttributeModelEvent event = AttributeModelEvent.createAddEvent(this, attribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeAdded(event);
            }
            return true;
        }
        return false;
    }

    public boolean remove(AttributeDescriptor attribute) {
        if (this.m_attributes.remove(attribute)) {
            AttributeModelEvent event = AttributeModelEvent.createRemoveEvent(this, attribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeRemoved(event);
            }
            return true;
        }
        return false;
    }

    public boolean change(AttributeDescriptor fromAttribute, AttributeDescriptor toAttribute) {
        if (this.m_attributes.contains(fromAttribute) && !this.m_attributes.contains(toAttribute)) {
            int index = this.m_attributes.indexOf(fromAttribute);
            this.m_attributes.remove(index);
            this.m_attributes.add(index, toAttribute);
            AttributeModelEvent event = AttributeModelEvent.createChangeEvent(this, fromAttribute, toAttribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeChanged(event);
            }
            return true;
        }
        return false;
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        return this.m_attributes.toArray(new AttributeDescriptor[this.m_attributes.size()]);
    }

    public boolean contains(AttributeDescriptor attribute) {
        return this.m_attributes.contains(attribute);
    }

    public void addAttributeModelListener(IAttributeModelListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeAttributeModelListener(IAttributeModelListener listener) {
        this.m_listeners.remove(listener);
    }

    public void exportToXml(Element parentNode) {
        Element node = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        for (AttributeDescriptor attribute : this.m_attributes) {
            XmlSerializerToolkit.exportToXml((AttributeDescriptor)attribute, (Element)node);
        }
    }

    public String getComponentTag() {
        return TAG_ATTRIBUTE_MODEL;
    }

    public void initializeFromXml(Element node) throws Exception {
        List attributeNodes = XmlToolkit.getChildNodesByTag((Node)node, (String)"AttributeName");
        for (Element e : attributeNodes) {
            this.add(XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)e));
        }
    }
}

