/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

class AttributeLabelProvider
implements ITableLabelProvider {
    private ILabelProvider providerDelegate;
    private GraphSettingRegistry graphSettingRegistry;

    public AttributeLabelProvider(TreeViewer viewer, GraphSettingRegistry graphSettingRegistry) {
        this.providerDelegate = new MBeanTreeLabelProvider(viewer);
        this.graphSettingRegistry = graphSettingRegistry;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object data = ((ITreeNode)element).getUserData();
        if (columnIndex == 0) {
            return this.providerDelegate.getImage(element);
        }
        if (columnIndex == 2 && data instanceof IAttributeInfo) {
            return this.graphSettingRegistry.getColorThumbnail(((IAttributeInfo)data).getAttributeDescriptor());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IAttributeInfo) {
            IAttributeInfo info = (IAttributeInfo)data;
            if (columnIndex == 0) {
                int n = info.getAttributeDescriptor().getAttributeName().lastIndexOf(AttributeToolkit.VALUE_COMPOSITE_DELIMITER);
                if (n < 0) {
                    n = 0;
                }
                return info.getAttributeDescriptor().getAttributeName().substring(n);
            }
            if (columnIndex == 1 && info.isNumerical()) {
                return this.graphSettingRegistry.getMultiplier(info.getAttributeDescriptor()).toString();
            }
            if (columnIndex == 2) {
                return null;
            }
        } else if (columnIndex == 0) {
            return this.providerDelegate.getText(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

