/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.ByteField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.NormalizedScientificNotationField;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.PercentageField;
import com.jrockit.mc.core.model.fields.SecondsField;
import com.jrockit.mc.core.model.fields.TicksFields;
import com.jrockit.mc.core.model.fields.TimeSpanField;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.core.ui.dial.DeviceDescriptionFactory;
import com.jrockit.mc.core.ui.dial.DialConfiguration;
import com.jrockit.mc.core.ui.dial.DialFieldInformation;
import com.jrockit.mc.core.ui.dial.DialInformationViewer;
import com.jrockit.mc.core.ui.dial.DialSectionPart;
import com.jrockit.mc.core.ui.dial.DialViewer;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.IDialInformationProvider;
import com.jrockit.mc.core.ui.dial.IDialProvider;
import com.jrockit.mc.core.ui.dial.MovingDial;
import com.jrockit.mc.core.ui.dial.WatermarkDial;
import com.jrockit.mc.core.ui.dial.WatermarkDialFieldInformation;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.proxy.IProxyOperations;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDialConfigurationPage;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDialSectionPart
extends DialSectionPart
implements XmlEnabled,
IAttributeVisualizer {
    public static final String TAG_DIAL_SECTION_PART = "dial";
    public static final String KEY_MAX_DIAL = "max";
    public static final String KEY_CURRENT_DIAL = "current";
    private AttributeDescriptor m_attributeDescriptor = null;
    private DialConfiguration m_dialConfiguration = null;
    private boolean m_hasAskedAboutPercentage;
    private IAttributeValueListener m_attributeValueListener = new ValueListener();
    private IConnectionHandle m_handle;
    private IAction m_removeAction;

    public AttributeDialSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    public void setRemoveAction(IAction action) {
        this.m_removeAction = action;
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IConnectionHandle) {
            this.m_handle = (IConnectionHandle)input;
            return true;
        }
        return super.setFormInput(input);
    }

    public void addDials(DialViewer dialViewer, DialInformationViewer infoViewer) {
    }

    protected void initializeSection(Section section) {
    }

    public void initializePart() {
        super.initializePart();
        this.reconfigureViewers();
        this.setUpMenu();
        this.getDialViewer().setToolTipTextProvider(new IToolTipTextProvider(){
            private AttributeDescriptorToolTipTextProvider toolTipTextProvider;
            {
                this.toolTipTextProvider = new AttributeDescriptorToolTipTextProvider((IMBeanService)AttributeDialSectionPart.this.getConnectionHandle().getService(IMBeanService.class));
            }

            public String getToolTipText(Object obj) {
                if (AttributeDialSectionPart.this.m_attributeDescriptor != null) {
                    return this.toolTipTextProvider.getAttributeDescriptorToolTipText(AttributeDialSectionPart.this.m_attributeDescriptor);
                }
                return null;
            }
        });
    }

    protected boolean hasAskedAboutPercentage() {
        return this.m_hasAskedAboutPercentage;
    }

    protected void setHasAskedAboutPercentage(boolean asked) {
        this.m_hasAskedAboutPercentage = asked;
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.getConnectionHandle().getService(ISubscriptionService.class);
    }

    private IConnectionHandle getConnectionHandle() {
        if (this.m_handle == null) {
            throw new RuntimeException("Missing connection handle. You need to set a " + IConnectionHandle.class.getName() + " as input to the form part. See IFormPart#setFormInput()");
        }
        return this.m_handle;
    }

    protected void reconfigureViewers() {
        if (this.getDialViewer() != null && this.getDialInformationViewer() != null && this.m_attributeDescriptor != null) {
            this.ensureDialConfiguration();
            this.reconfigureDialViewer(this.getDialViewer(), this.m_dialConfiguration);
            this.reconfigureInfoViewer(this.getDialInformationViewer(), this.m_dialConfiguration, this.m_attributeDescriptor);
            this.getDialViewer().setTitle(this.m_dialConfiguration.getTitle());
        }
    }

    private void reconfigureInfoViewer(DialInformationViewer infoViewer, DialConfiguration dc, AttributeDescriptor attributeDescriptor) {
        infoViewer.clear();
        infoViewer.addDialInformationProvider(KEY_CURRENT_DIAL, (IDialInformationProvider)new DialFieldInformation(this.createField(Messages.AttributeDialSectionPart_CURRENT_DIAL_VALUE_TEXT, attributeDescriptor, dc.getValueType())));
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.getDialInformationViewer().addDialInformationProvider(KEY_MAX_DIAL, (IDialInformationProvider)new WatermarkDialFieldInformation(this.createField(Messages.AttributeDialSectionPart_MAX_DIAL_VALUE_TEXT, attributeDescriptor, dc.getValueType())));
        }
    }

    private void reconfigureDialViewer(DialViewer dialViewer, DialConfiguration dc) {
        dialViewer.clear();
        dialViewer.addDialProvider(KEY_CURRENT_DIAL, (IDialProvider)new MovingDial());
        if (dc.getUseWatermark()) {
            dialViewer.addDialProvider(KEY_MAX_DIAL, (IDialProvider)new WatermarkDial(dc.getWatermarkColor()));
        }
        dialViewer.setGradientRange(dc.getGradientBeginValue(), dc.getGradientEndValue(), dc.getGradientBeginColor(), dc.getGradientEndColor());
        dialViewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)dc.getValueType(), this.createDeviceDescriptions()));
    }

    private void ensureDialConfiguration() {
        if (this.m_dialConfiguration == null) {
            this.m_dialConfiguration = AttributeDialConfigurationPage.createDefaultDialConfiguration(this.getConnectionHandle(), this.m_attributeDescriptor);
        }
    }

    public DialConfiguration getDialConfiguration() {
        this.ensureDialConfiguration();
        return this.m_dialConfiguration;
    }

    protected void checkIfPercentageOutOfRange(double value) {
        if ("percentage".equals(this.m_dialConfiguration.getValueType()) && value > 1.0 && !this.hasAskedAboutPercentage()) {
            this.setHasAskedAboutPercentage(true);
            this.suggestMultiplierChange(value);
        }
    }

    private void suggestMultiplierChange(final double value) {
        DisplayToolkit.safeAsyncExec((Widget)this.getSection(), (Runnable)new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(AttributeDialSectionPart.this.getSection().getShell(), Messages.AttributeDialSectionPart_DIAL_VALUE_OUT_OF_RANGE_TITLE_TEXT, null, MessageFormat.format(Messages.AttributeDialSectionPart_DIAL_VALUE_OUT_OF_RANGE_FOR_PERECENT_TEXT, new Double(value)), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (dialog.open() == 0) {
                    AttributeDialSectionPart.this.m_dialConfiguration.setMultiplier(0.01);
                    AttributeDialSectionPart.this.reconfigureViewers();
                }
            }
        });
    }

    protected void clearWatermark() {
        WatermarkDial wd = (WatermarkDial)this.getDialViewer().getDialProvider(KEY_MAX_DIAL);
        WatermarkDialFieldInformation wi = (WatermarkDialFieldInformation)this.getDialInformationViewer().getDialInformationProvider(KEY_MAX_DIAL);
        if (wi != null) {
            wi.clearWatermark();
        }
        if (wd != null) {
            wd.clearWatermark();
        }
    }

    protected void setUpMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ClearWatermark());
                if (AttributeDialSectionPart.this.m_removeAction != null) {
                    manager.add(AttributeDialSectionPart.this.m_removeAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new PropertiesAction());
            }
        });
        this.getDialViewer().setMenu(menuManager.createContextMenu((Control)this.getDialViewer()));
    }

    public boolean configure() {
        this.ensureAttributeDescriptor();
        this.ensureDialConfiguration();
        AttributeDialConfigurationPage dp = new AttributeDialConfigurationPage(this.m_handle, this.m_dialConfiguration, this.m_attributeDescriptor, this.createDeviceDescriptions());
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getSection().getShell(), (IWizardPage)dp);
        dialog.setTitle(Messages.AttributeDialSectionPart_CONFIGURE_DIAL_TITLE_TEXT);
        if (dialog.open() == 0) {
            this.m_dialConfiguration = dp.getConfiguration();
            this.remove(this.m_attributeDescriptor);
            this.add(dp.getAttribute());
            return true;
        }
        return false;
    }

    private List<IDeviceDescription> createDeviceDescriptions() {
        ArrayList<IDeviceDescription> list = new ArrayList<IDeviceDescription>(DeviceDescriptionFactory.getDeviceDescriptions());
        IDeviceDescription desc = this.createTimespanFromTicksDescription();
        if (desc != null) {
            list.add(desc);
        }
        return list;
    }

    private IDeviceDescription createTimespanFromTicksDescription() {
        IProxyOperations p = (IProxyOperations)this.m_handle.getService(IProxyOperations.class);
        try {
            return DeviceDescriptionFactory.createTimeSpanBackground((String)"ticks", (double)p.getTicksPerSecond(), (String)Messages.AttributeDialSectionPart_TIME_SPAN_FROM_TICKS_TEXT);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.SEVERE, "Error getting ticks per second", e);
        }
        return null;
    }

    private void ensureAttributeDescriptor() {
        IProxyNames names = (IProxyNames)this.getConnectionHandle().getService(IProxyNames.class);
        this.add(names.getAttributeDescriptor(IProxyNames.Key.OS_JVM_CPU_LOAD));
    }

    public String getComponentTag() {
        return TAG_DIAL_SECTION_PART;
    }

    public void exportToXml(Element parentNode) {
        if (this.m_dialConfiguration != null && this.m_attributeDescriptor != null) {
            Element e1 = XmlToolkit.createElement((Element)parentNode, (String)TAG_DIAL_SECTION_PART);
            this.m_dialConfiguration.exportToXml(e1);
            XmlSerializerToolkit.exportToXml((AttributeDescriptor)this.m_attributeDescriptor, (Element)e1);
            XmlToolkit.setSetting((Element)e1, (String)"hasAskedAboutMultiplierChangeForPercent", (boolean)false);
        }
    }

    public void initializeFromXml(Element node) throws Exception {
        Element e2 = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"AttributeName");
        if (e2 != null) {
            AttributeDescriptor descriptor = XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)e2);
            Element e1 = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"dialConfiguration");
            if (e1 != null) {
                this.m_dialConfiguration = new DialConfiguration();
                this.m_dialConfiguration.initializeFromXml(e1);
            }
            this.m_hasAskedAboutPercentage = XmlToolkit.getSetting((Element)node, (String)"hasAskedAboutMultiplierChangeForPercent", (boolean)false);
            this.add(descriptor);
        }
    }

    protected void processSubscriptionEvent(final AttributeValueEvent event) {
        DisplayToolkit.safeAsyncExec((Widget)this.getSection(), (Runnable)new Runnable(){

            public void run() {
                if (event.getValue() instanceof Number) {
                    double value = ((Number)event.getValue()).doubleValue() * AttributeDialSectionPart.this.m_dialConfiguration.getMultiplier();
                    AttributeDialSectionPart.this.setFormInput(new Double(value));
                }
            }
        });
    }

    @Override
    public boolean add(AttributeDescriptor attributeDescriptor) {
        if (this.m_attributeDescriptor == null) {
            this.m_attributeDescriptor = attributeDescriptor;
            this.getSubscriptionService().addAttributeValueListener(attributeDescriptor, this.m_attributeValueListener);
            this.reconfigureViewers();
            return true;
        }
        return false;
    }

    @Override
    public List<AttributeDescriptor> getAttributeDescriptors() {
        ArrayList<AttributeDescriptor> list = new ArrayList<AttributeDescriptor>();
        if (this.m_attributeDescriptor != null) {
            list.add(this.m_attributeDescriptor);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean remove(AttributeDescriptor attributeDescriptor) {
        if (this.m_attributeDescriptor == attributeDescriptor) {
            this.m_attributeDescriptor = null;
            this.getSubscriptionService().removeAttributeValueListener(this.m_attributeValueListener);
            return true;
        }
        return false;
    }

    private Field createField(String displayName, AttributeDescriptor descriptor, String type) {
        String unit = AttributeToolkit.getUnitString((IConnectionHandle)this.getConnectionHandle(), (AttributeDescriptor)descriptor);
        Field field = this.createDynamicField(type, unit);
        if (field == null) {
            field = AttributeDialSectionPart.createStaticField(type, unit);
        }
        field.setName(displayName);
        return field;
    }

    private Field createDynamicField(String type, String unit) {
        if ("ticks".equals(type)) {
            TicksFields ticksField = new TicksFields(0);
            IProxyOperations p = (IProxyOperations)this.getConnectionHandle().getService(IProxyOperations.class);
            try {
                ticksField.setTickPerSecond(p.getTicksPerSecond());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ticksField;
        }
        return null;
    }

    private static Field createStaticField(String type, String unit) {
        if ("percentage".equals(type)) {
            return new PercentageField(0);
        }
        if ("time.span.ms".equals(type)) {
            return new TimeSpanField(0);
        }
        if ("time.span.s".equals(type)) {
            return new SecondsField(0);
        }
        if ("small.number".equals(type)) {
            return new NumberField(0);
        }
        if (DeviceDescriptionFactory.SCIENTIFIC_NOTATION.equals(type)) {
            return new NormalizedScientificNotationField(0, 1);
        }
        if ("bytes".equals(type)) {
            return new ByteField(0);
        }
        if ("%".equals(unit)) {
            return new PercentageField(0);
        }
        if ("bytes".equals(unit)) {
            return new ByteField(0);
        }
        return new NormalizedScientificNotationField(0, 1);
    }

    @Override
    public Control getControl() {
        return this.getSection();
    }

    @Override
    public void clear() {
        List<AttributeDescriptor> list = this.getAttributeDescriptors();
        Iterator<AttributeDescriptor> it = list.iterator();
        while (it.hasNext()) {
            this.remove(it.next());
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.equals(AttributeVisualizerBuilder.TITLE)) {
            return this.getDialTitle();
        }
        return null;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (value instanceof String && key.equals(AttributeVisualizerBuilder.TITLE)) {
            return this.setDialTitle(value);
        }
        return InternalToolkit.unsupportedKey(key);
    }

    public class ClearWatermark
    extends Action {
        public ClearWatermark() {
            super(Messages.AttributeDialSectionPart_CLEAR_WATERMARK_MENU_TEXT);
        }

        public void run() {
            AttributeDialSectionPart.this.clearWatermark();
        }

        public boolean isEnabled() {
            return AttributeDialSectionPart.this.getDialViewer().getDialProvider(AttributeDialSectionPart.KEY_MAX_DIAL) != null;
        }
    }

    public class PropertiesAction
    extends Action {
        public PropertiesAction() {
            super(Messages.AttributeDialSectionPart_DIAL_PROPETIES_TEXT);
        }

        public void run() {
            AttributeDialSectionPart.this.configure();
        }
    }

    public class ValueListener
    implements IAttributeValueListener {
        public void valueChanged(AttributeValueEvent event) {
            AttributeDialSectionPart.this.processSubscriptionEvent(event);
        }
    }
}

