/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.misc.ui.OnePageWizardDialog;
import com.jrockit.mc.core.model.fields.ByteField;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.NormalizedScientificNotationField;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.model.fields.PercentageField;
import com.jrockit.mc.core.model.fields.SecondsField;
import com.jrockit.mc.core.model.fields.TicksFields;
import com.jrockit.mc.core.model.fields.TimeSpanField;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.core.ui.dial.DeviceDescriptionFactory;
import com.jrockit.mc.core.ui.dial.Dial;
import com.jrockit.mc.core.ui.dial.DialConfiguration;
import com.jrockit.mc.core.ui.dial.DialFieldInformation;
import com.jrockit.mc.core.ui.dial.DialInformationViewer;
import com.jrockit.mc.core.ui.dial.DialViewer;
import com.jrockit.mc.core.ui.dial.IDeviceDescription;
import com.jrockit.mc.core.ui.dial.IDialInformationProvider;
import com.jrockit.mc.core.ui.dial.IDialProvider;
import com.jrockit.mc.core.ui.dial.MovingDial;
import com.jrockit.mc.core.ui.dial.WatermarkDial;
import com.jrockit.mc.core.ui.dial.WatermarkDialFieldInformation;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.proxy.IProxyOperations;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeChangeEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDialConfigurationPage;
import com.jrockit.mc.rjmx.ui.internal.AttributeModel;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeChangeListener;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDial
extends Dial
implements XmlEnabled {
    public static final String TAG_ATTRIBUTE_DIAL_COMPOSITE = "AttributeDial";
    public static final String KEY_MAX_DIAL = "max";
    public static final String KEY_CURRENT_DIAL = "current";
    private AttributeDescriptor m_attributeDescriptor = null;
    private DialConfiguration m_dialConfiguration = null;
    private IAttributeValueListener m_attributeValueListener = new ValueListener();
    private AttributeModel m_attributeModel;
    private FreezeModel m_freezeModel;
    private IConnectionHandle m_handle;
    private IAction m_removeAction;
    private boolean m_initialized;
    private Set<IAttributeChangeListener> m_attributeChangeListeners;

    public AttributeDial(AttributeModel attributeModel, FreezeModel freezeModel) {
        this.m_attributeModel = attributeModel;
        this.m_freezeModel = freezeModel;
    }

    public void setRemoveAction(IAction action) {
        this.m_removeAction = action;
    }

    public boolean setInput(Object input) {
        if (input instanceof IConnectionHandle) {
            this.m_handle = (IConnectionHandle)input;
            if (!this.m_initialized) {
                this.m_initialized = true;
                this.initializePart();
            }
            return true;
        }
        return super.setInput(input);
    }

    private void initializePart() {
        this.reconfigureViewers();
        this.setUpMenu();
        this.getDialViewer().setToolTipTextProvider(new IToolTipTextProvider(){
            private AttributeDescriptorToolTipTextProvider toolTipTextProvider;
            {
                this.toolTipTextProvider = new AttributeDescriptorToolTipTextProvider((IMBeanService)AttributeDial.this.getConnectionHandle().getService(IMBeanService.class));
            }

            public String getToolTipText(Object obj) {
                if (AttributeDial.this.m_attributeDescriptor != null) {
                    return this.toolTipTextProvider.getAttributeDescriptorToolTipText(AttributeDial.this.m_attributeDescriptor);
                }
                return null;
            }
        });
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.getConnectionHandle().getService(ISubscriptionService.class);
    }

    private IConnectionHandle getConnectionHandle() {
        if (this.m_handle == null) {
            throw new RuntimeException("Missing connection handle. You need to set a " + IConnectionHandle.class.getName() + " as input to the form part. See IFormPart#setFormInput()");
        }
        return this.m_handle;
    }

    protected void reconfigureViewers() {
        if (this.getDialViewer() != null && this.getDialInformationViewer() != null && this.m_attributeDescriptor != null) {
            this.ensureDialConfiguration();
            this.reconfigureDialViewer(this.getDialViewer(), this.m_dialConfiguration);
            this.reconfigureInfoViewer(this.getDialInformationViewer(), this.m_dialConfiguration, this.m_attributeDescriptor);
            this.getDialViewer().setTitle(this.m_dialConfiguration.getTitle());
            AttributeValueEvent event = this.getSubscriptionService().getLastAttributeValueEvent(this.m_attributeDescriptor);
            if (event != null) {
                this.processSubscriptionEvent(event);
            }
        }
    }

    private void reconfigureInfoViewer(DialInformationViewer infoViewer, DialConfiguration dc, AttributeDescriptor attributeDescriptor) {
        infoViewer.clear();
        infoViewer.addDialInformationProvider(KEY_CURRENT_DIAL, (IDialInformationProvider)new DialFieldInformation(this.createField(Messages.AttributeDialSectionPart_CURRENT_DIAL_VALUE_TEXT, attributeDescriptor, dc.getValueType())));
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.getDialInformationViewer().addDialInformationProvider(KEY_MAX_DIAL, (IDialInformationProvider)new WatermarkDialFieldInformation(this.createField(Messages.AttributeDialSectionPart_MAX_DIAL_VALUE_TEXT, attributeDescriptor, dc.getValueType())));
        }
    }

    private void reconfigureDialViewer(DialViewer dialViewer, DialConfiguration dc) {
        dialViewer.clear();
        dialViewer.addDialProvider(KEY_CURRENT_DIAL, (IDialProvider)new MovingDial());
        if (dc.getUseWatermark()) {
            dialViewer.addDialProvider(KEY_MAX_DIAL, (IDialProvider)new WatermarkDial(dc.getWatermarkColor()));
        }
        dialViewer.setGradientRange(dc.getGradientBeginValue(), dc.getGradientEndValue(), dc.getGradientBeginColor(), dc.getGradientEndColor());
        dialViewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)dc.getValueType(), AttributeDial.createDeviceDescriptions(this.m_handle)));
    }

    private void ensureDialConfiguration() {
        if (this.m_dialConfiguration == null) {
            this.m_dialConfiguration = AttributeDialConfigurationPage.createDefaultDialConfiguration(this.getConnectionHandle(), this.m_attributeDescriptor);
        }
    }

    public DialConfiguration getDialConfiguration() {
        this.ensureDialConfiguration();
        return this.m_dialConfiguration;
    }

    public void setDialConfiguration(DialConfiguration dialConfiguration) {
        this.m_dialConfiguration = dialConfiguration;
        this.reconfigureDialViewer(this.getDialViewer(), this.m_dialConfiguration);
    }

    protected void clearWatermark() {
        WatermarkDial wd = (WatermarkDial)this.getDialViewer().getDialProvider(KEY_MAX_DIAL);
        WatermarkDialFieldInformation wi = (WatermarkDialFieldInformation)this.getDialInformationViewer().getDialInformationProvider(KEY_MAX_DIAL);
        if (wi != null) {
            wi.clearWatermark();
        }
        if (wd != null) {
            wd.clearWatermark();
        }
    }

    protected void setUpMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new ClearWatermark());
                if (AttributeDial.this.m_removeAction != null) {
                    manager.add(AttributeDial.this.m_removeAction);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new PropertiesAction());
            }
        });
        this.getDialViewer().setMenu(menuManager.createContextMenu((Control)this.getDialViewer()));
    }

    public boolean configure() {
        this.ensureDialConfiguration();
        AttributeDialConfigurationPage dp = new AttributeDialConfigurationPage(this.m_handle, this.m_dialConfiguration, this.m_attributeDescriptor, AttributeDial.createDeviceDescriptions(this.m_handle), this.m_attributeModel.getAttributeDescriptors());
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getDialCompositeInternal().getShell(), (IWizardPage)dp);
        dialog.setTitle(Messages.AttributeDialSectionPart_CONFIGURE_DIAL_TITLE_TEXT);
        if (dialog.open() == 0) {
            this.m_dialConfiguration = dp.getConfiguration();
            AttributeDescriptor configurationAttribute = dp.getAttribute();
            if (!configurationAttribute.equals((Object)this.getAttribute())) {
                this.setAttribute(configurationAttribute);
            } else {
                this.reconfigureViewers();
            }
            return true;
        }
        return false;
    }

    public static List<IDeviceDescription> createDeviceDescriptions(IConnectionHandle handle) {
        ArrayList<IDeviceDescription> list = new ArrayList<IDeviceDescription>(DeviceDescriptionFactory.getDeviceDescriptions());
        IDeviceDescription desc = AttributeDial.createTimespanFromTicksDescription(handle);
        if (desc != null) {
            list.add(desc);
        }
        return list;
    }

    private static IDeviceDescription createTimespanFromTicksDescription(IConnectionHandle handle) {
        IProxyOperations p = (IProxyOperations)handle.getService(IProxyOperations.class);
        try {
            return DeviceDescriptionFactory.createTimeSpanBackground((String)"ticks", (double)p.getTicksPerSecond(), (String)Messages.AttributeDialSectionPart_TIME_SPAN_FROM_TICKS_TEXT);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.SEVERE, "Error getting ticks per second", e);
        }
        return null;
    }

    public String getComponentTag() {
        return TAG_ATTRIBUTE_DIAL_COMPOSITE;
    }

    public void exportToXml(Element parentNode) {
        if (this.m_dialConfiguration != null && this.m_attributeDescriptor != null) {
            Element e1 = XmlToolkit.createElement((Element)parentNode, (String)TAG_ATTRIBUTE_DIAL_COMPOSITE);
            this.m_dialConfiguration.exportToXml(e1);
            XmlSerializerToolkit.exportToXml((AttributeDescriptor)this.m_attributeDescriptor, (Element)e1);
        }
    }

    public void initializeFromXml(Element node) throws Exception {
        Element e2 = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"AttributeName");
        if (e2 != null) {
            AttributeDescriptor descriptor = XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)e2);
            Element e1 = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"dialConfiguration");
            if (e1 != null) {
                this.m_dialConfiguration = new DialConfiguration();
                this.m_dialConfiguration.initializeFromXml(e1);
            }
            this.setAttribute(descriptor);
        }
    }

    public void initializeSettingsFromXml(Element node) throws Exception {
        Element attributeNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"AttributeName");
        if (attributeNode != null) {
            AttributeDescriptor readAttribute = XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)attributeNode);
            if (!readAttribute.equals((Object)this.getAttribute())) {
                return;
            }
            Element configurationNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"dialConfiguration");
            if (configurationNode != null) {
                this.m_dialConfiguration = new DialConfiguration();
                this.m_dialConfiguration.initializeFromXml(configurationNode);
                this.reconfigureViewers();
            }
        }
    }

    protected void processSubscriptionEvent(final AttributeValueEvent event) {
        if (!this.m_freezeModel.isFreezed()) {
            DisplayToolkit.safeAsyncExec((Widget)this.getDialCompositeInternal(), (Runnable)new Runnable(){

                public void run() {
                    if (event.getValue() instanceof Number) {
                        double value = ((Number)event.getValue()).doubleValue() * AttributeDial.this.m_dialConfiguration.getMultiplier();
                        AttributeDial.this.setInput(new Double(value));
                    }
                }
            });
        }
    }

    public void setAttribute(AttributeDescriptor attributeDescriptor) {
        this.fireAttributeChangedEvent(this.m_attributeDescriptor, attributeDescriptor);
        if (this.m_attributeDescriptor != null) {
            this.m_attributeDescriptor = null;
            this.getSubscriptionService().removeAttributeValueListener(this.m_attributeValueListener);
        }
        if (attributeDescriptor != null) {
            this.m_attributeDescriptor = attributeDescriptor;
            this.getSubscriptionService().addAttributeValueListener(attributeDescriptor, this.m_attributeValueListener);
            this.reconfigureViewers();
        }
    }

    public AttributeDescriptor getAttribute() {
        return this.m_attributeDescriptor;
    }

    public void clearAttribute() {
        if (this.m_attributeDescriptor != null) {
            this.fireAttributeChangedEvent(this.m_attributeDescriptor, null);
            this.m_attributeDescriptor = null;
            this.getSubscriptionService().removeAttributeValueListener(this.m_attributeValueListener);
        }
    }

    public void addAttributeChangeListener(IAttributeChangeListener listener) {
        if (this.m_attributeChangeListeners == null) {
            this.m_attributeChangeListeners = new HashSet<IAttributeChangeListener>();
        }
        this.m_attributeChangeListeners.add(listener);
    }

    public void removeAttributeChangeListener(IAttributeChangeListener listener) {
        this.m_attributeChangeListeners.remove(listener);
    }

    protected void fireAttributeChangedEvent(AttributeDescriptor oldAttribute, AttributeDescriptor newAttribute) {
        if (this.m_attributeChangeListeners != null && !this.m_attributeChangeListeners.isEmpty()) {
            AttributeChangeEvent e = new AttributeChangeEvent((Object)this, oldAttribute, newAttribute);
            for (IAttributeChangeListener listener : this.m_attributeChangeListeners) {
                listener.attributeChanged(e);
            }
        }
    }

    private Field createField(String displayName, AttributeDescriptor descriptor, String type) {
        String unit = AttributeToolkit.getUnitString((IConnectionHandle)this.getConnectionHandle(), (AttributeDescriptor)descriptor);
        Field field = this.createDynamicField(type, unit);
        if (field == null) {
            field = AttributeDial.createStaticField(type, unit);
        }
        field.setName(displayName);
        return field;
    }

    private Field createDynamicField(String type, String unit) {
        if ("ticks".equals(type)) {
            TicksFields ticksField = new TicksFields(0);
            IProxyOperations p = (IProxyOperations)this.getConnectionHandle().getService(IProxyOperations.class);
            try {
                ticksField.setTickPerSecond(p.getTicksPerSecond());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ticksField;
        }
        return null;
    }

    private static Field createStaticField(String type, String unit) {
        if ("percentage".equals(type)) {
            return new PercentageField(0);
        }
        if ("time.span.ms".equals(type)) {
            return new TimeSpanField(0);
        }
        if ("time.span.s".equals(type)) {
            return new SecondsField(0);
        }
        if ("small.number".equals(type)) {
            return new NumberField(0);
        }
        if (DeviceDescriptionFactory.SCIENTIFIC_NOTATION.equals(type)) {
            return new NormalizedScientificNotationField(0, 1);
        }
        if ("bytes".equals(type)) {
            return new ByteField(0);
        }
        if ("%".equals(unit)) {
            return new PercentageField(0);
        }
        if ("bytes".equals(unit)) {
            return new ByteField(0);
        }
        return new NormalizedScientificNotationField(0, 1);
    }

    public class ClearWatermark
    extends Action {
        public ClearWatermark() {
            super(Messages.AttributeDialSectionPart_CLEAR_WATERMARK_MENU_TEXT);
        }

        public void run() {
            AttributeDial.this.clearWatermark();
        }

        public boolean isEnabled() {
            return AttributeDial.this.getDialViewer().getDialProvider(AttributeDial.KEY_MAX_DIAL) != null;
        }
    }

    public class PropertiesAction
    extends Action {
        public PropertiesAction() {
            super(Messages.AttributeDialSectionPart_DIAL_PROPETIES_TEXT);
        }

        public void run() {
            AttributeDial.this.configure();
        }
    }

    public class ValueListener
    implements IAttributeValueListener {
        public void valueChanged(AttributeValueEvent event) {
            AttributeDial.this.processSubscriptionEvent(event);
        }
    }
}

