/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.MCConstants;
import com.jrockit.mc.core.model.fields.NumberField;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;

public class AttributeDescriptorToolTipTextProvider
implements IToolTipTextProvider {
    private IMBeanService mbeanService;

    public AttributeDescriptorToolTipTextProvider(IMBeanService mbeanService) {
        this.mbeanService = mbeanService;
    }

    public String getToolTipText(Object obj) {
        return this.getAttributeDescriptorToolTipText((AttributeDescriptor)obj);
    }

    public String getAttributeDescriptorToolTipText(AttributeDescriptor attribute) {
        Object value = null;
        try {
            value = this.mbeanService.getAttributeSubscriptionService().getLastAttributeValueEvent(attribute).getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.getAttributeDescriptorToolTipText(attribute, value);
    }

    public String getAttributeDescriptorToolTipText(AttributeDescriptor attribute, Object value) {
        StringBuffer toolTipText = new StringBuffer();
        toolTipText.append(AttributeInfoToolkit.getDisplayName((IConnectionHandle)this.mbeanService.getConnectionHandle(), (AttributeDescriptor)attribute));
        toolTipText.append(": ");
        if (value == null) {
            toolTipText.append(MCConstants.NOT_AVAILABLE);
        } else if (value instanceof Number) {
            toolTipText.append(NumberField.formatNumber((Number)((Number)value)));
        } else {
            toolTipText.append(value);
        }
        toolTipText.append(" (");
        if (this.mbeanService.getConnectionHandle().isConnected()) {
            toolTipText.append(this.mbeanService.getAttributeInfoService().getAttributeInfo(attribute).getAttributeType());
        } else {
            toolTipText.append(Messages.AttributeDescriptorToolTipTextProvider_ATTRIBUTE_DESCRIPTOR_DISCONNECTED_TYPE);
        }
        toolTipText.append(", ");
        toolTipText.append(MBeanPropertiesOrderer.getAttributePath(attribute));
        toolTipText.append(")");
        return toolTipText.toString();
    }
}

