/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.persistence.internal.PersistentDataAggregator;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeExceptionEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.DefaultAttributeStorageService;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.hirt.greychart.data.ITimestampedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeDescriptorModel
extends Observable
implements XmlEnabled {
    public static final String XML_LOG_TO_HISTORICAL_DATA = "logToHistoricalData";
    private final List<AttributeDescriptor> m_descriptorList = new ArrayList<AttributeDescriptor>();
    private final AttributeChartModel<ITimestampedData> m_attributeChartModel;
    private final IConnectionHandle m_handle;
    private final ExceptionHandler m_subscriptionExceptionHandler;
    private boolean m_logToHistoricalData;
    private boolean m_persistenceEnabled;

    public AttributeDescriptorModel(IConnectionHandle handle, AttributeChartModel<ITimestampedData> model) {
        this.m_handle = handle;
        this.m_attributeChartModel = model;
        this.m_subscriptionExceptionHandler = new ExceptionHandler();
    }

    public void addSubscriptionFailListener(ISubscriptionFailListener listener) {
        this.m_subscriptionExceptionHandler.addSubscriptionFailListener(listener);
    }

    public void removeSubscriptionFailListener(ISubscriptionFailListener listener) {
        this.m_subscriptionExceptionHandler.removeSubscriptionFailListener(listener);
    }

    public void startPersistence() throws IOException {
        this.getPersistenceAggregator().setPersistenceEnabled(this.m_attributeChartModel, true);
        this.m_persistenceEnabled = true;
        this.setChanged();
    }

    private PersistentDataAggregator getPersistenceAggregator() {
        DefaultAttributeStorageService attributeStorageService = (DefaultAttributeStorageService)this.m_handle.getService(IAttributeStorageService.class);
        return attributeStorageService.getPersistentDataAggregator();
    }

    public void stopPersistence() throws IOException {
        this.getPersistenceAggregator().setPersistenceEnabled(this.m_attributeChartModel, false);
        this.m_persistenceEnabled = false;
        this.setChanged();
    }

    public boolean getPersistenceEnabled() {
        return this.m_persistenceEnabled;
    }

    private AttributeXYDataProvider getDataProvider() {
        return (AttributeXYDataProvider)this.m_attributeChartModel.getDataProvider();
    }

    public List<AttributeDescriptor> getAttributeDescriptors() {
        ArrayList<AttributeDescriptor> list = new ArrayList<AttributeDescriptor>();
        list.addAll(this.m_descriptorList);
        return Collections.unmodifiableList(list);
    }

    public AttributeDescriptor[] createAttributeDescriptorArray() {
        return this.m_descriptorList.toArray(new AttributeDescriptor[this.m_descriptorList.size()]);
    }

    public boolean remove(AttributeDescriptor attributeDescriptor) {
        if (this.m_descriptorList.remove(attributeDescriptor)) {
            this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
            if (this.getDataProvider() != null) {
                this.getDataProvider().removeSubscriptionAttributes(new AttributeDescriptor[]{attributeDescriptor});
            }
            if (this.m_subscriptionExceptionHandler != null) {
                this.getSubscriptionService().removeAttributeValueListener(attributeDescriptor, (IAttributeValueListener)this.m_subscriptionExceptionHandler);
            }
            if (this.getPersistenceEnabled()) {
                try {
                    this.startPersistence();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not remove " + attributeDescriptor + " from persistence.", e);
                }
            }
            this.setChanged();
            this.m_attributeChartModel.notifyObservers();
            return true;
        }
        return false;
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.m_handle.getService(ISubscriptionService.class);
    }

    public boolean add(AttributeDescriptor attributeDescriptor) {
        if (this.m_descriptorList.contains(attributeDescriptor)) {
            return false;
        }
        if (this.m_descriptorList.add(attributeDescriptor)) {
            this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
            if (this.getDataProvider() != null) {
                this.getDataProvider().addSubscriptionAttributes(new AttributeDescriptor[]{attributeDescriptor}, this.getChartModel().getGraphSettingsRegistry());
            }
            if (this.m_subscriptionExceptionHandler != null) {
                this.getSubscriptionService().addAttributeValueListener(attributeDescriptor, (IAttributeValueListener)this.m_subscriptionExceptionHandler);
            }
            if (this.getPersistenceEnabled()) {
                try {
                    this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
                    this.startPersistence();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not remove " + attributeDescriptor + " from persistence.", e);
                }
            }
            this.setChanged();
            this.m_attributeChartModel.notifyObservers();
            return true;
        }
        return false;
    }

    public void addAll(List<AttributeDescriptor> attributeDescriptors) {
        for (AttributeDescriptor descriptor : attributeDescriptors) {
            this.add(descriptor);
        }
    }

    public void removeAll(List<AttributeDescriptor> attributeDescriptors) {
        for (AttributeDescriptor descriptor : attributeDescriptors) {
            this.remove(descriptor);
        }
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        for (AttributeDescriptor ad : this.m_descriptorList) {
            XmlSerializerToolkit.exportToXml((AttributeDescriptor)ad, (Element)e);
        }
        XmlToolkit.setSetting((Element)e, (String)XML_LOG_TO_HISTORICAL_DATA, (String)Boolean.toString(this.m_logToHistoricalData));
        this.getChartModel().exportChartModelToXml(e);
    }

    public String getComponentTag() {
        return "chartModel";
    }

    public void initializeFromXml(Element node) throws Exception {
        List attributeNodes = XmlToolkit.getChildNodesByTag((Node)node, (String)"AttributeName");
        for (Element element : attributeNodes) {
            this.add(XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)element));
        }
        this.m_logToHistoricalData = new Boolean(XmlToolkit.getSetting((Element)node, (String)XML_LOG_TO_HISTORICAL_DATA, (String)Boolean.FALSE.toString()));
        this.getChartModel().initializeChartModelFromXml(node);
        this.setChanged();
        this.notifyObservers();
    }

    public AttributeChartModel<ITimestampedData> getChartModel() {
        return this.m_attributeChartModel;
    }

    private static class ExceptionHandler
    implements IAttributeValueListener {
        private final List<ISubscriptionFailListener> m_subscriptionFailListeners = new ArrayList<ISubscriptionFailListener>();

        private ExceptionHandler() {
        }

        public void valueChanged(AttributeValueEvent event) {
            Object value = event.getValue();
            if (event instanceof AttributeExceptionEvent || value == null) {
                this.notifySubscriptionFailListeners();
            }
        }

        public void addSubscriptionFailListener(ISubscriptionFailListener listener) {
            this.m_subscriptionFailListeners.add(listener);
        }

        public void removeSubscriptionFailListener(ISubscriptionFailListener listener) {
            this.m_subscriptionFailListeners.remove(listener);
        }

        private void notifySubscriptionFailListeners() {
            Iterator<ISubscriptionFailListener> it = this.m_subscriptionFailListeners.iterator();
            while (it.hasNext()) {
                it.next().onSubscriptionFailed();
            }
        }
    }

    public static interface ISubscriptionFailListener {
        public void onSubscriptionFailed();
    }
}

