/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.persistence.internal.ExportableAttributeBundle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.TracingDataProvider;
import com.jrockit.mc.rjmx.xml.internal.XmlSerializerToolkit;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeChartModel<T>
extends ChartModel<T>
implements ExportableAttributeBundle {
    public static final String XML_CHART_COMPOSITE_TAG = "chartComposite";
    private AttributeDescriptor[] m_descriptors = new AttributeDescriptor[0];

    public AttributeChartModel(GraphSettingRegistry graphSettingsRegistry, TracingDataProvider<T> dataProvider) {
        super(graphSettingsRegistry, dataProvider);
    }

    public void exportBundleMetaDataToXml(Element parentElement) {
        Element chartCompositeNode = XmlToolkit.createElement((Element)parentElement, (String)XML_CHART_COMPOSITE_TAG);
        this.exportChartModelToXml(chartCompositeNode);
        int n = 0;
        while (n < this.m_descriptors.length) {
            XmlSerializerToolkit.exportToXml((AttributeDescriptor)this.m_descriptors[n], (Element)chartCompositeNode);
            ++n;
        }
    }

    public void importBundleMetaDataFromXml(Element node) {
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)XML_CHART_COMPOSITE_TAG);
        Element chartCompositeNode = (Element)l.get(0);
        if (l.size() > 0) {
            this.initializeChartModelFromXml(chartCompositeNode);
        }
        ArrayList<AttributeDescriptor> list = new ArrayList<AttributeDescriptor>();
        List attributeNodes = XmlToolkit.getChildNodesByTag((Node)chartCompositeNode, (String)"AttributeName");
        int i = 0;
        while (i < attributeNodes.size()) {
            list.add(AttributeDescriptor.createFromQualifiedName((String)XmlToolkit.getStringValue((Element)((Element)attributeNodes.get(i)))));
            ++i;
        }
        this.setAttributeDescriptors(list.toArray(new AttributeDescriptor[list.size()]));
        this.notifyObservers();
    }

    public AttributeDescriptor[] getAttributesInTable() {
        return this.m_descriptors;
    }

    public void setAttributeDescriptors(AttributeDescriptor[] attributes) {
        this.m_descriptors = attributes;
        this.setChanged();
    }
}

