/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.MCConstants;
import com.jrockit.mc.core.misc.ui.DisplayToolkit;
import com.jrockit.mc.core.model.fields.Field;
import com.jrockit.mc.core.model.fields.Row;
import com.jrockit.mc.core.model.fields.StringField;
import com.jrockit.mc.core.model.fields.StructuredRowSelection;
import com.jrockit.mc.core.site.SectionSite;
import com.jrockit.mc.core.ui.IToolTipTextProvider;
import com.jrockit.mc.core.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.core.ui.fields.FieldToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.IMBeanService;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.AttributeInfoToolkit;
import com.jrockit.mc.rjmx.subscription.AttributeValueEvent;
import com.jrockit.mc.rjmx.subscription.IAttributeValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AccessibleComposite;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.TableToolTipMouseTrackAdapter;
import com.jrockit.mc.rjmx.ui.internal.ValueStatistics;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AccessibleAttributeComposite
extends AccessibleComposite {
    public static int FIELD_COUNT = 0;
    public static Field FIELD_ATTRIBUTE = new StringField(FIELD_COUNT++);
    public static Field FIELD_VALUE = new StringField(FIELD_COUNT++);
    public static Field FIELD_MINIMUM = new StringField(FIELD_COUNT++);
    public static Field FIELD_MAXIMUM = new StringField(FIELD_COUNT++);
    public static Field FIELD_AVERAGE = new StringField(FIELD_COUNT++);
    public static Field FIELD_ATTRIBUTE_SPECIFICATION = new StringField(FIELD_COUNT++);
    private static Field[] FIELD_PROTOTYPES;
    private IMBeanService m_mbeanService;
    private AttributeModel m_attributeModel;
    private Map<AttributeDescriptor, ValueStatistics> m_valueStatistics;
    private boolean m_showTimestamp;
    private boolean m_unformattedValues;

    static {
        FieldToolkit.initializeFields((String)"com.jrockit.mc.rjmx.ui.internal.fields", AccessibleAttributeComposite.class);
        FIELD_ATTRIBUTE.setWidthWeight(100);
        FIELD_VALUE.setWidthWeight(50);
        FIELD_MINIMUM.setWidthWeight(50);
        FIELD_MAXIMUM.setWidthWeight(50);
        FIELD_AVERAGE.setWidthWeight(50);
        FIELD_ATTRIBUTE_SPECIFICATION.setWidthWeight(100);
        FIELD_PROTOTYPES = new Field[]{FIELD_ATTRIBUTE, FIELD_VALUE, FIELD_MINIMUM, FIELD_MAXIMUM, FIELD_AVERAGE, FIELD_ATTRIBUTE_SPECIFICATION};
    }

    public AccessibleAttributeComposite(Composite parent, int style, FormToolkit formToolkit, IMBeanService mbeanService, SectionSite site, AttributeModel attributeModel, FreezeModel freezeModel) {
        super(parent, style, formToolkit, site, FIELD_PROTOTYPES, freezeModel);
        this.m_mbeanService = mbeanService;
        this.m_attributeModel = attributeModel;
        this.m_valueStatistics = new HashMap<AttributeDescriptor, ValueStatistics>();
        this.m_showTimestamp = false;
        this.m_unformattedValues = false;
        Table table = this.getFieldTableViewer().getTable();
        table.addMouseTrackListener((MouseTrackListener)new TableToolTipMouseTrackAdapter(table, new IToolTipTextProvider(){
            private AttributeDescriptorToolTipTextProvider attributeToolTipTextProvider;
            {
                this.attributeToolTipTextProvider = new AttributeDescriptorToolTipTextProvider(AccessibleAttributeComposite.this.m_mbeanService);
            }

            public String getToolTipText(Object obj) {
                AttributeDescriptor attribute = (AttributeDescriptor)((Row)obj).getElement();
                if (!AccessibleAttributeComposite.this.getFreezeModel().isFreezed()) {
                    return this.attributeToolTipTextProvider.getToolTipText(attribute);
                }
                return this.attributeToolTipTextProvider.getAttributeDescriptorToolTipText(attribute, ((ValueStatistics)AccessibleAttributeComposite.this.m_valueStatistics.get(attribute)).getLastValue());
            }
        }));
        this.m_attributeModel.addAttributeModelListener(new IAttributeModelListener(table){
            private ISubscriptionService m_subscriptionService;
            private IAttributeValueListener m_attributeValueListener;
            {
                this.m_subscriptionService = AccessibleAttributeComposite.this.m_mbeanService.getAttributeSubscriptionService();
                this.m_attributeValueListener = new IAttributeValueListener(){

                    public void valueChanged(final AttributeValueEvent event) {
                        DisplayToolkit.safeAsyncExec((Widget)table, (Runnable)new Runnable(){

                            public void run() {
                                AttributeDescriptor attribute = event.getSubscriptionAttribute();
                                ValueStatistics valueStatistics = (ValueStatistics)AccessibleAttributeComposite.this.m_valueStatistics.get(attribute);
                                if (valueStatistics != null) {
                                    valueStatistics.updateStatistics(event.getValue(), event.getTimestamp());
                                }
                                if (!AccessibleAttributeComposite.this.getFreezeModel().isFreezed()) {
                                    AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
                                }
                            }
                        });
                    }
                };
            }

            private void addAttribute(AttributeDescriptor attribute) {
                AttributeValueEvent valueEvent = AccessibleAttributeComposite.this.m_mbeanService.getAttributeSubscriptionService().getLastAttributeValueEvent(attribute);
                if (valueEvent == null) {
                    AccessibleAttributeComposite.this.m_valueStatistics.put(attribute, new ValueStatistics(null, 0L));
                } else {
                    AccessibleAttributeComposite.this.m_valueStatistics.put(attribute, new ValueStatistics(valueEvent.getValue(), valueEvent.getTimestamp()));
                }
                this.m_subscriptionService.addAttributeValueListener(attribute, this.m_attributeValueListener);
            }

            private void removeAttribute(AttributeDescriptor attribute) {
                this.m_subscriptionService.removeAttributeValueListener(attribute, this.m_attributeValueListener);
                AccessibleAttributeComposite.this.m_valueStatistics.remove(attribute);
            }

            public void attributeAdded(AttributeModelEvent event) {
                this.addAttribute(event.getAttribute());
                AccessibleAttributeComposite.this.getFieldTableViewer().setInput((Object)AccessibleAttributeComposite.this.m_attributeModel);
            }

            public void attributeRemoved(AttributeModelEvent event) {
                this.removeAttribute(event.getAttribute());
                AccessibleAttributeComposite.this.getFieldTableViewer().setInput((Object)AccessibleAttributeComposite.this.m_attributeModel);
            }

            public void attributeChanged(AttributeModelEvent event) {
                this.removeAttribute(event.getFromAttribute());
                this.addAttribute(event.getAttribute());
                AccessibleAttributeComposite.this.getFieldTableViewer().setInput((Object)AccessibleAttributeComposite.this.m_attributeModel);
            }
        });
        this.getFieldTableViewer().setInput((Object)this.m_attributeModel);
    }

    protected AbstractFieldTableContentProvider createFieldTableContentProvider() {
        return new AttributeFieldTableContentProvider();
    }

    protected Composite createControlComposite(FormToolkit formToolkit) {
        ScrolledComposite sc = this.createControlCompositeWrapper();
        final Composite buttonComposite = formToolkit.createComposite((Composite)sc);
        GridData gridData = new GridData(4, 4, true, true);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        Button addAttributeButton = formToolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_ADD_TEXT, 0);
        GridData gd3 = new GridData(4, 4, false, false);
        addAttributeButton.setLayoutData((Object)gd3);
        addAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("add-obj.gif"));
        addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeSelectorDialog dialog = new AttributeSelectorDialog(buttonComposite.getShell(), true);
                AttributeDescriptor[] current = AccessibleAttributeComposite.this.m_attributeModel.getAttributeDescriptors();
                AttributeDescriptor[] selectedAttributes = dialog.show(AccessibleAttributeComposite.this.m_mbeanService, new AttributeDescriptor[0], current, false);
                if (selectedAttributes != null && selectedAttributes.length > 0) {
                    AttributeDescriptor[] attributeDescriptorArray = selectedAttributes;
                    int n = selectedAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AttributeDescriptor attribute = attributeDescriptorArray[n2];
                        AccessibleAttributeComposite.this.m_attributeModel.add(attribute);
                        ++n2;
                    }
                }
            }
        });
        Button removeAttributeButton = formToolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_REMOVE_TEXT, 0);
        GridData gd4 = new GridData(4, 4, false, false);
        removeAttributeButton.setLayoutData((Object)gd4);
        removeAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("remove-obj.png"));
        removeAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredRowSelection selection = (StructuredRowSelection)AccessibleAttributeComposite.this.getFieldTableViewer().getSelection();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    AccessibleAttributeComposite.this.m_attributeModel.remove((AttributeDescriptor)i.next());
                }
            }
        });
        Button clearStatisticsButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_BUTTON_CLEAR_STATISTICS_LABEL, 0);
        GridData gd5 = new GridData(4, 4, false, false);
        clearStatisticsButton.setLayoutData((Object)gd5);
        clearStatisticsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ValueStatistics statistics : AccessibleAttributeComposite.this.m_valueStatistics.values()) {
                    statistics.resetStatistics();
                    AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
                }
            }
        });
        final Button timestampButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_CHECKBOX_TIMESTAMPS_LABEL, 32);
        GridData gd7 = new GridData(4, 4, false, false);
        timestampButton.setLayoutData((Object)gd7);
        timestampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessibleAttributeComposite.this.m_showTimestamp = timestampButton.getSelection();
            }
        });
        timestampButton.setSelection(this.m_showTimestamp);
        final Button unformattedButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_CHECKBOX_UNFORMATTED_VALUES_LABEL, 32);
        GridData gd8 = new GridData(4, 4, false, false);
        unformattedButton.setLayoutData((Object)gd8);
        unformattedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessibleAttributeComposite.this.m_unformattedValues = unformattedButton.getSelection();
            }
        });
        unformattedButton.setSelection(this.m_unformattedValues);
        this.wrapControlComposite(sc, buttonComposite);
        return sc;
    }

    private ValueStatistics getValueStatistics(AttributeDescriptor attribute) {
        return this.m_valueStatistics.get(attribute);
    }

    private boolean showTimeStamps() {
        return this.m_showTimestamp;
    }

    private boolean showUnformatedValues() {
        return this.m_unformattedValues;
    }

    private final class AttributeFieldTableContentProvider
    extends AbstractFieldTableContentProvider {
        private DateFormat dateFormat = DateFormat.getTimeInstance();
        private NumberFormat numberFormat = NumberFormat.getNumberInstance();
        private NumberFormat format = NumberFormat.getIntegerInstance();

        private AttributeFieldTableContentProvider() {
        }

        public Object[] getColumnObject(Object inputRowElement) {
            AttributeDescriptor attribute;
            ValueStatistics statistics;
            if (inputRowElement instanceof AttributeDescriptor && (statistics = AccessibleAttributeComposite.this.getValueStatistics(attribute = (AttributeDescriptor)inputRowElement)) != null) {
                return new Object[]{AttributeInfoToolkit.getDisplayName((IConnectionHandle)AccessibleAttributeComposite.this.m_mbeanService.getConnectionHandle(), (AttributeDescriptor)attribute), this.buildValueTimestampString(statistics.getLastValue(), statistics.getLastTimestamp()), this.buildValueTimestampString(statistics.getMinimumValue(), statistics.getMinimumTimestamp()), this.buildValueTimestampString(statistics.getMaximumValue(), statistics.getMaximumTimestamp()), this.buildValueTimestampString(statistics.getAverageValue(), statistics.getLastTimestamp()), MBeanPropertiesOrderer.getAttributePath(attribute)};
            }
            return new Object[]{"", "", "", "", "", ""};
        }

        private String buildValueTimestampString(Object value, long timeStamp) {
            if (value == null) {
                return MCConstants.NOT_AVAILABLE;
            }
            if (!AccessibleAttributeComposite.this.showTimeStamps()) {
                return this.buildValue(value);
            }
            StringBuilder sb = new StringBuilder(this.buildValue(value));
            sb.append(" @ ");
            sb.append(this.dateFormat.format(new Date(timeStamp)));
            return sb.toString();
        }

        private String buildValue(Object value) {
            if (AccessibleAttributeComposite.this.showUnformatedValues() || !(value instanceof Number)) {
                return value.toString();
            }
            if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                return this.numberFormat.format(value);
            }
            return this.format.format(value);
        }

        public Object[] getRowElements(Object inputElement) {
            if (inputElement instanceof AttributeModel) {
                AttributeModel attributeModel = (AttributeModel)inputElement;
                return attributeModel.getAttributeDescriptors();
            }
            return new Object[0];
        }
    }
}

