/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.AttributeDescriptor;
import com.jrockit.mc.rjmx.subscription.IAttributeInfo;
import com.jrockit.mc.rjmx.subscription.IAttributeInfoService;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import java.awt.Color;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class AbstractAttributeLabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    private org.eclipse.swt.graphics.Color greyedOutColor;
    private IAttributeInfoService attributeInfoManager;
    private ISubscriptionService attributeSubscriptionService;
    private IConnectionHandle connectionHandle;

    public AbstractAttributeLabelProvider(Table table, IConnectionHandle handle) {
        this.connectionHandle = handle;
        this.attributeInfoManager = (IAttributeInfoService)handle.getService(IAttributeInfoService.class);
        this.attributeSubscriptionService = (ISubscriptionService)handle.getService(ISubscriptionService.class);
    }

    public void dispose() {
        if (this.greyedOutColor != null) {
            this.greyedOutColor.dispose();
            this.greyedOutColor = null;
        }
    }

    public Font getFont(Object element, int columnIndex) {
        IAttributeInfo info = element instanceof IAttributeInfo ? (IAttributeInfo)element : this.attributeInfoManager.getAttributeInfo((AttributeDescriptor)element);
        if (columnIndex == 0 && info.isWritable()) {
            return CorePlugin.getDefault().getFontColorToolkit().getBoldTableFont();
        }
        return CorePlugin.getDefault().getFontColorToolkit().getNormalTableFont();
    }

    public org.eclipse.swt.graphics.Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public org.eclipse.swt.graphics.Color getForeground(Object element, int columnIndex) {
        AttributeDescriptor descriptor = element instanceof AttributeDescriptor ? (AttributeDescriptor)element : ((IAttributeInfo)element).getAttributeDescriptor();
        if (this.getAttributeSubscriptionService().isAttributeUnavailable(descriptor)) {
            if (this.greyedOutColor == null) {
                Color c = GraphSettingRegistry.getGreyedOutAWTColor();
                this.greyedOutColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), c.getRed(), c.getGreen(), c.getBlue());
            }
            return this.greyedOutColor;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected ISubscriptionService getAttributeSubscriptionService() {
        return this.attributeSubscriptionService;
    }

    protected IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }
}

