/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.internal.AttributeFieldTableSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedDialsSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ISectionPartModifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class AttributeVisualizerBuilder {
    public static String TITLE = "title";
    public static String TITLE_AXIS_X = "axisX";
    public static String TITLE_AXIS_Y = "axisY";
    public static String RANGE_TYPE_AXIS_Y = "rangeTypeY";
    public static String IDENTIFIER = "sectionIdentifier";
    public static String STYLE = "sectionStyle";
    private final Composite parent;
    private final FormToolkit toolkit;
    private final Object input;
    private final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final IManagedForm form;

    public AttributeVisualizerBuilder(IManagedForm managedForm, IConnectionHandle connectionHandle) {
        this(managedForm, managedForm.getForm().getBody(), connectionHandle);
    }

    public AttributeVisualizerBuilder(IManagedForm managedForm, Composite container, IConnectionHandle connectionHandle) {
        this.parent = container;
        this.toolkit = managedForm.getToolkit();
        this.input = connectionHandle;
        this.form = managedForm;
    }

    public Object setProperty(String key, Object value) {
        if (value == null) {
            this.map.remove(key);
        }
        return this.map.put(key, value);
    }

    public IAttributeVisualizer createTable() {
        return this.standardInitialization(new AttributeFieldTableSectionPart(this.parent, this.toolkit, this.getSectionStyle(), this.getSectionIdentifier()));
    }

    public IAttributeVisualizer createChart() {
        return this.standardInitialization(new CombinedChartSectionPart(this.parent, this.toolkit, this.getSectionStyle(), this.getSectionIdentifier()));
    }

    public IAttributeVisualizer createDialDashboard() {
        return this.standardInitialization(new CombinedDialsSectionPart(this.parent, this.toolkit, this.getSectionStyle(), this.getSectionIdentifier()));
    }

    public void clearProperties() {
        this.map.clear();
    }

    private void setProperties(IAttributeVisualizer v) {
        for (Map.Entry<String, Object> me : this.map.entrySet()) {
            String key = me.getKey();
            if (IDENTIFIER.equals(key) || STYLE.equals(key) || "SectionPartModifier".equals(key)) continue;
            v.setProperty(key, me.getValue());
        }
    }

    private IAttributeVisualizer standardInitialization(IAttributeVisualizer visualizer) {
        visualizer.setFormInput(this.input);
        ISectionPartModifier sectionPartModifier = (ISectionPartModifier)this.map.get("SectionPartModifier");
        if (sectionPartModifier != null) {
            sectionPartModifier.modifySectionPart((SectionPart)visualizer);
        }
        this.form.addPart((IFormPart)visualizer);
        this.setProperties(visualizer);
        return visualizer;
    }

    private String getSectionIdentifier() {
        String sectionIdentifier = (String)this.map.get(IDENTIFIER);
        if (sectionIdentifier == null) {
            sectionIdentifier = "random.identifier." + new Random().nextLong();
        }
        return sectionIdentifier;
    }

    private int getSectionStyle() {
        Integer style = (Integer)this.map.get(STYLE);
        if (style == null) {
            return 322;
        }
        return style;
    }
}

