/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.overview;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.NewVisualizerAction;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.overview.Messages;
import com.jrockit.mc.console.ui.overview.OverviewPlugin;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.layout.ReflowExpansionListener;
import com.jrockit.mc.core.layout.SimpleLayout;
import com.jrockit.mc.core.layout.SimpleLayoutData;
import com.jrockit.mc.core.sections.MCSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.proxy.IProxyNames;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.CombinedDialsSectionPart;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.management.MalformedObjectNameException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OverviewTab
extends ConsoleTab
implements XmlEnabled,
ISaveablePart2 {
    private static final String PREFERENCE_KEY_OVERVIEW_DATA = "overviewData";
    private static final String CHARTS_DEFAULT_Y_AXIS_TITLE_TEXT = "(%)";
    private SectionPartManager m_sectionPartManager;
    static /* synthetic */ Class class$0;

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        SimpleLayout layout = new SimpleLayout();
        layout.setAlignment(1);
        layout.setHorizontalOrientation(false);
        form.getBody().setLayout((Layout)layout);
        ConsoleEditor ce = (ConsoleEditor)this.getEditor();
        this.m_sectionPartManager = new SectionPartManager(this.getTitle(), managedForm, new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle()));
        ce.addSectionManager(this.m_sectionPartManager);
        this.initializeToolbar((ContributionManager)form.getToolBarManager(), this.m_sectionPartManager);
        if (!this.initTabFromStore(OverviewPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_OVERVIEW_DATA, this)) {
            OverviewTab.createDefaults(this.m_sectionPartManager);
        }
        this.getManagedForm().reflow(true);
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(OverviewPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_OVERVIEW_DATA, this);
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getDescriptor().getGUID());
        Iterator iter = this.m_sectionPartManager.getParts().iterator();
        while (iter.hasNext()) {
            ((XmlEnabled)iter.next()).exportToXml(e);
        }
    }

    public String getComponentTag() {
        return "OverviewTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        this.initializeDialsFromXml(node);
        this.initializeChartsFromXml(node);
    }

    private void initializeToolbar(ContributionManager cm, SectionPartManager spm) {
        cm.insert(0, (IContributionItem)new ActionContributionItem((IAction)new ResetAction(spm)));
        NewVisualizerAction action = NewVisualizerAction.createAddChartAction((SectionPartManager)spm);
        cm.insert(0, (IContributionItem)new ActionContributionItem((IAction)action));
        cm.update(true);
    }

    private static void createDefaults(SectionPartManager spm) {
        IManagedForm form = spm.getManagementForm();
        IConnectionHandle handle = (IConnectionHandle)form.getInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.proxy.IProxyNames");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProxyNames names = (IProxyNames)handle.getService((Class)clazz);
        AttributeVisualizerBuilder builder = spm.getGuiBuilder();
        OverviewTab.createDefaultDials(spm, form, names, builder);
        OverviewTab.createDefaultCharts(spm, form, names, builder);
    }

    private static void createDefaultDials(SectionPartManager spm, IManagedForm form, IProxyNames names, AttributeVisualizerBuilder builder) {
        builder.clearProperties();
        builder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.overview.help_DialsDashboard");
        builder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.OverviewTab_SECTION_DASHBOARD_TEXT);
        IAttributeVisualizer section = builder.createDialDashboard();
        OverviewTab.setupDialLayoutData(section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeDialPanel(section, names);
    }

    private static void createDefaultCharts(SectionPartManager spm, IManagedForm form, IProxyNames names, AttributeVisualizerBuilder builder) {
        builder.clearProperties();
        builder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.overview.help_ProcessorGraph");
        builder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.OverviewTab_SECTION_PROCESSOR_TEXT);
        builder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_Y, (Object)CHARTS_DEFAULT_Y_AXIS_TITLE_TEXT);
        builder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_X, (Object)Messages.OverviewTab_CHARTS_DEFAULT_X_AXIS_TITLE_TEXT);
        IAttributeVisualizer section = builder.createChart();
        OverviewTab.setupChartLayoutData(section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeProcessorChart(section, names);
        builder.clearProperties();
        builder.setProperty(AttributeVisualizerBuilder.IDENTIFIER, (Object)"com.jrockit.mc.console.ui.overview.help_MemoryGraph");
        builder.setProperty(AttributeVisualizerBuilder.TITLE, (Object)Messages.OverviewTab_SECTION_MEMORY_TEXT);
        builder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_Y, (Object)CHARTS_DEFAULT_Y_AXIS_TITLE_TEXT);
        builder.setProperty(AttributeVisualizerBuilder.TITLE_AXIS_X, (Object)Messages.OverviewTab_CHARTS_DEFAULT_X_AXIS_TITLE_TEXT);
        section = builder.createChart();
        OverviewTab.setupChartLayoutData(section);
        OverviewTab.setUpExpansionHandling((SectionPart)section, form);
        spm.add((MCSectionPart)section);
        OverviewTab.initializeMemoryChart(section, names);
    }

    private static void initializeDialPanel(IAttributeVisualizer dialPanel, IProxyNames proxyNames) {
        dialPanel.clear();
        dialPanel.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_HEAP_USED));
        dialPanel.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_JVM_CPU_LOAD));
        dialPanel.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_LIVE_SET_PERCENT));
    }

    private static void initializeMemoryChart(IAttributeVisualizer memoryChart, IProxyNames proxyNames) {
        memoryChart.clear();
        memoryChart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_PHYSICAL_USED_PERCENT));
        memoryChart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.MEMORY_HEAP_USED_PERCENT));
    }

    private static void initializeProcessorChart(IAttributeVisualizer processorChart, IProxyNames proxyNames) {
        processorChart.clear();
        processorChart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_CPU_LOAD));
        processorChart.add(proxyNames.getAttributeDescriptor(IProxyNames.Key.OS_JVM_CPU_LOAD));
    }

    private void initializeChartsFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)"CombinedChartSectionPart");
        if (l != null) {
            AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                try {
                    Element element = (Element)iter.next();
                    CombinedChartSectionPart sectionPart = (CombinedChartSectionPart)builder.createChart();
                    OverviewTab.setupChartLayoutData((IAttributeVisualizer)sectionPart);
                    OverviewTab.setUpExpansionHandling((SectionPart)sectionPart, this.m_sectionPartManager.getManagementForm());
                    this.m_sectionPartManager.add((MCSectionPart)sectionPart);
                    sectionPart.initializeFromXml(element);
                }
                catch (MalformedObjectNameException e) {
                    CorePlugin.getDefault().getLogger().log(Level.WARNING, "Unable to instantiate graph", e);
                }
            }
        }
    }

    private static void setUpExpansionHandling(SectionPart sectionPart, IManagedForm form) {
        sectionPart.getSection().addExpansionListener((IExpansionListener)new ReflowExpansionListener(form));
    }

    private static void setupDialLayoutData(IAttributeVisualizer adv) {
        SimpleLayoutData sd1 = new SimpleLayoutData();
        GC tempGc = new GC((Drawable)adv.getControl());
        int fontHeight = tempGc.getFontMetrics().getHeight();
        sd1.setMinSize(147 + 3 * fontHeight);
        sd1.setMaxSize(147 + 3 * fontHeight);
        sd1.setWeight(1.0f);
        adv.getControl().setLayoutData((Object)sd1);
    }

    private static void setupChartLayoutData(IAttributeVisualizer adv) {
        SimpleLayoutData sd3 = new SimpleLayoutData();
        sd3.setMinSize(150);
        sd3.setWeight(1.0f);
        adv.getControl().setLayoutData((Object)sd3);
    }

    private void initializeDialsFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildNodesByTag((Node)node, (String)"CombinedDialsSectionPart");
        if (l != null) {
            AttributeVisualizerBuilder builder = this.m_sectionPartManager.getGuiBuilder();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                CombinedDialsSectionPart sectionPart = (CombinedDialsSectionPart)builder.createDialDashboard();
                OverviewTab.setupDialLayoutData((IAttributeVisualizer)sectionPart);
                OverviewTab.setUpExpansionHandling((SectionPart)sectionPart, this.m_sectionPartManager.getManagementForm());
                this.m_sectionPartManager.add((MCSectionPart)sectionPart);
                sectionPart.initializeFromXml(element);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.m_sectionPartManager != null) {
            this.m_sectionPartManager.dispose();
        }
        this.m_sectionPartManager = null;
    }

    private static class ResetAction
    extends ResetToDefaultsAction {
        private final SectionPartManager m_sectionPartManager;

        public ResetAction(SectionPartManager spm) {
            this.m_sectionPartManager = spm;
        }

        protected void reset() {
            this.m_sectionPartManager.destroyAllParts();
            OverviewTab.createDefaults(this.m_sectionPartManager);
        }
    }
}

