/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.fields.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.Field;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FieldHolder {
    private static final String XML_SETTINGS_TAG = "settings";
    protected ArrayList m_properties = new ArrayList();

    public void addField(Field v) {
        if (this.getField(v.getName()) == null) {
            this.m_properties.add(new Tuple(v.getId(), v));
        }
    }

    public Field[] getFields() {
        Field[] fields = new Field[this.m_properties.size()];
        int n = 0;
        Iterator i = this.m_properties.iterator();
        while (i.hasNext()) {
            Tuple tuple = (Tuple)i.next();
            fields[n] = tuple.field;
            ++n;
        }
        return fields;
    }

    public void exportToXml(Element parentNode) {
        Field[] fields = this.getFields();
        Element element = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        int n = 0;
        while (n < fields.length) {
            fields[n].exportToXml(element);
            ++n;
        }
    }

    public void initializeFromXml(Element node) {
        Field[] fields = this.getFields();
        int n = 0;
        while (n < fields.length) {
            NodeList list = node.getElementsByTagName(this.getComponentTag());
            if (list != null && list.getLength() > 0) {
                fields[n].initializeFromXml((Element)list.item(0));
            }
            ++n;
        }
    }

    public Field getField(String id) {
        Iterator i = this.m_properties.iterator();
        while (i.hasNext()) {
            Tuple tuple = (Tuple)i.next();
            if (!tuple.key.equals(id)) continue;
            return tuple.field;
        }
        return null;
    }

    protected String getComponentTag() {
        return XML_SETTINGS_TAG;
    }

    class Tuple {
        public final String key;
        public final Field field;

        Tuple(String id, Field field) {
            this.key = id;
            this.field = field;
        }
    }
}

