/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.fields.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.triggers.ISetting;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.w3c.dom.Element;

public abstract class Field
implements XmlEnabled,
ISetting {
    private final String m_id;
    private final String m_name;
    private final String m_description;
    protected String m_value;
    private ArrayList m_fieldValueChangeListener = new ArrayList();

    protected Field(String id, String name, String defaultValue, String description) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("Id can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Default value can't be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Description can't be null");
        }
        this.m_id = id;
        this.initDefaultValue(defaultValue);
        this.initDefaultPreferenceValue();
        this.m_name = name;
        this.m_description = description;
    }

    abstract void initDefaultValue(String var1);

    public void initDefaultPreferenceValue() {
        String prefDefault;
        if (this.m_id != null && (prefDefault = RJMXPlugin.getDefault().getPreferenceStore().getString(this.m_id)) != null && prefDefault.trim().length() != 0) {
            this.setValue(prefDefault);
        }
    }

    public synchronized void addFieldValueListener(FieldValueChangeListener listener) {
        this.m_fieldValueChangeListener.add(listener);
    }

    public synchronized boolean removeFieldValueListener(FieldValueChangeListener listener) {
        return this.m_fieldValueChangeListener.remove(listener);
    }

    public synchronized void updateListener() {
        Iterator i = this.m_fieldValueChangeListener.iterator();
        while (i.hasNext()) {
            FieldValueChangeListener fcl = (FieldValueChangeListener)i.next();
            fcl.onChange(this);
        }
    }

    public synchronized String getValue() {
        return this.m_value;
    }

    public synchronized boolean setValue(String value) {
        String newValue;
        if (value == null) {
            return false;
        }
        try {
            newValue = this.parsedValue(value);
        }
        catch (Exception nfe) {
            return false;
        }
        if (newValue == null) {
            return false;
        }
        if (!newValue.equals(this.m_value)) {
            this.m_value = newValue;
            this.updateListener();
        }
        return true;
    }

    public boolean validateValue(String value) {
        String parsedValue;
        try {
            parsedValue = this.parsedValue(value);
        }
        catch (Exception nfe) {
            return false;
        }
        return parsedValue != null;
    }

    abstract String parsedValue(String var1) throws Exception;

    public void initializeFromXml(Element node) {
        this.setValue(XmlToolkit.getSetting((Element)node, (String)this.getComponentTag(), (String)""));
    }

    public void exportToXml(Element node) {
        String object = this.getValue();
        try {
            XmlToolkit.setSetting((Element)node, (String)this.getComponentTag(), (String)object);
        }
        catch (Exception e) {
            System.out.println("|" + object + "|");
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getName() {
        return this.m_name;
    }

    public String getComponentTag() {
        return this.getId();
    }

    public Date getDate(Date defaultValue) {
        return defaultValue;
    }

    public Date getDate() {
        return null;
    }

    public Date getDateTime() {
        return null;
    }

    public String getString() {
        return null;
    }

    public Integer getInteger() {
        return null;
    }

    public String getFilename() {
        return null;
    }

    public Float getFloat() {
        return null;
    }

    public Boolean getBoolean() {
        return null;
    }

    public Long getLong() {
        return null;
    }

    public static interface FieldValueChangeListener {
        public void onChange(Field var1);
    }
}

