/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.extension.internal;

import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.triggers.condition.internal.TriggerCondition;
import com.jrockit.mc.rjmx.core.triggers.extension.internal.ExtensionLoader;
import com.jrockit.mc.rjmx.core.triggers.extension.internal.TriggerComponent;
import com.jrockit.mc.rjmx.notification.INotificationAction;
import com.jrockit.mc.rjmx.notification.INotificationConstraint;
import com.jrockit.mc.rjmx.notification.INotificationFactory;
import com.jrockit.mc.rjmx.notification.internal.NotificationRegistry;
import com.jrockit.mc.rjmx.notification.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.notification.internal.RegistryEntry;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class TriggerFactory
implements INotificationFactory {
    private static final String XML_CLASS_ATTRIBUTE = "class";
    private static final String XML_TRIGGER_ACTIONS = "com.jrockit.mc.rjmx.core.triggerActions";
    private static final String XML_TRIGGER_ACTION = "triggerAction";
    private static final String XML_TRIGGER_CONSTRAINTS = "com.jrockit.mc.rjmx.core.triggerConstraints";
    private static final String XML_TRIGGER_CONSTRAINT = "triggerConstraint";
    private ExtensionLoader m_constraints;
    private ExtensionLoader m_actions;
    static /* synthetic */ Class class$0;

    public void initializeFactory() {
        this.getActionExtensions();
        this.getConstraintExtensions();
    }

    public INotificationConstraint createConstraint(String className) throws Exception {
        return (INotificationConstraint)this.createObject(this.getConstraintExtensions().getConfigElement(className));
    }

    public INotificationAction createAction(String className) throws Exception {
        return (INotificationAction)this.createObject(this.getActionExtensions().getConfigElement(className));
    }

    protected Object createObject(IConfigurationElement element) {
        try {
            return element.createExecutableExtension(XML_CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized ExtensionLoader getActionExtensions() {
        if (this.m_actions == null) {
            this.m_actions = new ExtensionLoader(XML_TRIGGER_ACTIONS, XML_TRIGGER_ACTION);
            Iterator i = this.m_actions.getPrototypes().iterator();
            while (i.hasNext()) {
                RegistryEntry entry = this.createRegistryEntry((TriggerComponent)i.next());
                this.getNotificationRegistry().registerAction(entry);
            }
        }
        return this.m_actions;
    }

    private NotificationRegistry getNotificationRegistry() {
        RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.notification.internal.NotificationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (NotificationRegistry)rJMXPlugin.getService(clazz);
    }

    public synchronized ExtensionLoader getConstraintExtensions() {
        if (this.m_constraints == null) {
            this.m_constraints = new ExtensionLoader(XML_TRIGGER_CONSTRAINTS, XML_TRIGGER_CONSTRAINT);
            Iterator i = this.m_constraints.getPrototypes().iterator();
            while (i.hasNext()) {
                RegistryEntry entry = this.createRegistryEntry((TriggerComponent)i.next());
                this.getNotificationRegistry().registerConstraint(entry);
            }
        }
        return this.m_constraints;
    }

    private RegistryEntry createRegistryEntry(TriggerComponent extension) {
        String description = extension.getDescription();
        String listName = extension.getName();
        Class<?> registeredClass = extension.getClass();
        Class<?> editorClass = extension.getClass();
        return new RegistryEntry(registeredClass, listName, description, editorClass);
    }

    public NotificationTrigger createTrigger() {
        return new TriggerCondition();
    }
}

