/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.extension.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

public class ExtensionLoader {
    private final String m_extesionPoint;
    private final String m_extesionName;
    private HashMap m_extensions = new HashMap();
    private ArrayList m_prototypes = new ArrayList();

    public ExtensionLoader(String extensionPoint, String extensionName) {
        this.m_extesionPoint = extensionPoint;
        this.m_extesionName = extensionName;
        this.load();
    }

    public String getExtensionName() {
        return this.m_extesionName;
    }

    public String getExtensionPointId() {
        return this.m_extesionPoint;
    }

    protected void load() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(this.getExtensionPointId());
        if (exPoint == null) {
            return;
        }
        try {
            IExtension[] ext = exPoint.getExtensions();
            int i = 0;
            while (i < ext.length) {
                IConfigurationElement[] element = ext[i].getConfigurationElements();
                int j = 0;
                while (j < element.length) {
                    if (element[j].getName().equalsIgnoreCase(this.getExtensionName())) {
                        this.initExtension(element[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException iroe) {
            System.err.println("Extension point not valid.");
            System.err.println(iroe.getMessage());
        }
    }

    public IConfigurationElement getConfigElement(String className) {
        return (IConfigurationElement)this.m_extensions.get(className);
    }

    public void initExtension(IConfigurationElement element) {
        try {
            Object prototype = element.createExecutableExtension("class");
            String className = element.getAttribute("class");
            this.m_extensions.put(className, element);
            this.m_prototypes.add(prototype);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Collection getPrototypes() {
        return this.m_prototypes;
    }
}

