/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.condition.internal;

import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.triggers.condition.internal.Messages;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.BooleanField;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.FieldHolder;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.FloatField;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.IntegerField;
import com.jrockit.mc.rjmx.core.triggers.fields.internal.StringField;
import com.jrockit.mc.rjmx.notification.IValueEvaluator;
import com.jrockit.mc.rjmx.notification.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.notification.internal.ValueEvaluatorNumberMax;
import com.jrockit.mc.rjmx.notification.internal.ValueEvaluatorStringMatch;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class TriggerCondition
extends NotificationTrigger {
    private FieldHolder m_fieldHolder;

    void initEvaluator() {
        try {
            if (this.getValueEvaluator() instanceof ValueEvaluatorNumberMax) {
                this.createNumberMaxEvalauatorField((ValueEvaluatorNumberMax)this.getValueEvaluator());
            } else {
                this.createNumberMaxEvalauatorField(new ValueEvaluatorNumberMax(0.0));
            }
            if (this.getValueEvaluator() instanceof ValueEvaluatorStringMatch) {
                this.createStringEvaluatorField((ValueEvaluatorStringMatch)this.getValueEvaluator());
            } else {
                this.createStringEvaluatorField(new ValueEvaluatorStringMatch("*"));
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void initFieldHolder() {
        this.m_fieldHolder = new FieldHolder();
        try {
            this.initEvaluator();
            this.createSustained();
            this.createLimit();
            this.createFlankBegin();
            this.createFlankEnd();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void initializeFromXml(Element node) {
        super.initializeFromXml(node);
        this.initFieldHolder();
    }

    public FieldHolder getFieldHolder() {
        return this.m_fieldHolder;
    }

    private void createFlankEnd() throws Exception {
        boolean descendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankEnd = new BooleanField("ONFLANK", Messages.TriggerCondition_DESCENDING_FLANK_CAPTION, Boolean.toString(descendingFlank), Messages.TriggerCondition_DESCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankEnd);
        triggeronFlankEnd.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(2, field.getBoolean());
            }
        });
    }

    private void createFlankBegin() throws Exception {
        boolean ascendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankStart = new BooleanField("ONTRIGGER", Messages.TriggerCondition_ASCENDING_FLANK_CAPTION, Boolean.toString(ascendingFlank), Messages.TriggerCondition_ASCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankStart);
        triggeronFlankStart.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(1, field.getBoolean());
            }
        });
    }

    private void createLimit() throws Exception {
        IntegerField limitField = new IntegerField("LIMIT", Messages.TriggerCondition_LIMIT_PERIOD_CAPTION, Integer.toString(this.getLimitTime()), Messages.TriggerCondition_LIMIT_PERIOD_TOOLTIP, "", "");
        this.m_fieldHolder.addField(limitField);
        limitField.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                TriggerCondition.this.setLimitTime(field.getInteger());
            }
        });
    }

    private void createSustained() throws Exception {
        IntegerField sustained = new IntegerField("SUSTAINED", Messages.TriggerCondition_SUSTAINED_CAPTION, Integer.toString(this.getSustainTime()), Messages.TriggerCondition_SUSTAINED_TOOLTIP, "", "");
        this.m_fieldHolder.addField(sustained);
        sustained.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field value) {
                TriggerCondition.this.setSustainTime(value.getInteger());
            }
        });
    }

    private void createStringEvaluatorField(ValueEvaluatorStringMatch ven) throws Exception {
        String matchString = ven.getMatchString();
        StringField evaluatorField = new StringField("EVAL_STRING", Messages.TriggerCondition_MATCH_STRING_CAPTION, matchString, Messages.TriggerCondition_MATCH_STRING_TOOLTIP);
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator((IValueEvaluator)new ValueEvaluatorStringMatch(field.getString()));
            }
        });
    }

    private void createNumberMaxEvalauatorField(ValueEvaluatorNumberMax ven) throws Exception {
        float maxValue = (float)ven.getMax();
        FloatField evaluatorField = new FloatField("EVAL_NUM_MAX", Messages.TriggerCondition_MAX_TRIGGER_CAPTION, Float.toString(maxValue), Messages.TriggerCondition_MAX_TRIGGER_TOOLTIP, "", "");
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator((IValueEvaluator)new ValueEvaluatorNumberMax(field.getFloat().doubleValue()));
            }
        });
    }

    public void setTriggerFlag(int flag, boolean value) {
        int triggerOn = this.getTriggerOn();
        triggerOn = value ? triggerOn | flag : triggerOn & ~flag;
        this.setTriggerOn(triggerOn);
    }
}

