/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.triggers.actions.internal;

import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.core.triggers.TriggerAction;
import com.jrockit.mc.rjmx.core.triggers.actions.internal.Messages;
import com.jrockit.mc.rjmx.notification.NotificationEvent;
import com.jrockit.mc.rjmx.notification.internal.NotificationToolkit;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.osgi.util.NLS;

public class TriggerActionMail
extends TriggerAction {
    public static final String XML_ELEMENT_EMAIL_FROM = "email_from";
    public static final String XML_ELEMENT_EMAIL_TO = "email_to";
    public static final String XML_ELEMENT_EMAIL_CC = "email_cc";
    public static final String XML_ELEMENT_EMAIL_BCC = "email_bcc";
    public static final String XML_ELEMENT_SMTP_SERVER = "smtp_server";
    private static final String MAILER = Messages.TriggerActionMail_MAIL_HEADER_MAILER;
    private final boolean m_debug = false;

    public void handleNotificationEvent(NotificationEvent e) {
        String subject = this.getSubject(e);
        this.sendEMail(subject, NotificationToolkit.prettyPrint((NotificationEvent)e));
    }

    public void sendEMail(String subject, String content) {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSmtpServer());
        Session session = Session.getInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.getFrom()));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
            if (this.getCc() != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCc(), (boolean)false));
            }
            if (this.getBcc() != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.getBcc(), (boolean)false));
            }
            msg.setSubject(subject);
            msg.setText(content);
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "A notification rule with an e-mail action has triggered, but the sending\nof the e-mail failed, probably due to wrong settings. The e-mail \nwas sent using the following configuration:\n " + this.toString(), e);
        }
    }

    public String getSmtpServer() {
        return this.getSetting(XML_ELEMENT_SMTP_SERVER).getString();
    }

    public String getBcc() {
        return this.getSetting(XML_ELEMENT_EMAIL_BCC).getString();
    }

    public String getCc() {
        return this.getSetting(XML_ELEMENT_EMAIL_CC).getString();
    }

    public String getFrom() {
        return this.getSetting(XML_ELEMENT_EMAIL_FROM).getString();
    }

    public String getTo() {
        return this.getSetting(XML_ELEMENT_EMAIL_TO).getString();
    }

    public String getSubject(NotificationEvent e) {
        if (e.wasTriggered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_TRIGGERED, (Object)e.getRule().getName());
        }
        if (e.wasRecovered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_RECOVERED, (Object)e.getRule().getName());
        }
        return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_INVOKED, (Object)e.getRule().getName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + "\nFrom: " + this.getFrom() + "\nTo: " + this.getTo() + "\nSMTP: " + this.getSmtpServer();
    }
}

