/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.notification.NotificationRule;
import com.jrockit.mc.rjmx.notification.internal.NotificationRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TriggerModel {
    private static final String TRIGGERS_PREFERENCE_KEY = "mc.trigger";
    static /* synthetic */ Class class$0;

    public void activateTriggersForConnection(IConnectionHandle connectionHandle) {
        this.getNotificationRegistry().initServiceForConnector(connectionHandle);
    }

    public String[] getTriggerNamesForConnector(IConnectionHandle connectionHandle) {
        List rules = this.getNotificationRegistry().getRegisteredRules(connectionHandle.getDescriptor().getGUID());
        String[] ruleNames = new String[rules.size()];
        int i = 0;
        Iterator iter = rules.iterator();
        while (iter.hasNext()) {
            NotificationRule rule = (NotificationRule)iter.next();
            ruleNames[i++] = rule.getName();
        }
        return ruleNames;
    }

    public void doLoad() {
        try {
            IPreferenceStore store = RJMXPlugin.getDefault().getPreferenceStore();
            String xml = store.getString(TRIGGERS_PREFERENCE_KEY);
            this.loadFromXML(xml);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Problem initializing settings.", e);
        }
    }

    private void loadFromXML(String xml) throws SAXException, IOException {
        if (xml != null && xml.trim().length() != 0) {
            byte[] currentXMLBytes = xml.getBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(currentXMLBytes);
            Document doc = XmlToolkit.loadDocumentFromStream((InputStream)byteArrayInputStream);
            Element myRoot = doc.getDocumentElement();
            this.getNotificationRegistry().initializeFromXml(myRoot);
        }
    }

    private NotificationRegistry getNotificationRegistry() {
        RJMXPlugin rJMXPlugin = RJMXPlugin.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.jrockit.mc.rjmx.notification.internal.NotificationRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (NotificationRegistry)rJMXPlugin.getService(clazz);
    }

    public String getSaveXML() throws IOException {
        Document document = XmlToolkit.createNewDocument();
        this.getNotificationRegistry().exportToXml(document.getDocumentElement());
        return XmlToolkit.prettyPrint((Element)document.getDocumentElement());
    }

    public void doSave() {
        IPreferenceStore store = RJMXPlugin.getDefault().getPreferenceStore();
        try {
            store.setValue(TRIGGERS_PREFERENCE_KEY, this.getSaveXML());
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not initiate settings from XML!", e);
        }
    }
}

