/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.internal;

import com.jrockit.mc.rjmx.core.internal.Messages;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.osgi.util.NLS;

public final class TimeRangeToolkit {
    private static final long NANOS = 1L;
    private static final long MICROS = 1000L;
    private static final long MILLIS = 1000000L;
    private static final long SECONDS = 1000000000L;
    private static final long MINUTES = 60000000000L;
    private static final long HOURS = 3600000000000L;
    private static final long DAYS = 86400000000000L;
    private static final long WEEKS = 604800000000000L;
    private static final long MONTHS = 2419200000000000L;
    private static final long YEARS = 31536000000000000L;
    private static final long[] VALUE_ARRAY = new long[]{1L, 1000L, 1000000L, 1000000000L, 60000000000L, 3600000000000L, 86400000000000L, 604800000000000L, 2419200000000000L, 31536000000000000L};
    private static final String[][] UNIT_ARRAY = new String[][]{{"ns", "nanos", "nanoseconds"}, {"\u03bcs", "micros", "microseconds"}, {"ms", "millis", "milliseconds"}, {"s", "seconds"}, {"min", "minutes", "m"}, {"h", "hours"}, {"days", "d"}, {"weeks", "w"}, {"months", "M"}, {"years", "y"}};

    public static long parseMillis(String timerange) throws Exception {
        long nanos = TimeRangeToolkit.parseNanos(timerange);
        if (nanos < 1000000L && nanos != 0L) {
            throw new Exception(NLS.bind((String)"Value {0} is too small.", (Object)timerange));
        }
        if (nanos < 86400000000000L) {
            return Math.round((double)nanos / 1000000.0);
        }
        return nanos / 1000000L;
    }

    public static long parseNanos(String timerange) throws Exception {
        TimeHolder holder = null;
        try {
            holder = new TimeHolder(timerange);
        }
        catch (NumberFormatException e) {
            throw new Exception(Messages.TimeRangeToolkit_ERROR_MESSAGE_COULD_NOT_PARSE);
        }
        if (holder.unit == null || "".equals(holder.unit)) {
            throw new Exception(NLS.bind((String)Messages.TimeRangeToolkit_ERROR_MESSAGE_NO_UNIT, (Object)String.valueOf(holder.value)));
        }
        int i = 0;
        while (i < VALUE_ARRAY.length) {
            if (TimeRangeToolkit.isCompatibleUnit(holder, UNIT_ARRAY[i])) {
                return TimeRangeToolkit.multiply(holder.value, VALUE_ARRAY[i]);
            }
            ++i;
        }
        throw new Exception(NLS.bind((String)Messages.TimeRangeToolkit_ERROR_MESSAGE_NOT_RECOGNIZED_UNIT, (Object)holder.unit));
    }

    private static long multiply(Number value, long l) {
        if (value instanceof Long) {
            return value.longValue() * l;
        }
        return Math.round(value.doubleValue() * (double)l);
    }

    private static boolean isCompatibleUnit(TimeHolder holder, String[] units) {
        int i = 0;
        while (i < units.length) {
            if (units[i].equals(holder.unit)) {
                return true;
            }
            if (TimeRangeToolkit.checkSingularis(units[i], holder.unit)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean checkSingularis(String unitToTest, String unit) {
        return unitToTest.endsWith("s") && unitToTest.length() >= 3 && unit.equals(unitToTest.substring(0, unitToTest.length() - 1));
    }

    public static String convertMillisToNormalizedString(long millis) {
        if (millis == 0L) {
            return "0 " + UNIT_ARRAY[2][0];
        }
        return TimeRangeToolkit.convertNanosToNormalizedString(millis * 1000000L);
    }

    public static String convertNanosToNormalizedString(long nanos) {
        if (nanos == 0L) {
            return String.valueOf(String.valueOf(nanos)) + ' ' + UNIT_ARRAY[0][0];
        }
        int i = VALUE_ARRAY.length - 1;
        while (i >= 0) {
            if (TimeRangeToolkit.divisibleBy(nanos, VALUE_ARRAY[i])) {
                long value = nanos / VALUE_ARRAY[i];
                String unit = value == 1L ? TimeRangeToolkit.singularilize(UNIT_ARRAY[i][0]) : UNIT_ARRAY[i][0];
                return String.valueOf(String.valueOf(value)) + ' ' + unit;
            }
            --i;
        }
        return String.valueOf(String.valueOf(nanos)) + ' ' + UNIT_ARRAY[0][0];
    }

    private static String singularilize(String unit) {
        if (unit.endsWith("s") && unit.length() >= 3) {
            return unit.substring(0, unit.length() - 1);
        }
        return unit;
    }

    private static boolean divisibleBy(long millis, long factor) {
        return millis % factor == 0L;
    }

    private static class TimeHolder {
        final Number value;
        final String unit;

        public TimeHolder(String range) throws ParseException {
            range = range.trim();
            int index = 0;
            String val = "";
            while (index < range.length() && (Character.isDigit(range.charAt(index)) || this.isDecimalComma(range.charAt(index)))) {
                val = String.valueOf(val) + range.charAt(index++);
            }
            this.value = NumberFormat.getNumberInstance().parse(val);
            this.unit = range.substring(index).trim();
        }

        private boolean isDecimalComma(char c) {
            return c == '.' || c == ',';
        }
    }
}

