/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.core.internal;

import com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.preference.IPreferenceStore;

public class PersistenceSettingsManager
implements Observer {
    private final IPreferenceStore m_preferenceStore;
    private final PersistenceSettings m_persistenceSettings;
    public static final String PROPERTY_PATH_PERSISTANCE_DIRECTORY = "rjmx.services.persistence.directory";
    public static final String PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION = "rjmx.services.persistence.log.rotation";
    public static final String PROPERTY_LONG_LOG_ROTATION_LIMIT = "rjmx.services.persistence.log.rotation.limit";
    public static final String PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT = "rjmx.services.persistence.log.limit";
    public static final String PROPERTY_LONG_MAX_TOTAL_LOG_SIZE = "rjmx.services.persistence.log.limit.max.size";

    public PersistenceSettingsManager(IPreferenceStore preferenceStore, PersistenceSettings persistenceSettings) {
        this.m_preferenceStore = preferenceStore;
        this.m_persistenceSettings = persistenceSettings;
        this.getSettings().addObserver((Observer)this);
    }

    public IPreferenceStore getStore() {
        return this.m_preferenceStore;
    }

    public PersistenceSettings getSettings() {
        return this.m_persistenceSettings;
    }

    public void update(Observable o, Object arg) {
        this.loadPersistenceSettings();
    }

    public void initPersistenceSettings() {
        this.getStore().setDefault(PROPERTY_PATH_PERSISTANCE_DIRECTORY, PersistenceSettings.getDefaultDirectory().getPath());
        this.getStore().setDefault(PROPERTY_LONG_LOG_ROTATION_LIMIT, 100000L);
        this.getStore().setDefault(PROPERTY_LONG_MAX_TOTAL_LOG_SIZE, 100000000L);
        this.getStore().setDefault(PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT, false);
        this.getStore().setDefault(PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION, true);
    }

    public void loadPersistenceSettings() {
        this.getStore().setValue(PROPERTY_PATH_PERSISTANCE_DIRECTORY, this.getSettings().getPersistenceDirectory().getPath());
        this.getStore().setValue(PROPERTY_LONG_LOG_ROTATION_LIMIT, this.getSettings().getMaxFileSize());
        this.getStore().setValue(PROPERTY_LONG_MAX_TOTAL_LOG_SIZE, this.getSettings().getMaxTotalLogSize());
        this.getStore().setValue(PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT, this.getSettings().isMaximumLogSizeEnabled());
        this.getStore().setValue(PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION, this.getSettings().isLogRotationEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePersistenceSettings() {
        PersistenceSettings persistenceSettings = this.getSettings();
        synchronized (persistenceSettings) {
            this.getSettings().setMaxFileSize(this.getStore().getLong(PROPERTY_LONG_LOG_ROTATION_LIMIT));
            this.getSettings().setMaxTotalLogSize(this.getStore().getLong(PROPERTY_LONG_MAX_TOTAL_LOG_SIZE));
            this.getSettings().enableLogRotation(this.getStore().getBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION));
            this.getSettings().enableLimitMaximumLogSize(this.getStore().getBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT));
            this.getSettings().setPersistenceDirectory(new File(this.getStore().getString(PROPERTY_PATH_PERSISTANCE_DIRECTORY)));
            this.getSettings().notifyObservers();
        }
    }
}

